/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.braille;

import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001a\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u001e\u0010\n\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\f\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J*\u0010\r\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u000e\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\bJ\u001a\u0010\u0018\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0016\u001a\u00020\bH\u0002J\u001e\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J\u001e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013J*\u0010\u0018\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/utils/braille/BrailleUnicodeConverter;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "UPPERCASE_ASCII_BRAILLE", "", "LOWERCASE_ASCII_BRAILLE", "unicodeToAsciiUppercase", "unicodeString", "unicodeToAsciiLouis", "unicodeToAscii", "asciiMap", "", "cbuf", "", "offset", "", "length", "asciiToUnicodeUppercase", "asciiString", "asciiToUnicodeLouis", "asciiToUnicode", "utils"})
public final class BrailleUnicodeConverter {
    @NotNull
    public static final BrailleUnicodeConverter INSTANCE = new BrailleUnicodeConverter();
    private static final Logger log = LoggerFactory.getLogger(BrailleUnicodeConverter.class);
    @NotNull
    public static final String UPPERCASE_ASCII_BRAILLE = " A1B'K2L@CIF/MSP\"E3H9O6R^DJG>NTQ,*5<-U8V.%[$+X!&;:4\\0Z7(_?W]#Y)=";
    @JvmField
    @NotNull
    public static final String LOWERCASE_ASCII_BRAILLE;

    private BrailleUnicodeConverter() {
    }

    @NotNull
    public final String unicodeToAsciiUppercase(@NotNull String unicodeString) {
        Intrinsics.checkNotNullParameter((Object)unicodeString, (String)"unicodeString");
        return this.unicodeToAscii(UPPERCASE_ASCII_BRAILLE, unicodeString);
    }

    @NotNull
    public final String unicodeToAsciiLouis(@NotNull String unicodeString) {
        Intrinsics.checkNotNullParameter((Object)unicodeString, (String)"unicodeString");
        return this.unicodeToAscii(LOWERCASE_ASCII_BRAILLE, unicodeString);
    }

    private final String unicodeToAscii(String asciiMap, String unicodeString) {
        char[] cArray = unicodeString.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cbuf = cArray;
        this.unicodeToAscii(asciiMap, cbuf, 0, cbuf.length);
        return new String(cbuf);
    }

    public final void unicodeToAsciiUppercase(@NotNull char[] cbuf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.unicodeToAscii(UPPERCASE_ASCII_BRAILLE, cbuf, offset, length);
    }

    public final void unicodeToAsciiLouis(@NotNull char[] cbuf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.unicodeToAscii(LOWERCASE_ASCII_BRAILLE, cbuf, offset, length);
    }

    private final void unicodeToAscii(String asciiMap, char[] cbuf, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            char orig = cbuf[i];
            boolean bl = '\u2800' <= orig ? orig < '\u2880' : false;
            if (!bl) continue;
            if (Intrinsics.compare((int)orig, (int)10304) >= 0) {
                char start = orig;
                int n2 = orig & 0xFFFFFF3F;
                if (n2 < 0 || n2 > 65535) {
                    throw new IllegalArgumentException("Invalid Char code: " + n2);
                }
                orig = (char)n2;
                String string = Character.getName(start);
                String string2 = Character.getName(orig);
                String string3 = asciiMap;
                Intrinsics.checkNotNull((Object)string3);
                log.trace("Converted " + string + " to " + string2 + " ascii " + string3.charAt(orig - 10240));
            }
            int asciiBrailleOffset = orig - 10240;
            String string = asciiMap;
            Intrinsics.checkNotNull((Object)string);
            cbuf[i] = string.charAt(asciiBrailleOffset);
            if (cbuf[i] != '|' || i < offset + 1 || i > offset + length - 1 || cbuf[i - 1] != '\'' || cbuf[i + 1] != '\u282d') continue;
            cbuf[i] = 92;
        }
    }

    @NotNull
    public final String asciiToUnicodeUppercase(@NotNull String asciiString) {
        Intrinsics.checkNotNullParameter((Object)asciiString, (String)"asciiString");
        return this.asciiToUnicode(UPPERCASE_ASCII_BRAILLE, asciiString);
    }

    @NotNull
    public final String asciiToUnicodeLouis(@NotNull String asciiString) {
        Intrinsics.checkNotNullParameter((Object)asciiString, (String)"asciiString");
        return this.asciiToUnicode(LOWERCASE_ASCII_BRAILLE, asciiString);
    }

    private final String asciiToUnicode(String asciiMap, String asciiString) {
        char[] cArray = asciiString.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        char[] cbuf = cArray;
        this.asciiToUnicode(asciiMap, cbuf, 0, cbuf.length);
        return new String(cbuf);
    }

    public final void asciiToUnicodeUppercase(@NotNull char[] cbuf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.asciiToUnicode(UPPERCASE_ASCII_BRAILLE, cbuf, offset, length);
    }

    public final void asciiToUnicodeLouis(@NotNull char[] cbuf, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)cbuf, (String)"cbuf");
        this.asciiToUnicode(LOWERCASE_ASCII_BRAILLE, cbuf, offset, length);
    }

    private final void asciiToUnicode(String asciiMap, char[] cbuf, int offset, int length) {
        int n = offset + length;
        for (int i = offset; i < n; ++i) {
            int orig = cbuf[i];
            Object[] objectArray = new Object[]{Integer.toHexString(orig), Character.valueOf(cbuf[i]), Character.getName(orig)};
            log.trace("----- Current char {} {} {}", objectArray);
            if (cbuf[i] == '\\' && i >= offset + 1 && i <= offset + length - 1 && cbuf[i - 1] == '\u2804' && cbuf[i + 1] == 'x') {
                log.trace("Using special liblouis marker");
                cbuf[i] = 10355;
                continue;
            }
            boolean bl = 65 <= orig ? orig < 91 : false;
            if (bl && Intrinsics.areEqual((Object)asciiMap, (Object)LOWERCASE_ASCII_BRAILLE)) {
                orig += 32;
            }
            String string = asciiMap;
            Intrinsics.checkNotNull((Object)string);
            int brlOffset = StringsKt.indexOf$default((CharSequence)string, (char)((char)orig), (int)0, (boolean)false, (int)6, null);
            if (brlOffset != -1) {
                orig = brlOffset + 10240;
                cbuf[i] = (char)orig;
                Object[] objectArray2 = new Object[]{brlOffset, Integer.toHexString(orig), Character.getName(orig)};
                log.trace("Converted to brl {} - {} {}", objectArray2);
                continue;
            }
            log.trace("Ignoring  " + Integer.toHexString(orig) + " " + Character.getName(orig));
        }
    }

    static {
        String string = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)UPPERCASE_ASCII_BRAILLE, (char)'[', (char)'{', (boolean)false, (int)4, null), (char)']', (char)'}', (boolean)false, (int)4, null), (char)'\\', (char)'|', (boolean)false, (int)4, null), (char)'^', (char)'~', (boolean)false, (int)4, null), (char)'@', (char)'`', (boolean)false, (int)4, null);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        LOWERCASE_ASCII_BRAILLE = string2;
    }
}

