/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbosserFactory;

public class EmbosserService {
    private static EmbosserService service;
    private final ServiceLoader<EmbosserFactory> serviceLoader = ServiceLoader.load(EmbosserFactory.class);

    private EmbosserService() {
    }

    public static synchronized EmbosserService getInstance() {
        if (service == null) {
            service = new EmbosserService();
        }
        return service;
    }

    public Stream<Embosser> getEmbosserStream() {
        return Streams.stream(this.serviceLoader).flatMap(ef -> ef.getEmbossers().stream());
    }

    public List<Embosser> getEmbossers() {
        return this.getEmbosserStream().collect(Collectors.toList());
    }

    public Embosser getEmbosser(String manufacturer, String model) {
        return this.getEmbosserStream().filter(e -> e.getManufacturer().equals(manufacturer) && e.getModel().equals(model)).findAny().orElseThrow(NoSuchElementException::new);
    }

    public Embosser getEmbosser(String id) {
        return this.getEmbosserStream().filter(e -> e.getId().equals(id)).findAny().orElseThrow(() -> new NoSuchElementException(String.format("Cannot find embosser driver with \"%s\"", id)));
    }
}

