/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.spi;

import com.google.common.base.Preconditions;
import org.brailleblaster.libembosser.embossing.attribute.BrailleCellType;
import org.brailleblaster.libembosser.embossing.attribute.Copies;
import org.brailleblaster.libembosser.embossing.attribute.PaperLayout;
import org.brailleblaster.libembosser.embossing.attribute.PaperMargins;
import org.brailleblaster.libembosser.embossing.attribute.PaperSize;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Layout;
import org.brailleblaster.libembosser.spi.Margins;
import org.brailleblaster.libembosser.spi.MultiSides;
import org.brailleblaster.libembosser.spi.Rectangle;

@Deprecated
public final class EmbossProperties {
    private final int copies;
    private final MultiSides sides;
    private final BrlCell cellType;
    private final Margins margins;
    private final Rectangle paper;

    public EmbossProperties() {
        this(null, null, BrlCell.NLS, 1);
    }

    public EmbossProperties(Rectangle paper, Margins margins, BrlCell cellType, int copies) {
        this(paper, margins, cellType, copies, MultiSides.P1ONLY);
    }

    public EmbossProperties(Rectangle paper, Margins margins, BrlCell cellType, int copies, MultiSides sides) {
        this.paper = paper;
        this.margins = margins;
        this.cellType = (BrlCell)((Object)Preconditions.checkNotNull((Object)((Object)cellType)));
        this.copies = copies;
        this.sides = (MultiSides)((Object)Preconditions.checkNotNull((Object)((Object)sides)));
    }

    public EmbossProperties copy() {
        return this.copy(null, null);
    }

    public EmbossProperties copy(String name, Object value) {
        Rectangle paper = this.paper;
        Margins margins = this.margins;
        BrlCell cellType = this.cellType;
        int copies = this.copies;
        MultiSides sides = this.sides;
        if (name != null) {
            switch (name) {
                case "paper": {
                    paper = (Rectangle)value;
                    break;
                }
                case "margins": {
                    margins = (Margins)value;
                    break;
                }
                case "cellType": {
                    cellType = (BrlCell)((Object)value);
                    break;
                }
                case "copies": {
                    copies = (Integer)value;
                    break;
                }
                case "sides": {
                    sides = (MultiSides)((Object)value);
                    break;
                }
            }
        }
        return new EmbossProperties(paper, margins, cellType, copies, sides);
    }

    public Rectangle getPaper() {
        return this.paper;
    }

    public EmbossProperties setPaper(Rectangle paper) {
        return this.copy("paper", paper);
    }

    public Margins getMargins() {
        return this.margins;
    }

    public EmbossProperties setMargins(Margins margins) {
        return this.copy("margins", margins);
    }

    public int getCopies() {
        return this.copies;
    }

    public EmbossProperties setCopies(int copies) {
        return this.copy("copies", copies);
    }

    public BrlCell getCellType() {
        return this.cellType;
    }

    public EmbossProperties setCellType(BrlCell cellType) {
        return this.copy("cellType", (Object)cellType);
    }

    public MultiSides getSides() {
        return this.sides;
    }

    public EmbossProperties setSides(MultiSides sides) {
        return this.copy("sides", (Object)sides);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.cellType == null ? 0 : this.cellType.hashCode());
        result = 31 * result + this.copies;
        result = 31 * result + (this.margins == null ? 0 : this.margins.hashCode());
        result = 31 * result + (this.paper == null ? 0 : this.paper.hashCode());
        result = 31 * result + (this.sides == null ? 0 : this.sides.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EmbossProperties other = (EmbossProperties)obj;
        if (this.cellType != other.cellType) {
            return false;
        }
        if (this.copies != other.copies) {
            return false;
        }
        if (this.margins == null ? other.margins != null : !this.margins.equals(other.margins)) {
            return false;
        }
        if (this.paper == null ? other.paper != null : !this.paper.equals(other.paper)) {
            return false;
        }
        return this.sides == other.sides;
    }

    public EmbossingAttributeSet toAttributeSet() {
        EmbossingAttributeSet attributes = new EmbossingAttributeSet();
        attributes.add(new Copies(this.getCopies()));
        attributes.add(new BrailleCellType(this.getCellType()));
        attributes.add(new PaperLayout(Layout.valueOf(this.getSides().name())));
        if (this.paper != null) {
            attributes.add(new PaperSize(this.paper));
        }
        if (this.margins != null) {
            attributes.add(new PaperMargins(this.margins));
        }
        return attributes;
    }
}

