/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import net.sourceforge.jeuclid.layout.JEuclidView;
import net.sourceforge.jeuclid.swing.CursorListener;
import net.sourceforge.jeuclid.swing.JMathComponent;
import net.sourceforge.jeuclid.swing.MathComponentUI;
import org.w3c.dom.Node;

public class JMathComponentMouseListener
implements MouseListener {
    private final JMathComponent mathComponent;

    public JMathComponentMouseListener(JMathComponent jMathComponent) {
        this.mathComponent = jMathComponent;
        assert (this.mathComponent.getCursorListener() != null) : "Cursorlistener is required by JMathComponentMouseListener";
    }

    @Override
    public final void mouseClicked(MouseEvent mouseEvent) {
        MathComponentUI mathComponentUI = this.mathComponent.getUI();
        List<JEuclidView.NodeRect> list = mathComponentUI.getNodesAt(this.mathComponent, mouseEvent.getX(), mouseEvent.getY());
        if (list != null && !list.isEmpty()) {
            Node node = list.get(list.size() - 1).getNode();
            CursorListener cursorListener = this.mathComponent.getCursorListener();
            if (cursorListener != null) {
                cursorListener.updateCursorPosition(node);
            }
        }
    }

    @Override
    public final void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public final void mouseExited(MouseEvent mouseEvent) {
    }
}

