/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.io.ByteStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import javax.print.Doc;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.PrintJobAttributeSet;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.event.PrintJobAttributeListener;
import javax.print.event.PrintJobEvent;
import javax.print.event.PrintJobListener;
import javax.print.event.PrintServiceAttributeListener;

public class EmbossToStreamPrintServiceFactory
extends StreamPrintServiceFactory {
    private static final DocFlavor[] DOC_FLAVORS = new DocFlavor[]{DocFlavor.INPUT_STREAM.AUTOSENSE};
    private static final String OUTPUT_FORMAT = "text/plain";

    @Override
    public StreamPrintService getPrintService(OutputStream out) {
        return new EmbossToStreamPrintService(out);
    }

    @Override
    public String getOutputFormat() {
        return OUTPUT_FORMAT;
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return Arrays.copyOf(DOC_FLAVORS, DOC_FLAVORS.length);
    }

    private static class EmbossDocPrintJob
    implements DocPrintJob {
        private final StreamPrintService printService;
        private final List<PrintJobListener> printJobListeners;

        protected EmbossDocPrintJob(StreamPrintService ps) {
            this.printService = ps;
            this.printJobListeners = new ArrayList<PrintJobListener>();
        }

        @Override
        public PrintService getPrintService() {
            return this.printService;
        }

        @Override
        public void addPrintJobAttributeListener(PrintJobAttributeListener listener, PrintJobAttributeSet attributes) {
        }

        @Override
        public void addPrintJobListener(PrintJobListener listener) {
            this.printJobListeners.add(listener);
        }

        @Override
        public PrintJobAttributeSet getAttributes() {
            return null;
        }

        @Override
        @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
        public void print(Doc doc, PrintRequestAttributeSet attributes) throws PrintException {
            Consumer<PrintJobListener> reporter;
            OutputStream out = this.printService.getOutputStream();
            try (InputStream in = doc.getStreamForBytes();){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
                PrintJobEvent pje = new PrintJobEvent(this, 102);
                reporter = l -> l.printJobCompleted(pje);
            }
            catch (IOException e) {
                PrintJobEvent pje = new PrintJobEvent(this, 103);
                reporter = l -> l.printJobFailed(pje);
            }
            this.printJobListeners.forEach(reporter);
        }

        @Override
        public void removePrintJobAttributeListener(PrintJobAttributeListener listener) {
        }

        @Override
        public void removePrintJobListener(PrintJobListener listener) {
            this.printJobListeners.remove(listener);
        }
    }

    private static class EmbossToStreamPrintService
    extends StreamPrintService {
        protected EmbossToStreamPrintService(OutputStream out) {
            super(out);
        }

        @Override
        public DocPrintJob createPrintJob() {
            return new EmbossDocPrintJob(this);
        }

        @Override
        public <T extends PrintServiceAttribute> T getAttribute(Class<T> category) {
            return null;
        }

        @Override
        public PrintServiceAttributeSet getAttributes() {
            return null;
        }

        @Override
        public Object getDefaultAttributeValue(Class<? extends Attribute> category) {
            return null;
        }

        @Override
        public String getName() {
            return "Copy stream";
        }

        @Override
        public ServiceUIFactory getServiceUIFactory() {
            return null;
        }

        @Override
        public Class<?>[] getSupportedAttributeCategories() {
            return null;
        }

        @Override
        public Object getSupportedAttributeValues(Class<? extends Attribute> category, DocFlavor flavor, AttributeSet attributes) {
            return null;
        }

        @Override
        public DocFlavor[] getSupportedDocFlavors() {
            return DOC_FLAVORS;
        }

        @Override
        public AttributeSet getUnsupportedAttributes(DocFlavor flavor, AttributeSet attributes) {
            return null;
        }

        @Override
        public boolean isAttributeCategorySupported(Class<? extends Attribute> category) {
            return false;
        }

        @Override
        public boolean isAttributeValueSupported(Attribute attrval, DocFlavor flavor, AttributeSet attributes) {
            return false;
        }

        @Override
        public boolean isDocFlavorSupported(DocFlavor flavor) {
            return Arrays.asList(DOC_FLAVORS).contains(flavor);
        }

        @Override
        public void removePrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        }

        @Override
        public String getOutputFormat() {
            return EmbossToStreamPrintServiceFactory.OUTPUT_FORMAT;
        }

        @Override
        public void addPrintServiceAttributeListener(PrintServiceAttributeListener listener) {
        }
    }
}

