/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.JSTargetableNode;
import com.oracle.truffle.js.nodes.access.PropertyNode;
import com.oracle.truffle.js.nodes.function.SpecializedNewObjectNodeGen;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGenerator;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSGenerator;
import com.oracle.truffle.js.runtime.builtins.JSNonProxy;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSOrdinary;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.Undefined;

public abstract class SpecializedNewObjectNode
extends JavaScriptBaseNode {
    protected final JSContext context;
    protected final boolean isBuiltin;
    protected final boolean isConstructor;
    protected final boolean isGenerator;
    protected final boolean isAsyncGenerator;
    @Node.Child
    private JSTargetableNode getPrototypeNode;
    protected final JSNonProxy instanceLayout;

    public SpecializedNewObjectNode(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator, JSNonProxy instanceLayout) {
        this.context = context;
        this.isBuiltin = isBuiltin;
        this.isConstructor = isConstructor;
        this.isGenerator = isGenerator;
        this.isAsyncGenerator = isAsyncGenerator;
        this.instanceLayout = instanceLayout;
        this.getPrototypeNode = !isBuiltin && isConstructor ? PropertyNode.createProperty(context, null, JSObject.PROTOTYPE) : null;
    }

    @NeverDefault
    public static SpecializedNewObjectNode create(JSContext context, boolean isBuiltin, boolean isConstructor, boolean isGenerator, boolean isAsyncGenerator, JSNonProxy instanceLayout) {
        return SpecializedNewObjectNodeGen.create(context, isBuiltin, isConstructor, isGenerator, isAsyncGenerator, instanceLayout);
    }

    @NeverDefault
    public static SpecializedNewObjectNode create(JSFunctionData functionData, JSOrdinary instanceLayout) {
        return SpecializedNewObjectNode.create(functionData.getContext(), functionData.isBuiltin(), functionData.isConstructor(), functionData.isGenerator(), functionData.isAsyncGenerator(), instanceLayout);
    }

    public final JSDynamicObject execute(VirtualFrame frame, JSDynamicObject newTarget) {
        JSDynamicObject prototype = this.getPrototypeNode != null ? this.getPrototypeNode.executeWithTarget(frame, (Object)newTarget) : Undefined.instance;
        return this.execute(newTarget, (Object)prototype);
    }

    protected abstract JSDynamicObject execute(JSDynamicObject var1, Object var2);

    @NeverDefault
    protected Shape getShapeWithoutProto() {
        CompilerAsserts.neverPartOfCompilation();
        return JSObjectUtil.getProtoChildShape(null, this.instanceLayout, this.context);
    }

    @CompilerDirectives.TruffleBoundary
    JSObjectFactory makeBoundObjectFactory(Object prototype) {
        if (prototype instanceof JSObject) {
            JSObject jsproto = (JSObject)((Object)prototype);
            return JSObjectFactory.createBound(this.context, jsproto, JSObjectUtil.getProtoChildShape(jsproto, this.instanceLayout, this.context));
        }
        return null;
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()", "isJSObject(cachedPrototype)", "prototype == cachedPrototype"}, limit="context.getPropertyCacheLimit()")
    public JSDynamicObject doCachedProto(JSDynamicObject target, Object prototype, @Cached(value="prototype") Object cachedPrototype, @Cached(value="makeBoundObjectFactory(prototype)") JSObjectFactory factory) {
        JSRealm realm = this.getRealm();
        if (this.isAsyncGenerator) {
            return JSAsyncGenerator.create(factory, realm, (JSDynamicObject)((JSObject)((Object)cachedPrototype)));
        }
        if (this.isGenerator) {
            return JSGenerator.create(factory, realm, (JSDynamicObject)((JSObject)((Object)cachedPrototype)));
        }
        return JSOrdinary.create(factory, realm, (JSDynamicObject)((JSObject)((Object)cachedPrototype)));
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!context.isMultiContext()"}, replaces={"doCachedProto"})
    @ReportPolymorphism.Megamorphic
    public JSDynamicObject doUncachedProto(JSDynamicObject target, JSObject prototype, @Cached InlinedBranchProfile slowBranch) {
        if (this.isAsyncGenerator) {
            return JSAsyncGenerator.create(this.context, this.getRealm(), (JSDynamicObject)prototype);
        }
        if (this.isGenerator) {
            return JSGenerator.create(this.context, this.getRealm(), (JSDynamicObject)prototype);
        }
        Shape shape = JSObjectUtil.getProtoChildShape(prototype, this.instanceLayout, this.context, this, slowBranch);
        return JSOrdinary.create(this.context, shape, (JSDynamicObject)prototype);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "context.isMultiContext()", "prototypeClass != null", "prototypeClass.isInstance(prototype)"}, limit="1")
    public JSDynamicObject createWithProtoCachedClass(JSDynamicObject target, Object prototype, @CachedLibrary(limit="3") @Cached.Shared DynamicObjectLibrary setProtoNode, @Cached(value="getClassIfJSObject(prototype)") Class<?> prototypeClass, @Cached(value="getShapeWithoutProto()") @Cached.Shared Shape cachedShape) {
        return this.createWithProto(target, (JSObject)((Object)prototypeClass.cast(prototype)), setProtoNode, cachedShape);
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "context.isMultiContext()"})
    public JSDynamicObject createWithProto(JSDynamicObject target, JSObject prototype, @CachedLibrary(limit="3") @Cached.Shared DynamicObjectLibrary setProtoNode, @Cached(value="getShapeWithoutProto()") @Cached.Shared Shape cachedShape) {
        JSRealm realm = this.getRealm();
        if (this.isAsyncGenerator) {
            return JSAsyncGenerator.create(this.context, realm, (JSDynamicObject)prototype);
        }
        if (this.isGenerator) {
            return JSGenerator.create(this.context, realm, (JSDynamicObject)prototype);
        }
        JSObject object = JSOrdinary.create(this.context, cachedShape, (JSDynamicObject)prototype);
        setProtoNode.put((DynamicObject)object, (Object)JSObject.HIDDEN_PROTO, (Object)prototype);
        return object;
    }

    @Specialization(guards={"!isBuiltin", "isConstructor", "!isJSObject(prototype)"})
    public JSDynamicObject createDefaultProto(JSDynamicObject target, Object prototype) {
        JSRealm realm = JSRuntime.getFunctionRealm((Object)target, this.getRealm());
        if (this.isAsyncGenerator) {
            return JSAsyncGenerator.create(this.context, realm);
        }
        if (this.isGenerator) {
            return JSGenerator.create(this.context, realm);
        }
        return JSOrdinary.create(this.context, realm);
    }

    @Specialization(guards={"isBuiltin", "isConstructor"})
    static JSDynamicObject builtinConstructor(JSDynamicObject target, Object proto) {
        return JSFunction.CONSTRUCT;
    }

    @Specialization(guards={"!isConstructor"})
    public JSDynamicObject throwNotConstructorFunctionTypeError(JSDynamicObject target, Object proto) {
        throw Errors.createTypeErrorNotAConstructor((Object)target, this.context);
    }
}

