/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xom;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000f\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u00008FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/utils/xom/NodeContext;", "", "node", "Lnu/xom/Node;", "parent", "index", "", "<init>", "(Lnu/xom/Node;Lorg/brailleblaster/utils/xom/NodeContext;I)V", "getNode", "()Lnu/xom/Node;", "privIndex", "getParent", "()Lorg/brailleblaster/utils/xom/NodeContext;", "setParent", "(Lorg/brailleblaster/utils/xom/NodeContext;)V", "value", "getIndex", "()I", "setIndex", "(I)V", "xom-utils"})
public final class NodeContext {
    @NotNull
    private final Node node;
    private int privIndex;
    @Nullable
    private NodeContext parent;

    public NodeContext(@NotNull Node node, @Nullable NodeContext parent, int index) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        this.node = node;
        this.privIndex = index;
        this.parent = parent;
    }

    @NotNull
    public final Node getNode() {
        return this.node;
    }

    @Nullable
    public final NodeContext getParent() {
        NodeContext nc = this.parent;
        if (nc == null) {
            ParentNode parentNode = this.node.getParent();
            if (parentNode != null) {
                this.parent = new NodeContext((Node)parentNode, null, 0);
            }
        } else {
            Node parentNode = nc.node;
            int n = parentNode.getChildCount();
            int n2 = this.privIndex;
            if (!(0 <= n2 ? n2 < n : false) || !Intrinsics.areEqual((Object)this.node, (Object)parentNode.getChild(this.privIndex))) {
                ParentNode actualParentNode = this.node.getParent();
                this.parent = actualParentNode == null ? null : new NodeContext((Node)actualParentNode, null, -1);
            }
        }
        return this.parent;
    }

    public final void setParent(@Nullable NodeContext nodeContext) {
        this.parent = nodeContext;
    }

    public final int getIndex() {
        NodeContext nc = this.getParent();
        int i = this.privIndex;
        if (nc == null) {
            this.privIndex = -1;
        } else if (nc.node instanceof ParentNode) {
            if (!(0 <= i ? i < ((ParentNode)nc.node).getChildCount() : false) || !Intrinsics.areEqual((Object)this.node, (Object)((ParentNode)nc.node).getChild(i))) {
                this.privIndex = ((ParentNode)nc.node).indexOf(this.node);
            }
        } else {
            this.privIndex = -1;
        }
        return this.privIndex;
    }

    public final void setIndex(int value) {
        this.privIndex = value;
    }
}

