/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utils.xom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\n\u001a\u0004\u0018\u00010\u0005J\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/utils/xom/XOMSerializer;", "", "<init>", "()V", "compress", "", "n", "Lnu/xom/Node;", "decompressElement", "Lnu/xom/Element;", "arr", "decompressDocument", "Lnu/xom/Document;", "decompress", "", "toDocument", "s", "toElement", "xom-utils"})
public final class XOMSerializer {
    @NotNull
    public static final XOMSerializer INSTANCE = new XOMSerializer();

    private XOMSerializer() {
    }

    @Nullable
    public final byte[] compress(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        String s = n.toXML();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzipOut = null;
        try {
            gzipOut = new GZIPOutputStream(baos);
            ObjectOutputStream objectOut = new ObjectOutputStream(gzipOut);
            objectOut.writeObject(s);
            objectOut.close();
            return baos.toByteArray();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
    }

    @Nullable
    public final Element decompressElement(@Nullable byte[] arr) {
        String s;
        String string = s = this.decompress(arr);
        return string != null ? this.toElement(string) : null;
    }

    @Nullable
    public final Document decompressDocument(@Nullable byte[] arr) {
        String s;
        String string = s = this.decompress(arr);
        return string != null ? this.toDocument(string) : null;
    }

    private final String decompress(byte[] arr) {
        if (arr != null) {
            ByteArrayInputStream bais = new ByteArrayInputStream(arr);
            GZIPInputStream gzipIn = null;
            try {
                gzipIn = new GZIPInputStream(bais);
                ObjectInputStream objectIn = new ObjectInputStream(gzipIn);
                Object object = objectIn.readObject();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
                String s = (String)object;
                objectIn.close();
                return s;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private final Document toDocument(String s) {
        try {
            Builder parser = new Builder(false);
            return parser.build(s, null);
        }
        catch (ParsingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private final Element toElement(String s) {
        try {
            Builder parser = new Builder(false);
            Document doc = parser.build(s, null);
            Element e = doc.getRootElement();
            return e.copy();
        }
        catch (ParsingException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

