/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import com.google.common.base.CharMatcher;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Element;
import org.apache.commons.lang3.StringUtils;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.utd.PageSettings;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;
import org.mwhapples.jlouis.Louis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class BRFWriter {
    public static final char NEWLINE = '\n';
    public static final char PAGE_SEPARATOR = '\f';
    public static final int OPTS_OUTPUT_ASCII = 2;
    public static final int OPTS_OUTPUT_UNICODE = 4;
    public static final int OPTS_DEBUG_OUTPUT = 8;
    public static final int OPTS_DEFAULT = 0;
    private static final Logger log = LoggerFactory.getLogger(BRFWriter.class);
    private final int opts;
    private char[][] grid;
    private final int maxCells;
    private final int maxLines;
    private int curCell;
    private int curLine;
    private final OutputCharStream output;
    public int brlPage = -1;
    public final UTDTranslationEngine engine;
    private boolean afterBookStart = false;
    private boolean nonsequentialPages = false;
    private int startOfSequence = -1;
    private int endOfSequence = -1;
    private String lastBrlNum;
    private String lastTranslatedBrlNum;
    private HashMap<Integer, NonsequentialState> nonsequentialMap;
    @NotNull
    private final InputPageListener inputPageListenerImpl = new InputPageListener();
    @NotNull
    private final PageListener outputPageListener;
    private StringBuilder pendingSpaces = new StringBuilder();
    @NotNull
    public static final PageListener EMPTY_PAGE_LISTENER = new PageListener(){};

    public BRFWriter(UTDTranslationEngine engine, OutputCharStream output, int opts, @NotNull PageListener outputPageListener) {
        this.opts = opts;
        this.outputPageListener = outputPageListener;
        this.engine = engine;
        this.output = output;
        PageSettings pageSettings = engine.getPageSettings();
        BrlCell cell = engine.getBrailleSettings().getCellType();
        log.debug("Drawable size {}x{}", (Object)pageSettings.getDrawableWidth(), (Object)pageSettings.getDrawableHeight());
        log.debug("Braille Cell type {} {}x{}", new Object[]{cell, cell.getWidth().doubleValue(), cell.getHeight().doubleValue()});
        this.maxCells = cell.getCellsForWidth(BigDecimal.valueOf(pageSettings.getDrawableWidth()));
        this.maxLines = cell.getLinesForHeight(BigDecimal.valueOf(pageSettings.getDrawableHeight()));
        log.debug("Created BrfGrid {}x{}", (Object)this.maxCells, (Object)this.maxLines);
        this.grid = new char[this.maxLines][this.maxCells];
    }

    public void append(String braille) {
        String textToAppend;
        block14: {
            int endSpaces;
            if (braille == null) {
                throw new NullPointerException("braille");
            }
            if (braille.isEmpty()) {
                log.info(this.debug("Skipping appending empty string on braille page {}", this.brlPage));
                return;
            }
            CharMatcher brailleSpaceMatcher = CharMatcher.whitespace().or(CharMatcher.anyOf((CharSequence)"\u2800"));
            boolean onlyBrailleSpace = brailleSpaceMatcher.matchesAllOf((CharSequence)braille);
            if (this.brlPage == -1) {
                if (onlyBrailleSpace) {
                    log.info("Ignoring whitespace prior to start of document");
                    return;
                }
                throw new BRFOutputException("Expected <newPage> before text on first page", new Object[0]);
            }
            if (onlyBrailleSpace) {
                this.pendingSpaces.append(braille);
                return;
            }
            if (!this.pendingSpaces.isEmpty()) {
                log.debug("Performing implicit moveTo due to pending spaces");
                this.moveTo(this.curCell + this.pendingSpaces.length(), this.curLine);
            }
            if ((endSpaces = UTDHelper.endsWithWhitespace(braille)) > 0) {
                this.pendingSpaces.append(braille.substring(braille.length() - endSpaces));
                braille = braille.substring(0, braille.length() - endSpaces);
                log.debug("Srink to '{}'", (Object)braille);
            }
            if (this.curCell + braille.length() > this.maxCells) {
                throw new BRFOutputException("String \"{}\" length {} is too long", braille, braille.length());
            }
            textToAppend = braille = braille.replace('\u00a0', ' ');
            try {
                String outputStr;
                boolean convertToUnicode;
                boolean convertToAscii = (2 & this.opts) == 2 && !this.engine.getBrailleSettings().isUseAsciiBraille();
                boolean bl = convertToUnicode = (4 & this.opts) == 4 && this.engine.getBrailleSettings().isUseAsciiBraille();
                if (!convertToAscii && !convertToUnicode) break block14;
                Louis trans = this.engine.getBrailleTranslator();
                Louis.WideChar input = new Louis.WideChar(braille);
                Louis.WideChar outputLouis = new Louis.WideChar(braille.length());
                if (convertToAscii) {
                    trans.dotsToChar(this.engine.getBrailleSettings().getMainTranslationTable(), input, outputLouis, braille.length(), 0);
                    outputStr = outputLouis.getText(outputLouis.length());
                    log.trace("Converted unicode '{}' to ascii '{}' brailleSettings {}", new Object[]{braille, outputStr, this.engine.getBrailleSettings().isUseAsciiBraille()});
                    textToAppend = outputStr;
                    break block14;
                }
                if (convertToUnicode) {
                    trans.charToDots(this.engine.getBrailleSettings().getMainTranslationTable(), input, outputLouis, braille.length(), 64);
                    outputStr = outputLouis.getText(outputLouis.length());
                    log.trace("Converted ascii '{}' to unicode '{}'", (Object)braille, (Object)outputStr);
                    textToAppend = outputStr;
                    break block14;
                }
                throw new IllegalStateException("Wrong options? " + this.opts);
            }
            catch (Exception e) {
                throw new BRFOutputException("Failed to translate", e, new Object[0]);
            }
        }
        for (char curChar : textToAppend.toCharArray()) {
            if (this.grid[this.curLine][this.curCell] != '\u0000') {
                throw new BRFOutputException("Cell already has value {}, line {}, braille {}", Character.valueOf(this.grid[this.curLine][this.curCell]), BRFWriter.debugLine(this.grid[this.curLine]), braille);
            }
            this.grid[this.curLine][this.curCell] = curChar;
            ++this.curCell;
        }
    }

    public void moveTo(int hPosCells, int vPosLines) {
        log.trace("Moving to hPos/cells {} vPos/lines {}", (Object)hPosCells, (Object)vPosLines);
        if (hPosCells < 0 || hPosCells >= this.maxCells) {
            throw new BRFOutputException("Invalid hPos, given {}", hPosCells);
        }
        if (vPosLines < 0 || vPosLines >= this.maxLines) {
            throw new BRFOutputException("Invalid vPos, given {}", vPosLines);
        }
        this.curCell = hPosCells;
        this.curLine = vPosLines;
        this.pendingSpaces = new StringBuilder();
    }

    public void newPage(int pageNum) {
        log.trace("New page {}", (Object)pageNum);
        if (this.brlPage == -1) {
            this.brlPage = pageNum;
        } else if (this.brlPage + 1 != pageNum && pageNum != 1 && !this.nonsequentialPages && this.engine.isTestMode()) {
            throw new BRFOutputException("Unexpected page jump, current {} given {}", this.brlPage, pageNum);
        }
        if (this.nonsequentialPages) {
            if (this.startOfSequence == -1) {
                this.startOfSequence = this.brlPage;
            }
            if (this.nonsequentialMap.containsKey(this.brlPage)) {
                throw new BRFOutputException("Duplicate page {}" + this.brlPage, new Object[0]);
            }
            this.endOfSequence = Math.max(this.endOfSequence, this.brlPage);
            this.nonsequentialMap.put(this.brlPage, new NonsequentialState(this.grid, this.lastTranslatedBrlNum, this.lastBrlNum, this.curCell, this.curLine));
            log.trace("Storing nonsequential page {}", (Object)this.brlPage);
        }
        if (!this.afterBookStart) {
            this.afterBookStart = true;
            return;
        }
        if (!this.nonsequentialPages) {
            this.flush(this.grid);
        }
        this.brlPage = pageNum;
        this.grid = new char[this.maxLines][this.maxCells];
        this.curLine = 0;
        this.curCell = 0;
        this.pendingSpaces = new StringBuilder();
    }

    public void onEndOfFile() {
        if (this.nonsequentialPages) {
            this.setNonsequential(false);
        }
        this.flush(this.grid);
        log.debug("Reached End Of File");
    }

    private void flush(char[][] grid) {
        log.trace("Flushing grid");
        try {
            int flushLine = 0;
            for (char[] curGridLine : grid) {
                int flushCell = 0;
                boolean ignore = false;
                for (char curGridCell : curGridLine) {
                    if (!ignore) {
                        if (curGridCell == '\u0000') {
                            if ((8 & this.opts) == 8) {
                                this.output.accept('.');
                            } else if (String.valueOf(curGridLine, flushCell, curGridLine.length - flushCell).trim().isEmpty()) {
                                ignore = true;
                            } else {
                                this.output.accept(' ');
                            }
                        } else {
                            this.output.accept(curGridCell);
                        }
                    }
                    Collection<PageEntry> pageEntries = this.inputPageListenerImpl.getEntryAtPos(flushCell, flushLine);
                    for (PageEntry curPageEntry : pageEntries) {
                        if (curPageEntry.isPrintPage) {
                            this.outputPageListener.onPrintPageNum(curPageEntry.braille, curPageEntry.orig);
                            continue;
                        }
                        this.outputPageListener.onBrlPageNum(curPageEntry.braille, curPageEntry.orig);
                    }
                    ++flushCell;
                }
                this.output.accept('\n');
                ++flushLine;
            }
            this.output.accept('\f');
            this.inputPageListenerImpl.onAfterFlush(this);
            this.outputPageListener.onAfterFlush(this);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to flush BRF grid", e);
        }
    }

    @NotNull
    public PageListener getInputPageListener() {
        return this.inputPageListenerImpl;
    }

    public void setNonsequential(boolean nonsequential) {
        if (!this.nonsequentialPages && nonsequential) {
            log.trace("Begin nonsequential pages");
            this.nonsequentialMap = new HashMap();
        } else if (this.nonsequentialPages && !nonsequential) {
            log.trace("End nonsequential pages");
            for (int i = this.startOfSequence; i <= this.endOfSequence; ++i) {
                if (!this.nonsequentialMap.containsKey(i)) {
                    throw new BRFOutputException("Page {} not found", i);
                }
                NonsequentialState state = this.nonsequentialMap.get(i);
                this.flush(state.grid);
                int tempCurCell = this.curCell;
                int tempCurLine = this.curLine;
                this.curCell = state.curCell;
                this.curLine = state.curLine;
                this.inputPageListenerImpl.onBrlPageNum(state.translatedBrlNum, state.brlNum);
                this.curCell = tempCurCell;
                this.curLine = tempCurLine;
            }
            this.startOfSequence = -1;
            this.endOfSequence = -1;
        }
        this.nonsequentialPages = nonsequential;
    }

    public void setNonsequentialBrlNum(String translatedBrlNum, String brlNum) {
        this.lastTranslatedBrlNum = translatedBrlNum;
        this.lastBrlNum = brlNum;
    }

    public static OutputCharStream lineEndingRewriter(OutputCharStream dest) {
        return givenChar -> {
            if (givenChar == '\n') {
                dest.accept('\r');
                dest.accept('\n');
            } else {
                dest.accept(givenChar);
            }
        };
    }

    private static String debugLine(char[] line) {
        StringBuilder builder = new StringBuilder();
        for (char curChar : line) {
            if (curChar == '\u0000') {
                builder.append(".");
                continue;
            }
            builder.append(curChar);
        }
        return builder.toString();
    }

    private static String formatString(String messagePattern, Object ... args) {
        return MessageFormatter.arrayFormat((String)messagePattern, (Object[])args).getMessage();
    }

    private String debug(String messagePattern, Object ... args) {
        return BRFWriter.formatString("BRF page {} position {}x{} max {}x{} - ", this.brlPage, this.curCell, this.curLine, this.maxCells, this.maxLines) + BRFWriter.formatString(messagePattern, args);
    }

    private class InputPageListener
    implements PageListener {
        private final Logger log = LoggerFactory.getLogger(InputPageListener.class);
        private final Map<Point, List<PageEntry>> pages = new HashMap<Point, List<PageEntry>>();

        private InputPageListener() {
        }

        @Override
        public void onBrlPageNum(String brlPageBraille, String brlPageOrig) {
            this.log.debug("At {}x{} braille page {} orig {}", new Object[]{BRFWriter.this.curCell, BRFWriter.this.curLine, brlPageBraille, brlPageOrig});
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{brlPageBraille, brlPageOrig})) {
                throw new IllegalArgumentException("blank: brlPageBraille " + brlPageBraille + " and/or brlPageOrig " + brlPageOrig);
            }
            if (BRFWriter.this.afterBookStart) {
                this.pages.computeIfAbsent(this.newPointCur(), k -> new ArrayList()).add(new PageEntry(brlPageBraille, brlPageOrig, false));
            }
        }

        @Override
        public void onPrintPageNum(String printPageBraille, String printPageOrig) {
            this.log.debug("At {}x{} print page {} orig {}", new Object[]{BRFWriter.this.curCell, BRFWriter.this.curLine, printPageBraille, printPageOrig});
            if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{printPageBraille, printPageOrig})) {
                throw new IllegalArgumentException("blank: printPageBraille '" + printPageBraille + "' and/or printPageOrig '" + printPageOrig + "'");
            }
            if (!BRFWriter.this.afterBookStart) {
                this.pages.clear();
            }
            this.pages.computeIfAbsent(this.newPointCur(), k -> new ArrayList()).add(new PageEntry(printPageBraille, printPageOrig, true));
        }

        private Point newPointCur() {
            int cell = BRFWriter.this.curCell >= BRFWriter.this.maxCells ? BRFWriter.this.maxCells - 1 : BRFWriter.this.curCell;
            int line = BRFWriter.this.curLine >= BRFWriter.this.maxLines ? BRFWriter.this.maxLines - 1 : BRFWriter.this.curLine;
            return new Point(cell, line);
        }

        public Collection<PageEntry> getEntryAtPos(int cell, int line) {
            Collection entries = this.pages.remove(new Point(cell, line));
            return entries == null ? Collections.emptyList() : entries;
        }

        @Override
        public void onAfterFlush(BRFWriter brfWriter) {
            if (!this.pages.isEmpty()) {
                throw new IllegalStateException("Pages isn't empty: " + String.valueOf(this.pages));
            }
        }
    }

    public static interface PageListener {
        default public void onBrlPageNum(String brlPageBraille, String brlPageOrig) {
        }

        default public void onPrintPageNum(String printPageBraille, String printPageOrig) {
        }

        default public void onBeforeBrl(BRFWriter brfWriter, Element brl) {
        }

        default public void onAfterFlush(BRFWriter brfWriter) {
        }
    }

    @FunctionalInterface
    public static interface OutputCharStream {
        public void accept(char var1) throws Exception;
    }

    protected class BRFOutputException
    extends RuntimeException {
        public BRFOutputException(String messagePattern, Object ... args) {
            this(messagePattern, null, args);
        }

        public BRFOutputException(String messagePattern, Throwable cause, Object ... args) {
            super(BRFWriter.this.debug(messagePattern, args), cause);
        }
    }

    private record NonsequentialState(char[][] grid, String translatedBrlNum, String brlNum, int curCell, int curLine) {
    }

    public record PageEntry(String braille, String orig, boolean isPrintPage) {
    }

    public record Point(int x, int y) {
    }
}

