/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.List;
import nu.xom.Node;
import org.brailleblaster.utd.ConditionalValue;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.formatters.LiteraryFormatter;
import org.brailleblaster.utd.formatters.MathFormatter;
import org.brailleblaster.utd.formatters.NumberedLineFormatter;
import org.brailleblaster.utd.formatters.NumberedProseFormatter;
import org.brailleblaster.utd.formatters.SkipFormatter;
import org.brailleblaster.utd.formatters.TPageFormatter;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.NumberLinePosition;
import org.brailleblaster.utd.properties.PageNumberType;
import org.brailleblaster.utd.properties.PageSide;
import org.brailleblaster.utd.tables.AutoTableFormatter;
import org.brailleblaster.utd.tables.FacingTableFormatter;
import org.brailleblaster.utd.tables.LinearTableFormatter;
import org.brailleblaster.utd.tables.ListedTableFormatter;
import org.brailleblaster.utd.tables.SimpleTableFormatter;
import org.brailleblaster.utd.tables.StairstepTableFormatter;
import org.brailleblaster.utd.toc.TOCFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IStyle {
    @NotNull
    public String getId();

    public List<ConditionalValue<Integer>> getLinesBeforeWhen();

    public List<ConditionalValue<Integer>> getAllLinesBeforeWhen();

    public int getLinesBefore();

    public List<ConditionalValue<Integer>> getLinesAfterWhen();

    public List<ConditionalValue<Integer>> getAllLinesAfterWhen();

    public int getLinesAfter();

    @Nullable
    public Integer getIndent();

    @Nullable
    public Integer getLineLength();

    @Nullable
    public Integer getFirstLineIndent();

    public NumberLinePosition getSkipNumberLines();

    public int getSkipPages();

    public Align getAlign();

    public Format getFormat();

    public int getNewPagesBefore();

    public int getNewPagesAfter();

    public PageSide getPageSide();

    public PageNumberType getBraillePageNumberFormat();

    public boolean isDontSplit();

    public boolean isKeepWithNext();

    public boolean isKeepWithPrevious();

    public int getOrphanControl();

    public int getLineSpacing();

    @NotNull
    public String getName();

    public boolean isTable();

    public boolean isTableRow();

    public boolean isTableCell();

    public String getEndSeparator();

    public boolean isGuideWords();

    public String getStartSeparator();

    public String getColor();

    public boolean isPageNum();

    public boolean isLineNumber();

    public boolean isVolumeEnd();

    @Nullable
    public Integer getLinesAfter(Node var1, NamespaceMap var2);

    @Nullable
    public Integer getLinesBefore(Node var1, NamespaceMap var2);

    public int getLeftPadding();

    public int getRightPadding();

    @NotNull
    public IStyle copy(@NotNull String var1, @NotNull String var2);

    public static enum Format {
        NORMAL(new LiteraryFormatter()),
        TOC(new TOCFormatter()),
        TPAGE(new TPageFormatter()),
        LINENUMBER(new NumberedLineFormatter()),
        PROSE(new NumberedProseFormatter()),
        SIMPLE(new SimpleTableFormatter()),
        LISTED(new ListedTableFormatter()),
        FACING(new FacingTableFormatter()),
        STAIRSTEP(new StairstepTableFormatter()),
        LINEAR(new LinearTableFormatter()),
        AUTO(new AutoTableFormatter()),
        MATH(new MathFormatter()),
        SKIP(new SkipFormatter());

        private final Formatter formatter;

        private Format(Formatter formatter) {
            this.formatter = formatter;
        }

        public Formatter getFormatter() {
            return this.formatter;
        }
    }
}

