/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import org.brailleblaster.utd.INodeMatcherMap;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u001f\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\b\u0002\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0010\b\u0001\u0010\u0002*\n\u0012\u0004\u0012\u0002H\u0001\u0018\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\u0010\u001a\u00020\u0011H\u0096\u0080\u0004J\u0012\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\u0004J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0080\u0004\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u001e\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\u001fJ\n\u0010 \u001a\u00020\u0013H\u0096\u0080\u0004J\u0015\u0010#\u001a\u00028\u00002\u0006\u0010$\u001a\u00020%H\u0016\u00a2\u0006\u0002\u0010&J!\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00028\u0000H\u0096\u0080\b\u00a2\u0006\u0002\u00107J \u00108\u001a\u00020\u00112\u0014\u00109\u001a\u0010\u0012\u0006\b\u0001\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000:H\u0096\u0080\u0004J\u0019\u0010;\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0014\u001a\u00020\u0015H\u0096\u0080\b\u00a2\u0006\u0002\u0010\u001fR\u0016\u0010\u0004\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR'\u0010\u0019\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00028\u00000\u001b0\u001a8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\u001a8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR$\u0010)\u001a\u00020(2\u0006\u0010'\u001a\u00020(8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0015\u0010.\u001a\u00020/8VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u001b\u00102\u001a\b\u0012\u0004\u0012\u00028\u0000038VX\u0096\u0084\b\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006<"}, d2={"Lorg/brailleblaster/utd/NodeMatcherMultiMap;", "T", "S", "Lorg/brailleblaster/utd/INodeMatcherMap;", "defaultValue", "<init>", "(Ljava/lang/Object;)V", "getDefaultValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "maps", "", "getMaps", "()Ljava/util/List;", "setMaps", "(Ljava/util/List;)V", "clear", "", "containsKey", "", "key", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "containsValue", "value", "(Ljava/lang/Object;)Z", "entries", "", "", "getEntries", "()Ljava/util/Set;", "get", "(Lorg/brailleblaster/utd/matchers/INodeMatcher;)Ljava/lang/Object;", "isEmpty", "keys", "getKeys", "findValue", "node", "Lnu/xom/Node;", "(Lnu/xom/Node;)Ljava/lang/Object;", "_", "Lorg/brailleblaster/utd/NamespaceMap;", "namespaces", "getNamespaces", "()Lorg/brailleblaster/utd/NamespaceMap;", "setNamespaces", "(Lorg/brailleblaster/utd/NamespaceMap;)V", "size", "", "getSize", "()I", "values", "", "getValues", "()Ljava/util/Collection;", "put", "(Lorg/brailleblaster/utd/matchers/INodeMatcher;Ljava/lang/Object;)Ljava/lang/Object;", "putAll", "from", "", "remove", "utd"})
public abstract class NodeMatcherMultiMap<T, S extends INodeMatcherMap<T>>
implements INodeMatcherMap<T> {
    private final T defaultValue;
    @NotNull
    private List<? extends S> maps;

    public NodeMatcherMultiMap(T defaultValue) {
        this.defaultValue = defaultValue;
        this.maps = new ArrayList();
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @NotNull
    public final List<S> getMaps() {
        return this.maps;
    }

    public final void setMaps(@NotNull List<? extends S> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.maps = list;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public boolean containsKey(@NotNull INodeMatcher key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean result = false;
        for (int i = 0; i < this.maps.size() && !result; ++i) {
            if (this.maps.get(i) == null) continue;
            S s = this.maps.get(i);
            Intrinsics.checkNotNull(s);
            result = ((INodeMatcherMap)s).containsKey(key);
        }
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean result = false;
        for (int i = 0; !result && i < this.maps.size(); ++i) {
            if (this.maps.get(i) == null) continue;
            S s = this.maps.get(i);
            Intrinsics.checkNotNull(s);
            result = ((INodeMatcherMap)s).containsValue(value);
        }
        return result;
    }

    @NotNull
    public Set<Map.Entry<INodeMatcher, T>> getEntries() {
        Set result = new HashSet();
        for (INodeMatcherMap map : this.maps) {
            if (map == null) continue;
            result.addAll(map.entrySet());
        }
        return result;
    }

    @Nullable
    public T get(@NotNull INodeMatcher key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        T result = null;
        for (int i = 0; result == null && i < this.maps.size(); ++i) {
            if (this.maps.get(i) == null) continue;
            S s = this.maps.get(i);
            Intrinsics.checkNotNull(s);
            result = (T)((INodeMatcherMap)s).get(key);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    public Set<INodeMatcher> getKeys() {
        Set result = new HashSet();
        for (INodeMatcherMap map : this.maps) {
            if (map == null) continue;
            result.addAll(map.keySet());
        }
        return result;
    }

    @Override
    public T findValue(@NotNull Node node) throws NoSuchElementException {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Object result = null;
        for (int i = 0; i < this.maps.size() && result == null; ++i) {
            if (this.maps.get(i) == null) continue;
            S s = this.maps.get(i);
            Intrinsics.checkNotNull(s);
            result = ((INodeMatcherMap)s).findValueWithDefault(node, null);
        }
        if (result == null) {
            throw new NoSuchElementException("No value found");
        }
        return result;
    }

    @Override
    @NotNull
    public NamespaceMap getNamespaces() {
        NamespaceMap nsMap = new NamespaceMap();
        for (INodeMatcherMap actionMap : this.maps) {
            if (actionMap == null) continue;
            NamespaceMap namespaces = actionMap.getNamespaces();
            for (String prefix : namespaces.getPrefixes()) {
                nsMap.addNamespace(prefix, namespaces.getNamespace(prefix));
            }
        }
        return nsMap;
    }

    @Override
    public void setNamespaces(@NotNull NamespaceMap namespaceMap) {
        Intrinsics.checkNotNullParameter((Object)namespaceMap, (String)"_");
    }

    public int getSize() {
        int size = 0;
        for (INodeMatcherMap map : this.maps) {
            if (map == null) continue;
            size += map.size();
        }
        return size;
    }

    @NotNull
    public Collection<T> getValues() {
        List result = new ArrayList();
        for (INodeMatcherMap map : this.maps) {
            if (map == null) continue;
            result.addAll(map.values());
        }
        return result;
    }

    @Override
    @Nullable
    public T put(@NotNull INodeMatcher key, T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@NotNull Map<? extends INodeMatcher, ? extends T> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        throw new UnsupportedOperationException();
    }

    @Nullable
    public T remove(@NotNull INodeMatcher key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        throw new UnsupportedOperationException();
    }
}

