/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import org.brailleblaster.libembosser.utils.BrailleMapper;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.GenericAction;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.properties.EmphasisType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\rH\u0014J\n\u0010\u0016\u001a\u00020\u0017H\u0096\u0080\u0004J\u0014\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0096\u0082\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lorg/brailleblaster/utd/actions/BaseEmphasisAction;", "Lorg/brailleblaster/utd/actions/IAction;", "<init>", "()V", "action", "Lorg/brailleblaster/utd/actions/GenericAction;", "emphasis", "Ljava/util/EnumSet;", "Lorg/brailleblaster/utd/properties/EmphasisType;", "getEmphasis", "()Ljava/util/EnumSet;", "applyTo", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "processEmphasis", "", "origNode", "processedInput", "hashCode", "", "equals", "", "other", "", "utd"})
public abstract class BaseEmphasisAction
implements IAction {
    @NotNull
    private final GenericAction action = new GenericAction();

    @NotNull
    protected abstract EnumSet<EmphasisType> getEmphasis();

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<TextSpan> processedInput = this.action.applyTo(node, context);
        for (TextSpan input : processedInput) {
            this.processEmphasis(node, input);
        }
        return processedInput;
    }

    protected void processEmphasis(@Nullable Node origNode, @NotNull TextSpan processedInput) {
        Intrinsics.checkNotNullParameter((Object)processedInput, (String)"processedInput");
        if (this.getEmphasis().contains((Object)EmphasisType.NO_TRANSLATE)) {
            String string = BrailleMapper.ASCII_TO_UNICODE_FAST.map(processedInput.getText());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"map(...)");
            processedInput.setText(string);
        }
        processedInput.getEmphasis().addAll((Collection<EmphasisType>)this.getEmphasis());
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getEmphasis());
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        BaseEmphasisAction o = (BaseEmphasisAction)other;
        return Intrinsics.areEqual(this.getEmphasis(), o.getEmphasis());
    }
}

