/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.IAction;
import org.brailleblaster.utd.actions.InsertAction;
import org.brailleblaster.utd.exceptions.UTDTranslateException;
import org.brailleblaster.utils.xom.NodeContext;
import org.brailleblaster.utils.xom.NodeContextKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0014J\u001e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\n\u0010\u0013\u001a\u00020\u0014H\u0096\u0080\u0004J\u0014\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0096\u0082\u0004\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/utd/actions/GenericAction;", "Lorg/brailleblaster/utd/actions/IAction;", "<init>", "()V", "processTextNode", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Text;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "processElement", "Lnu/xom/Element;", "applyTo", "Lnu/xom/Node;", "addActionAttributes", "", "n", "action", "hashCode", "", "equals", "", "other", "", "Companion", "utd"})
public class GenericAction
implements IAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<String> IGNORE_ACTION_NAMES;

    private final List<TextSpan> processTextNode(Text node, ITranslationEngine context) {
        Node node2 = (Node)node;
        String string = node.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        return CollectionsKt.listOf((Object)new TextSpan(node2, string, null, 4, null));
    }

    @NotNull
    protected List<TextSpan> processElement(@NotNull Element node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List processedInput = new ArrayList();
        IAction nodeAction = (IAction)context.getActionMap().findValueOrDefault((Node)node);
        if (nodeAction instanceof InsertAction) {
            Attribute attribute = node.getAttribute("inserted");
            if (attribute == null) {
                attribute = new Attribute("inserted", "false");
                node.addAttribute(attribute);
            }
            if (Intrinsics.areEqual((Object)attribute.getValue(), (Object)"false")) {
                Element span;
                attribute.setValue("true");
                String preInsert = ((InsertAction)nodeAction).getPreInsert();
                String postInsert = ((InsertAction)nodeAction).getPostInsert();
                if (preInsert != null) {
                    span = new Element("span", "http://brailleblaster.org/ns/utd");
                    span.addAttribute(new Attribute("table", "DIRECT"));
                    span.appendChild(preInsert);
                    node.insertChild((Node)span, 0);
                }
                if (postInsert != null) {
                    span = new Element("span", "http://brailleblaster.org/ns/utd");
                    span.addAttribute(new Attribute("table", "DIRECT"));
                    span.appendChild(postInsert);
                    node.appendChild((Node)span);
                }
            }
        }
        Object object = NodeContextKt.getNodeCache().getUnchecked((Object)node);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getUnchecked(...)");
        NodeContext parentContext = (NodeContext)object;
        for (int i = 0; i < node.getChildCount(); ++i) {
            Node child = node.getChild(i);
            Intrinsics.checkNotNull((Object)child);
            NodeContext nodeContext = new NodeContext(child, parentContext, i);
            NodeContextKt.getNodeCache().put((Object)child, (Object)nodeContext);
            IAction action = (IAction)context.getActionMap().findValueOrDefault(child);
            List<TextSpan> childTextSpans = action.applyTo(child, context);
            this.addActionAttributes(child, action);
            processedInput.addAll((Collection)childTextSpans);
        }
        return processedInput;
    }

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            if (node instanceof Text) {
                return this.processTextNode((Text)node, context);
            }
            if (node instanceof Element) {
                return this.processElement((Element)node, context);
            }
        }
        catch (UTDTranslateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UTDTranslateException("Failed at processing node " + node.toXML(), e);
        }
        return CollectionsKt.emptyList();
    }

    public final void addActionAttributes(@Nullable Node n, @Nullable IAction action) {
        if (action != null && IGNORE_ACTION_NAMES.contains(action.getClass().getSimpleName())) {
            return;
        }
        if (n instanceof Element && action != null) {
            Attribute actionAttribute = new Attribute("utd-action", action.getClass().getSimpleName());
            ((Element)n).addAttribute(actionAttribute);
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 89 * hash + Objects.hashCode(this.getClass());
        return hash;
    }

    public boolean equals(@Nullable Object other) {
        return other == null ? false : Intrinsics.areEqual(this.getClass(), other.getClass());
    }

    static {
        Object[] objectArray = new String[]{"GenericAction", "FlushAction", "GenericBlockAction"};
        IGNORE_ACTION_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/utd/actions/GenericAction$Companion;", "", "<init>", "()V", "IGNORE_ACTION_NAMES", "", "", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

