/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.TextSpan;
import org.brailleblaster.utd.actions.GenericAction;
import org.brailleblaster.utd.actions.IBlockAction;
import org.brailleblaster.utd.exceptions.UTDTranslateException;
import org.brailleblaster.utd.properties.BrailleTableType;
import org.brailleblaster.utd.properties.EmphasisType;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.TextTranslator;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utils.braille.BrailleUnicodeConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J$\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eJ6\u0010\u0019\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\t2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0014J \u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\u001fH\u0002J\n\u0010$\u001a\u00020\u001dH\u0096\u0080\u0004J\u0014\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010'H\u0096\u0082\u0004R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/brailleblaster/utd/actions/GenericBlockAction;", "Lorg/brailleblaster/utd/actions/GenericAction;", "Lorg/brailleblaster/utd/actions/IBlockAction;", "<init>", "()V", "translateText", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "applyTo", "", "Lorg/brailleblaster/utd/TextSpan;", "node", "Lnu/xom/Node;", "context", "Lorg/brailleblaster/utd/ITranslationEngine;", "translate", "tableType", "Lorg/brailleblaster/utd/properties/BrailleTableType;", "isPostIncidentalPunctuation", "", "c", "", "translateString", "", "toTranslate", "assignBrls", "translated", "", "endPos", "", "indexInts", "", "applyBrlElement", "input", "originalSpan", "indexPos", "hashCode", "equals", "other", "", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nGenericBlockAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericBlockAction.kt\norg/brailleblaster/utd/actions/GenericBlockAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,252:1\n1586#2:253\n1661#2,3:254\n1596#2:257\n1629#2,4:258\n3590#2,7:262\n*S KotlinDebug\n*F\n+ 1 GenericBlockAction.kt\norg/brailleblaster/utd/actions/GenericBlockAction\n*L\n110#1:253\n110#1:254,3\n110#1:257\n110#1:258,4\n133#1:262,7\n*E\n"})
public class GenericBlockAction
extends GenericAction
implements IBlockAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StringBuilder translateText = new StringBuilder();
    private static final Logger logger = LoggerFactory.getLogger(GenericBlockAction.class);
    @Nullable
    private static String ASCII_BRL_CHARS;
    public static final short NON_EMPHASIS_TYPEFORMS = 2048;

    @Override
    @NotNull
    public List<TextSpan> applyTo(@NotNull Node node, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.translate(node, BrailleTableType.LITERARY, context);
    }

    @NotNull
    protected List<TextSpan> translate(@NotNull Node node, @NotNull BrailleTableType tableType, @NotNull ITranslationEngine context) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<TextSpan> toTranslate = super.applyTo(node, context);
        int startIndex = 0;
        try {
            int n = ((Collection)toTranslate).size();
            for (int i = 0; i < n; ++i) {
                if (!toTranslate.get(i).isTranslated()) continue;
                List<TextSpan> subList = toTranslate.subList(startIndex, i);
                this.translateString(subList, tableType, context);
                startIndex = i + 1;
            }
            if (startIndex < toTranslate.size()) {
                List<TextSpan> subList = toTranslate.subList(startIndex, toTranslate.size());
                this.translateString(subList, tableType, context);
            }
        }
        catch (UTDTranslateException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UTDTranslateException("Failed at processing node " + node.toXML(), e);
        }
        return CollectionsKt.emptyList();
    }

    private final boolean isPostIncidentalPunctuation(char c) {
        switch (c) {
            case '!': 
            case ')': 
            case ',': 
            case '.': 
            case ':': 
            case ';': 
            case '>': 
            case '?': 
            case ']': 
            case '}': 
            case '\u2019': 
            case '\u201d': {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void translateString(@NotNull List<TextSpan> toTranslate, @NotNull BrailleTableType tableType, @NotNull ITranslationEngine context) {
        void $this$zip$iv;
        int cur;
        void $this$mapIndexedTo$iv$iv;
        int n;
        Iterable $this$mapTo$iv$iv;
        EnumSet<EmphasisType> set;
        Intrinsics.checkNotNullParameter(toTranslate, (String)"toTranslate");
        Intrinsics.checkNotNullParameter((Object)((Object)tableType), (String)"tableType");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (toTranslate.isEmpty()) {
            logger.info("Empty string is passed for translation");
            return;
        }
        this.translateText.setLength(0);
        List emphasisList = new ArrayList();
        List endPos = new ArrayList();
        for (TextSpan textSpan : toTranslate) {
            Iterator iterator;
            String inText = textSpan.getText();
            this.translateText.append(inText);
            endPos.add(this.translateText.length());
            set = textSpan.getEmphasis();
            Ref.ShortRef value = new Ref.ShortRef();
            Intrinsics.checkNotNullExpressionValue(set.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                EmphasisType type = (EmphasisType)((Object)iterator.next());
                value.element = (short)(value.element | type.getJlouisTypeform());
            }
            CollectionsKt.addAll((Collection)emphasisList, (Sequence)SequencesKt.take((Sequence)SequencesKt.generateSequence(() -> GenericBlockAction.translateString$lambda$0(value)), (int)textSpan.getText().length()));
        }
        EnumSet<EmphasisType> enumSet = (EnumSet<EmphasisType>)((Object)emphasisList);
        ArrayList<Short> arrayList = (ArrayList<Short>)CollectionsKt.listOf((Object)0);
        boolean $i$f$map = false;
        set = enumSet;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)enumSet, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            short s = ((Number)item$iv$iv).shortValue();
            Collection collection = destination$iv$iv;
            n = 0;
            collection.add((int)it);
        }
        Iterable iterable = CollectionsKt.windowed$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)arrayList, (Iterable)((List)destination$iv$iv)), (Object)0), (int)3, (int)1, (boolean)false, (int)4, null);
        boolean $i$f$mapIndexed = false;
        $this$mapTo$iv$iv = iterable;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void index;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            List list = (List)item$iv$iv;
            int n2 = n;
            arrayList = destination$iv$iv;
            boolean bl = false;
            int prev = ((Number)list.get(0)).intValue();
            cur = ((Number)list.get(1)).intValue();
            int next = ((Number)list.get(2)).intValue();
            int emphVal = cur;
            int curCodePoint = this.translateText.codePointAt((int)index);
            String string = ASCII_BRL_CHARS;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.indexOf$default((CharSequence)string, (char)((char)curCodePoint), (int)0, (boolean)false, (int)6, null) < 0) {
                emphVal -= emphVal & 0x800;
            }
            switch (curCodePoint) {
                case 61440: 
                case 61441: {
                    emphVal = emphVal & prev & next;
                }
            }
            arrayList.add((short)emphVal);
        }
        short[] emphasisArr = CollectionsKt.toShortArray((Collection)((List)destination$iv$iv));
        boolean bl = false;
        boolean puncFlag = false;
        int puncStart = 0;
        boolean bl2 = false;
        puncFlag = false;
        puncStart = 0;
        int emphasis = 0;
        short preWordEmp = 0;
        int wordCount = 0;
        Iterable item$iv$iv = StringsKt.withIndex((CharSequence)this.translateText);
        Iterable other$iv = ArraysKt.asIterable((short[])emphasisArr);
        boolean $i$f$zip = false;
        Iterator first$iv = $this$zip$iv.iterator();
        Iterator second$iv = other$iv.iterator();
        ArrayList<Short> list$iv = new ArrayList<Short>(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), CollectionsKt.collectionSizeOrDefault((Iterable)other$iv, (int)10)));
        while (first$iv.hasNext() && second$iv.hasNext()) {
            void v;
            cur = ((Number)second$iv.next()).shortValue();
            IndexedValue indexedValue = (IndexedValue)first$iv.next();
            arrayList = list$iv;
            boolean bl3 = false;
            int i = indexedValue.component1();
            char c = ((Character)indexedValue.component2()).charValue();
            arrayList.add((Short)new Triple((Object)i, (Object)Character.valueOf(c), (Object)((short)v)));
        }
        for (Triple triple : (List)list$iv) {
            boolean bl4;
            int i = ((Number)triple.component1()).intValue();
            char c = ((Character)triple.component2()).charValue();
            short e = ((Number)triple.component3()).shortValue();
            if (puncFlag) {
                if (!this.isPostIncidentalPunctuation(c)) {
                    puncFlag = false;
                }
            } else if (bl4 && this.isPostIncidentalPunctuation(c)) {
                puncStart = i;
                puncFlag = true;
            }
            bl4 = true;
            wordCount = preWordEmp == e ? ++wordCount : 1;
            preWordEmp = e;
            emphasis = e;
        }
        if (puncFlag && wordCount > 2) {
            emphasis = (short)(emphasis - (short)(emphasis & 0x800));
            int n3 = this.translateText.length();
            for (int j = puncStart; j < n3; ++j) {
                emphasisArr[j] = (short)(emphasisArr[j] | emphasis);
            }
        }
        TextTranslator.TranslationEmpResult translationEmpResult = TextTranslator.translateTextWithEmpArray(this.translateText.toString(), context, emphasisArr, tableType);
        this.assignBrls(toTranslate, translationEmpResult.translation, endPos, translationEmpResult.dotsToCharsMap);
    }

    protected void assignBrls(@NotNull List<TextSpan> toTranslate, @NotNull String translated, @NotNull List<Integer> endPos, @Nullable int[] indexInts) {
        Intrinsics.checkNotNullParameter(toTranslate, (String)"toTranslate");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        Intrinsics.checkNotNullParameter(endPos, (String)"endPos");
        if (indexInts != null) {
            int beginIndex = 0;
            int startSegment = 0;
            int n = ((Collection)endPos).size();
            for (int i = 0; i < n; ++i) {
                String translatedSegment;
                int endIndex;
                int endSegment = ((Number)endPos.get(i)).intValue();
                for (endIndex = beginIndex; endIndex < translated.length() && indexInts[endIndex] < endSegment; ++endIndex) {
                }
                Intrinsics.checkNotNullExpressionValue((Object)translated.substring(beginIndex, endIndex), (String)"substring(...)");
                int[] indexSegments = new int[translatedSegment.length()];
                int n2 = ((CharSequence)translatedSegment).length();
                for (int j = 0; j < n2; ++j) {
                    indexSegments[j] = indexInts[beginIndex + j] - startSegment;
                }
                this.applyBrlElement(translatedSegment, toTranslate.get(i), indexSegments);
                beginIndex = endIndex;
                startSegment = endSegment;
            }
        }
    }

    private final void applyBrlElement(String input, TextSpan originalSpan, int[] indexPos) {
        Element brlElement = UTDElements.BRL.create();
        if (((CharSequence)input).length() > 0) {
            brlElement.appendChild(input);
        }
        brlElement.addAttribute(new Attribute("index", ArraysKt.joinToString$default((int[])indexPos, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        Node inputNode = originalSpan.getNode();
        if (inputNode != null) {
            int index;
            ParentNode parentNode = inputNode.getParent();
            if (UTDHelper.getAssociatedBrlElement(parentNode, index = parentNode.indexOf(inputNode)) != null) {
                parentNode.removeChild(index + 1);
            }
            parentNode.insertChild((Node)brlElement, ++index);
        }
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 90 * hash + Objects.hashCode(this.getClass());
        return hash;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == null ? false : Intrinsics.areEqual(this.getClass(), other.getClass());
    }

    private static final Short translateString$lambda$0(Ref.ShortRef $value) {
        return $value.element;
    }

    static {
        String combinedStr = BrailleUnicodeConverter.LOWERCASE_ASCII_BRAILLE + " A1B'K2L@CIF/MSP\"E3H9O6R^DJG>NTQ,*5<-U8V.%[$+X!&;:4\\0Z7(_?W]#Y)=";
        StringBuilder abcBuilder = new StringBuilder(combinedStr.length());
        int n = ((CharSequence)combinedStr).length();
        for (int i = 0; i < n; ++i) {
            if (StringsKt.indexOf$default((CharSequence)combinedStr, (char)((char)combinedStr.codePointAt(i)), (int)0, (boolean)false, (int)6, null) != i) continue;
            abcBuilder.append(combinedStr.charAt(i));
        }
        ASCII_BRL_CHARS = abcBuilder.toString();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\n\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/utd/actions/GenericBlockAction$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ASCII_BRL_CHARS", "", "NON_EMPHASIS_TYPEFORMS", "", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

