/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.formatters;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/utd/formatters/SkipLinesFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "utd"})
public final class SkipLinesFormatter
extends Formatter {
    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        int n;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set<PageBuilder> mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (mutPageBuilders.isEmpty()) {
            return mutPageBuilders;
        }
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        String string = ((Element)node).getAttributeValue("skipLines", "http://brailleblaster.org/ns/utd");
        if (string == null) {
            return mutPageBuilders;
        }
        String skipLinesAttr = string;
        try {
            n = Integer.parseInt(skipLinesAttr);
        }
        catch (NumberFormatException e) {
            return mutPageBuilders;
        }
        int reserveLines = n;
        if (reserveLines < 1) {
            return mutPageBuilders;
        }
        Set<PageBuilder> pbs = mutPageBuilders;
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pbs);
        if (((Element)node).getAttribute("pageSide") != null) {
            String string2 = ((Element)node).getAttributeValue("pageSide");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            PageBuilderHelper.verifyPageSide(pageBuilder, string2);
        }
        int linesPerPage = pageBuilder.getLinesPerPage();
        int y = pageBuilder.getY();
        int firstBlank = Math.max(pageBuilder.findFirstBlankLineAfter(y), y);
        pageBuilder.setY(firstBlank);
        if (pageBuilder.getNewLinesOverride() > 0) {
            pbs.addAll((Collection)pageBuilder.processSpacing());
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pbs);
            pageBuilder.setIgnoreSpacing(false);
            y = pageBuilder.getY();
            firstBlank = RangesKt.coerceAtLeast((int)pageBuilder.findFirstBlankLineAfter(y), (int)y);
        }
        int keepWithLines = 0;
        if (pageBuilder.hasKeepWithNextQueued()) {
            keepWithLines = 1;
        }
        if (pageBuilder.hasRunningHead()) {
            ++reserveLines;
        }
        if (reserveLines > linesPerPage - firstBlank - keepWithLines || pageBuilder.getPendingPages() > 0) {
            pageBuilder.addAtLeastPages(1);
            pbs = pageBuilder.processSpacing();
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pbs);
            pageBuilder.addSkipLines(reserveLines);
        } else {
            pageBuilder.addSkipLines(reserveLines);
        }
        return pbs;
    }
}

