/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.internal.xml;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.exceptions.UTDException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\u0007\u001a\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\n2\n\u0010\u0004\u001a\u00020\u0005\"\u00020\u000b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"log", "Lorg/slf4j/Logger;", "checkSortedAndUniqueSplitPositions", "", "splitPos", "", "shallowcopy", "Lnu/xom/Element;", "splitNode", "", "Lnu/xom/Text;", "", "utd"})
@SourceDebugExtension(value={"SMAP\nXMLHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XMLHandler.kt\norg/brailleblaster/utd/internal/xml/XMLHandlerKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,626:1\n1#2:627\n*E\n"})
public final class XMLHandlerKt {
    @NotNull
    private static final Logger log;

    private static final boolean checkSortedAndUniqueSplitPositions(int[] splitPos) {
        int lastPos = 0;
        for (int curSplitPos : splitPos) {
            if (curSplitPos <= lastPos) {
                return false;
            }
            lastPos = curSplitPos;
        }
        return true;
    }

    @NotNull
    public static final Element shallowcopy(@NotNull Element $this$shallowcopy) {
        Intrinsics.checkNotNullParameter((Object)$this$shallowcopy, (String)"<this>");
        try {
            Class[] classArray = new Class[]{Element.class};
            Method method = Element.class.getDeclaredMethod("copyTag", classArray);
            method.setAccessible(true);
            Object[] objectArray = new Object[]{$this$shallowcopy};
            Object object = method.invoke(null, objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type nu.xom.Element");
            return (Element)object;
        }
        catch (Exception e) {
            throw new UTDException("Failed to invoke writeStartTag method", e);
        }
    }

    @NotNull
    public static final List<Text> splitNode(@NotNull Text $this$splitNode, int ... splitPos) {
        Intrinsics.checkNotNullParameter((Object)$this$splitNode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)splitPos, (String)"splitPos");
        String string = $this$splitNode.getValue();
        String string2 = Arrays.toString(splitPos);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        log.trace("Input string '{}' split {}", (Object)string, (Object)string2);
        if ($this$splitNode.getParent() == null) {
            boolean $i$a$-requireNotNull-XMLHandlerKt$splitNode$22 = false;
            String $i$a$-requireNotNull-XMLHandlerKt$splitNode$22 = "TextNode must have parent";
            throw new IllegalArgumentException($i$a$-requireNotNull-XMLHandlerKt$splitNode$22.toString());
        }
        if (!(!(splitPos.length == 0))) {
            boolean $i$a$-require-XMLHandlerKt$splitNode$32 = false;
            String $i$a$-require-XMLHandlerKt$splitNode$32 = "Must specify Positions to split";
            throw new IllegalArgumentException($i$a$-require-XMLHandlerKt$splitNode$32.toString());
        }
        if (!XMLHandlerKt.checkSortedAndUniqueSplitPositions(splitPos)) {
            throw new NodeException("Positions must be sorted and unique, positions=" + splitPos, (Node)$this$splitNode, null, 4, null);
        }
        List replacementNodes = new ArrayList();
        String text = $this$splitNode.getValue();
        int lastStart = 0;
        int insertIndex = $this$splitNode.getParent().indexOf((Node)$this$splitNode);
        IntIterator splitPosItr = ArrayIteratorsKt.iterator((int[])splitPos);
        while (lastStart != text.length()) {
            boolean finished = false;
            String textPart = null;
            if (splitPosItr.hasNext()) {
                int curSplitPos = splitPosItr.nextInt();
                Intrinsics.checkNotNull((Object)text);
                String string3 = text.substring(lastStart, curSplitPos);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                textPart = string3;
                lastStart = curSplitPos;
            } else {
                Intrinsics.checkNotNull((Object)text);
                String string4 = text.substring(lastStart);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                textPart = string4;
                finished = true;
            }
            Text replacementNode = new Text(textPart);
            $this$splitNode.getParent().insertChild((Node)replacementNode, insertIndex++);
            replacementNodes.add(replacementNode);
            if (!finished) continue;
        }
        $this$splitNode.detach();
        return CollectionsKt.toList((Iterable)replacementNodes);
    }

    public static final /* synthetic */ Logger access$getLog$p() {
        return log;
    }

    static {
        Logger logger = LoggerFactory.getLogger(XMLHandler.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }
}

