/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.tables;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.exceptions.BadSimpleTableException;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.tables.SimpleTableFormatter;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002J2\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002J~\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0012\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00142\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0002\u00a8\u0006 "}, d2={"Lorg/brailleblaster/utd/tables/FacingTableFormatter;", "Lorg/brailleblaster/utd/tables/SimpleTableFormatter;", "<init>", "()V", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "addNewPage", "curPB", "removeCellsFromPageBuilders", "", "leftCells", "", "Lorg/brailleblaster/utd/tables/SimpleTableFormatter$TableCell;", "rightCells", "handleBadFacingTable", "leftTable", "Lnu/xom/Element;", "rightTable", "pbs", "startingPBSize", "", "leftOriginalTable", "rightOriginalTable", "utd"})
public final class FacingTableFormatter
extends SimpleTableFormatter {
    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element) || ((Element)node).getChildCount() == 0) {
            return mutPageBuilders;
        }
        TableUtils.INSTANCE.deleteExistingTable(node);
        int startingPBSize = mutPageBuilders.size();
        BrlCell cellType = formatSelector.engine.getBrailleSettings().getCellType();
        if (((Element)node).getChildElements().size() == 0) {
            return mutPageBuilders;
        }
        Element leftTable = null;
        Element rightTable = null;
        int n = ((Element)node).getChildElements().size();
        for (int i = 0; i < n; ++i) {
            Element child;
            Intrinsics.checkNotNullExpressionValue((Object)((Element)node).getChildElements().get(i), (String)"get(...)");
            if (Intrinsics.areEqual((Object)"utd:tableSimple", (Object)child.getAttributeValue("class"))) {
                child.addAttribute(new Attribute("class", "utd:reformat"));
            }
            if (!UTDHelper.containsBrl((Node)child)) continue;
            if (leftTable == null) {
                leftTable = child;
                continue;
            }
            rightTable = child;
        }
        Element element = leftTable;
        if (element == null) {
            String i = "Required value was null.";
            throw new IllegalArgumentException(i.toString());
        }
        this.prepareTable(element, formatSelector);
        if (((Element)node).getChildElements().size() == 1 || rightTable == null) {
            return super.format((Node)leftTable, style, mutPageBuilders, formatSelector);
        }
        this.prepareTable(rightTable, formatSelector);
        leftTable.addAttribute(new Attribute("format", "simple"));
        rightTable.addAttribute(new Attribute("format", "simple"));
        Element leftOriginalTable = TableUtils.copyTable(leftTable);
        Element rightOriginalTable = TableUtils.copyTable(rightTable);
        ((Element)node).insertChild((Node)leftOriginalTable, ((Element)node).indexOf((Node)leftTable));
        ((Element)node).insertChild((Node)rightOriginalTable, ((Element)node).indexOf((Node)rightTable));
        leftTable.addAttribute(new Attribute("class", "utd:tableSimple"));
        rightTable.addAttribute(new Attribute("class", "utd:tableSimple"));
        mutPageBuilders.addAll((Collection)this.preFormat(leftTable, style, mutPageBuilders, formatSelector));
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        PageBuilderHelper.verifyPageSide(pageBuilder, "left");
        mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
        PageBuilder leftPage = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        int startingY = leftPage.getY();
        leftPage.setNonsequentialPages(true);
        PageBuilder rightPage = this.addNewPage(leftPage, mutPageBuilders);
        rightPage.setNonsequentialPages(true);
        leftPage.setY(startingY);
        leftPage.setX(0);
        rightPage.setY(startingY);
        rightPage.setX(0);
        List<List<SimpleTableFormatter.TableCell>> leftCells = this.findCells(leftTable, formatSelector.styleMap);
        int leftCols = this.calculateNumOfCols(leftCells);
        int[] leftWidths = this.calculateColumnWidths(leftCells, cellType.getCellsForWidth(new BigDecimal(String.valueOf(formatSelector.engine.getPageSettings().getDrawableWidth()))), leftCols, true);
        this.addSeparationLines(leftCells.get(0), formatSelector, leftWidths);
        List<List<SimpleTableFormatter.TableCell>> rightCells = this.findCells(rightTable, formatSelector.styleMap);
        int rightCols = this.calculateNumOfCols(rightCells);
        int[] rightWidths = this.calculateColumnWidths(rightCells, cellType.getCellsForWidth(new BigDecimal(String.valueOf(formatSelector.engine.getPageSettings().getDrawableWidth()))), rightCols, false);
        this.addSeparationLines(rightCells.get(0), formatSelector, rightWidths);
        int leftHeadingY = startingY;
        int rightHeadingY = startingY;
        boolean beginningOfPage = leftPage.getY() == 0 || leftPage.getY() == 1 && ((CharSequence)leftPage.getRunningHead()).length() > 0;
        while (true) {
            int startingSize = mutPageBuilders.size();
            try {
                if (leftHeadingY != -1) {
                    this.addHeadings(mutPageBuilders, leftPage, leftCells.get(0), leftWidths, 1, leftHeadingY);
                }
            }
            catch (BadSimpleTableException badSimpleTableException) {
                return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
            }
            if (!Intrinsics.areEqual((Object)leftPage, (Object)CollectionsKt.elementAt((Iterable)mutPageBuilders, (int)(mutPageBuilders.size() - 2)))) {
                if (beginningOfPage) {
                    return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
                }
                while (mutPageBuilders.size() > startingSize) {
                    mutPageBuilders.remove(CollectionsKt.last((Iterable)mutPageBuilders));
                }
                this.removeCellsFromPageBuilders(leftCells.get(0), rightCells.get(0), mutPageBuilders);
                leftPage = this.addNewPage(rightPage, mutPageBuilders);
                rightPage = this.addNewPage(leftPage, mutPageBuilders);
                leftHeadingY = 0;
                rightHeadingY = 0;
                leftPage.setY(0);
                rightPage.setY(0);
                beginningOfPage = true;
                continue;
            }
            try {
                if (rightHeadingY != -1) {
                    this.addHeadings(mutPageBuilders, rightPage, rightCells.get(0), rightWidths, 1, rightHeadingY);
                }
            }
            catch (BadSimpleTableException badSimpleTableException) {
                return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
            }
            if (!Intrinsics.areEqual((Object)rightPage, (Object)CollectionsKt.last((Iterable)mutPageBuilders))) {
                if (beginningOfPage) {
                    return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
                }
                while (mutPageBuilders.size() > startingSize) {
                    mutPageBuilders.remove(CollectionsKt.last((Iterable)mutPageBuilders));
                }
                this.removeCellsFromPageBuilders(leftCells.get(0), rightCells.get(0), mutPageBuilders);
                leftPage = this.addNewPage(rightPage, mutPageBuilders);
                rightPage = this.addNewPage(leftPage, mutPageBuilders);
                leftHeadingY = 0;
                rightHeadingY = 0;
                leftPage.setY(0);
                rightPage.setY(0);
                beginningOfPage = true;
                continue;
            }
            if (leftPage.getY() == rightPage.getY()) break;
            if (leftPage.getY() < rightPage.getY()) {
                rightHeadingY = -1;
                for (SimpleTableFormatter.TableCell cell : leftCells.get(0)) {
                    cell.y = null;
                    cell.removeFromPageBuilder(leftPage);
                }
                leftPage.setY(++leftHeadingY);
                continue;
            }
            leftHeadingY = -1;
            for (SimpleTableFormatter.TableCell cell : rightCells.get(0)) {
                cell.y = null;
                cell.removeFromPageBuilder(rightPage);
            }
            rightPage.setY(++rightHeadingY);
        }
        leftPage.addAtLeastLinesBefore(1);
        leftPage.processSpacing();
        rightPage.addAtLeastLinesBefore(1);
        rightPage.processSpacing();
        int n2 = leftCells.size();
        for (int curRow = 1; curRow < n2; ++curRow) {
            boolean lastRow = curRow + 1 == leftCells.size();
            List<SimpleTableFormatter.TableCell> leftRow = leftCells.get(curRow);
            List rightRow = curRow < rightCells.size() ? rightCells.get(curRow) : (List)new ArrayList();
            try {
                mutPageBuilders.addAll((Collection)this.addRow(mutPageBuilders, leftPage, formatSelector, leftRow, 1, leftCols, leftWidths, true, true, lastRow));
            }
            catch (BadSimpleTableException badSimpleTableException) {
                return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
            }
            if (!Intrinsics.areEqual((Object)CollectionsKt.last((Iterable)mutPageBuilders), (Object)rightPage)) {
                mutPageBuilders.remove(CollectionsKt.last((Iterable)mutPageBuilders));
                leftRow.forEach(arg_0 -> FacingTableFormatter.format$lambda$0(mutPageBuilders, arg_0));
                rightRow.forEach(arg_0 -> FacingTableFormatter.format$lambda$1(mutPageBuilders, arg_0));
                rightPage.addAtLeastPages(1);
                mutPageBuilders.addAll((Collection)rightPage.processSpacing());
                leftPage = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                leftPage.setNonsequentialPages(true);
                leftPage.setX(0);
                leftPage.setY(1);
                try {
                    mutPageBuilders.addAll((Collection)this.addRow(mutPageBuilders, leftPage, formatSelector, leftRow, 1, leftCols, leftWidths, true, true, lastRow));
                }
                catch (BadSimpleTableException badSimpleTableException) {
                    return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
                }
                leftPage.addAtLeastPages(1);
                mutPageBuilders.addAll((Collection)leftPage.processSpacing());
                rightPage = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
                rightPage.setNonsequentialPages(true);
            }
            Integer n3 = leftRow.get((int)0).y;
            Integer n4 = leftRow.get((int)0).height;
            rightPage.setY((n3 != null ? n3 : 0) + (n4 != null ? n4 : 0));
            try {
                mutPageBuilders.addAll((Collection)this.addRow(mutPageBuilders, rightPage, formatSelector, rightRow, 1, rightCols, rightWidths, false, false, lastRow));
            }
            catch (BadSimpleTableException badSimpleTableException) {
                return this.handleBadFacingTable(leftTable, rightTable, style, mutPageBuilders, formatSelector, leftCells, rightCells, startingPBSize, leftOriginalTable, rightOriginalTable);
            }
            leftPage.setY((int)Math.max((double)leftPage.getY(), (double)rightPage.getY()));
            rightPage.setY((int)Math.max((double)rightPage.getY(), (double)leftPage.getY()));
        }
        rightPage.addAtLeastLinesBefore(2);
        return mutPageBuilders;
    }

    private final PageBuilder addNewPage(PageBuilder curPB, Set<PageBuilder> pageBuilders) {
        Element fakeBrl = UTDElements.BRL.create();
        fakeBrl.appendChild("test");
        PageBuilder.addBrl$default(curPB, fakeBrl, null, 2, null);
        curPB.addAtLeastPages(1);
        pageBuilders.addAll((Collection<PageBuilder>)curPB.processSpacing());
        curPB.removeBrl(fakeBrl);
        ((PageBuilder)CollectionsKt.last((Iterable)pageBuilders)).setNonsequentialPages(true);
        return (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
    }

    private final void removeCellsFromPageBuilders(List<SimpleTableFormatter.TableCell> leftCells, List<SimpleTableFormatter.TableCell> rightCells, Set<PageBuilder> pageBuilders) {
        leftCells.forEach(arg_0 -> FacingTableFormatter.removeCellsFromPageBuilders$lambda$0(pageBuilders, arg_0));
        rightCells.forEach(arg_0 -> FacingTableFormatter.removeCellsFromPageBuilders$lambda$1(pageBuilders, arg_0));
    }

    private final Set<PageBuilder> handleBadFacingTable(Element leftTable, Element rightTable, IStyle style, Set<PageBuilder> pbs, FormatSelector formatSelector, List<? extends List<SimpleTableFormatter.TableCell>> leftCells, List<? extends List<SimpleTableFormatter.TableCell>> rightCells, int startingPBSize, Element leftOriginalTable, Element rightOriginalTable) {
        Set<PageBuilder> pageBuilders = CollectionsKt.toMutableSet((Iterable)pbs);
        Element element = leftTable;
        Intrinsics.checkNotNull((Object)element);
        ParentNode parentNode = element.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element span = (Element)parentNode;
        for (int i = span.getAttributeCount() - 1; -1 < i; --i) {
            span.removeAttribute(span.getAttribute(i));
        }
        pageBuilders = this.handleBadSimpleTable(leftTable, style, pageBuilders, formatSelector, leftCells, startingPBSize);
        return this.handleBadSimpleTable(rightTable, style, pageBuilders, formatSelector, rightCells, pageBuilders.size());
    }

    private static final void format$lambda$0(Set $mutPageBuilders, SimpleTableFormatter.TableCell tc) {
        Intrinsics.checkNotNullParameter((Object)tc, (String)"tc");
        tc.removeFromPageBuilders($mutPageBuilders);
    }

    private static final void format$lambda$1(Set $mutPageBuilders, SimpleTableFormatter.TableCell tc) {
        Intrinsics.checkNotNullParameter((Object)tc, (String)"tc");
        tc.removeFromPageBuilders($mutPageBuilders);
    }

    private static final void removeCellsFromPageBuilders$lambda$0(Set $pageBuilders, SimpleTableFormatter.TableCell c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        c.removeFromPageBuilders($pageBuilders);
        c.x = null;
        c.y = null;
    }

    private static final void removeCellsFromPageBuilders$lambda$1(Set $pageBuilders, SimpleTableFormatter.TableCell c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        c.removeFromPageBuilders($pageBuilders);
        c.x = null;
        c.y = null;
    }
}

