/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.tables;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.utd.FormatSelector;
import org.brailleblaster.utd.IStyle;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.PageBuilder;
import org.brailleblaster.utd.PageNumberTracker;
import org.brailleblaster.utd.exceptions.BadSimpleTableException;
import org.brailleblaster.utd.formatters.Formatter;
import org.brailleblaster.utd.internal.elements.TableDivider;
import org.brailleblaster.utd.properties.Align;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.tables.ListedTableFormatter;
import org.brailleblaster.utd.utils.PageBuilderHelper;
import org.brailleblaster.utd.utils.TableUtils;
import org.brailleblaster.utd.utils.UTDHelper;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u0000 B2\u00020\u0001:\u0002ABB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JX\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0004J4\u0010 \u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0004JJ\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010#\u001a\u00020\r2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0004Jj\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&2\u0006\u0010,\u001a\u00020\u00072\u0006\u0010-\u001a\u00020\u00072\u0006\u0010.\u001a\u00020\u0007H\u0004J\u0010\u0010/\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0017H\u0002J4\u00100\u001a\u00020&2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u00101\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0007H\u0004J4\u00103\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u00101\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u00102\u001a\u00020\u0007H\u0002J\u0010\u00104\u001a\u00020\u00052\u0006\u00105\u001a\u000206H\u0002J\u001c\u00107\u001a\u00020\u00052\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001aH\u0004J\u0018\u00108\u001a\u00020\u00052\u0006\u00109\u001a\u00020\u00052\u0006\u0010%\u001a\u00020&H\u0002J$\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010;\u001a\u00020<H\u0004J*\u0010=\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u00109\u001a\u00020\u0005H\u0002J&\u0010>\u001a\u00020\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010%\u001a\u00020&H\u0004JP\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001a0\u001a2\u0006\u0010\u001c\u001a\u00020\u0005H\u0004J\u0018\u0010?\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010@\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lorg/brailleblaster/utd/tables/SimpleTableFormatter;", "Lorg/brailleblaster/utd/formatters/Formatter;", "<init>", "()V", "cellsBetweenCols", "", "guideDotsEnabled", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "format", "", "Lorg/brailleblaster/utd/PageBuilder;", "node", "Lnu/xom/Node;", "style", "Lorg/brailleblaster/utd/IStyle;", "pageBuilders", "", "formatSelector", "Lorg/brailleblaster/utd/FormatSelector;", "handleBadSimpleTable", "Lnu/xom/Element;", "originalTable", "cells", "", "Lorg/brailleblaster/utd/tables/SimpleTableFormatter$TableCell;", "startingPBSize", "prepareTable", "", "table", "preFormat", "element", "addHeadings", "pageBuilder", "headings", "widths", "", "startOfPage", "startLine", "addRow", "row", "numOfCols", "hasHeading", "hasEndingGuideDots", "lastRow", "changeTable", "calculateColumnWidths", "totalWidth", "fullWidth", "calculateSmallestFits", "smallestColumnWidthForTwoRows", "input", "", "calculateNumOfCols", "calculateXPos", "col", "findCells", "iStyleMap", "Lorg/brailleblaster/utd/IStyleMap;", "getCellsInCol", "addSeparationLines", "shouldSkipTopLine", "shouldSkipBottomLine", "TableCell", "Companion", "utd"})
@SourceDebugExtension(value={"SMAP\nSimpleTableFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTableFormatter.kt\norg/brailleblaster/utd/tables/SimpleTableFormatter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,756:1\n1915#2:757\n1915#2,2:758\n1916#2:760\n1915#2,2:761\n1586#2:763\n1661#2,3:764\n1596#2:772\n1629#2,3:773\n1596#2:776\n1629#2,3:777\n1915#2,2:780\n1632#2:782\n1632#2:783\n777#2:784\n873#2,2:785\n1#3:767\n11735#4:768\n12085#4,3:769\n106#5:787\n78#5,22:788\n*S KotlinDebug\n*F\n+ 1 SimpleTableFormatter.kt\norg/brailleblaster/utd/tables/SimpleTableFormatter\n*L\n221#1:757\n222#1:758,2\n221#1:760\n349#1:761,2\n569#1:763\n569#1:764,3\n636#1:772\n636#1:773,3\n637#1:776\n637#1:777,3\n640#1:780,2\n637#1:782\n636#1:783\n654#1:784\n654#1:785,2\n633#1:768\n633#1:769,3\n675#1:787\n675#1:788,22\n*E\n"})
public class SimpleTableFormatter
extends Formatter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int cellsBetweenCols = 2;
    private boolean guideDotsEnabled = true;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @NotNull
    public static final String GUIDE_DOTS_ATTRIB_NAME = "tableDots";
    @NotNull
    public static final String GUIDE_DOTS_ATTRIB_VALUE = "true";

    @Override
    @NotNull
    public Set<PageBuilder> format(@NotNull Node node, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        int[] widths;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Set mutPageBuilders = CollectionsKt.toMutableSet((Iterable)pageBuilders);
        if (!(node instanceof Element)) {
            return mutPageBuilders;
        }
        TableUtils.INSTANCE.deleteExistingTable(node);
        int startingPBSize = mutPageBuilders.size();
        Element originalTable = TableUtils.copyTable((Element)node);
        this.cellsBetweenCols = TableUtils.hasSimpleTableOption(TableUtils.SimpleTableOptions.ONE_CELL_BETWEEN_COLUMNS, (Element)node) ? 1 : 2;
        this.guideDotsEnabled = !TableUtils.hasSimpleTableOption(TableUtils.SimpleTableOptions.GUIDE_DOTS_DISABLED, (Element)node);
        boolean rowHeadingEnabled = !TableUtils.hasSimpleTableOption(TableUtils.SimpleTableOptions.ROW_HEADING_DISABLED, (Element)node);
        this.prepareTable((Element)node, formatSelector);
        mutPageBuilders.addAll((Collection)this.preFormat((Element)node, style, mutPageBuilders, formatSelector));
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        pageBuilder.clearKeepWithNext();
        BrlCell cellType = formatSelector.engine.getBrailleSettings().getCellType();
        List<List<TableCell>> cells = this.findCells((Element)node, formatSelector.styleMap);
        int numOfCols = this.calculateNumOfCols(cells);
        if (numOfCols == 0) {
            this.log.debug("Skipping empty table");
            return mutPageBuilders;
        }
        if (!this.calculateSmallestFits(cells, cellType.getCellsForWidth(new BigDecimal(String.valueOf(formatSelector.engine.getPageSettings().getDrawableWidth()))), numOfCols, false)) {
            return this.handleBadSimpleTable((Element)node, originalTable, style, mutPageBuilders, formatSelector, cells, startingPBSize);
        }
        int[] nArray = TableUtils.getCustomSimpleTableWidths((Element)node);
        if (nArray == null) {
            nArray = widths = this.calculateColumnWidths(cells, cellType.getCellsForWidth(new BigDecimal(String.valueOf(formatSelector.engine.getPageSettings().getDrawableWidth()))), numOfCols, false);
        }
        if (!TableUtils.hasSimpleTableOption(TableUtils.SimpleTableOptions.COLUMN_HEADING_DISABLED, (Element)node)) {
            this.addSeparationLines(cells.get(0), formatSelector, widths);
        }
        mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        int startOfPage = 0;
        if (((CharSequence)pageBuilder.getRunningHead()).length() > 0) {
            startOfPage = 2;
        } else if (this.shouldSkipTopLine(pageBuilder, formatSelector)) {
            startOfPage = 1;
        }
        if (pageBuilder.getY() < startOfPage) {
            pageBuilder.setY(startOfPage);
        }
        if (PageBuilder.hasLeftPage$default(pageBuilder, null, 1, null)) {
            pageBuilder.setSkipNumberLineBottom(true);
        }
        pageBuilder.setAlignment(Align.LEFT);
        int startingY = pageBuilder.getY();
        try {
            mutPageBuilders.addAll((Collection)this.addHeadings(mutPageBuilders, pageBuilder, cells.get(0), widths, startOfPage, startingY));
        }
        catch (BadSimpleTableException badSimpleTableException) {
            return this.handleBadSimpleTable((Element)node, originalTable, style, mutPageBuilders, formatSelector, cells, startingPBSize);
        }
        pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        pageBuilder.addAtLeastLinesBefore(1);
        if (pageBuilder.getY() + pageBuilder.getPendingLinesBefore() == pageBuilder.getLinesPerPage() - 1) {
            pageBuilder.addAtLeastPages(1);
        }
        int curResults = mutPageBuilders.size();
        mutPageBuilders.addAll((Collection)pageBuilder.processSpacing());
        if (mutPageBuilders.size() > curResults) {
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
            pageBuilder.setY(startOfPage);
        }
        int n = cells.size();
        for (int rowNum = 1; rowNum < n; ++rowNum) {
            boolean lastRow = rowNum + 1 == cells.size();
            try {
                mutPageBuilders.addAll((Collection)this.addRow(mutPageBuilders, pageBuilder, formatSelector, cells.get(rowNum), startOfPage, numOfCols, widths, rowHeadingEnabled, false, lastRow));
            }
            catch (BadSimpleTableException badSimpleTableException) {
                return this.handleBadSimpleTable((Element)node, originalTable, style, mutPageBuilders, formatSelector, cells, startingPBSize);
            }
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)mutPageBuilders);
        }
        ((Element)node).addAttribute(new Attribute("class", "utd:tableSimple"));
        ((Element)node).getParent().insertChild((Node)originalTable, ((Element)node).getParent().indexOf(node));
        Integer linesAfter = style.getLinesAfter(node, formatSelector.styleMap.getNamespaces());
        if (linesAfter != null) {
            pageBuilder.setMaxLines(linesAfter);
        } else {
            pageBuilder.addAtLeastLinesAfter(RangesKt.coerceAtLeast((int)style.getLinesAfter(), (int)1));
        }
        pageBuilder.addAtLeastPages(style.getNewPagesAfter());
        return mutPageBuilders;
    }

    private final Set<PageBuilder> handleBadSimpleTable(Element node, Element originalTable, IStyle style, Set<PageBuilder> pageBuilders, FormatSelector formatSelector, List<? extends List<TableCell>> cells, int startingPBSize) {
        node.getParent().replaceChild((Node)node, (Node)originalTable);
        Iterable $this$forEach$iv = pageBuilders;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PageBuilder pb = (PageBuilder)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = UTDHelper.getDescendantBrlFast((Node)node);
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Element brl = (Element)element$iv2;
                boolean bl2 = false;
                pb.removeBrl(brl);
            }
        }
        return this.handleBadSimpleTable(originalTable, style, pageBuilders, formatSelector, cells, startingPBSize);
    }

    protected final void prepareTable(@NotNull Element table, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        TableUtils.INSTANCE.removeBrlBetweenCells(table, formatSelector.styleMap);
        TableUtils.INSTANCE.createSignsOfOmission(formatSelector.engine, table, formatSelector.styleMap, "");
    }

    @NotNull
    protected final Set<PageBuilder> preFormat(@NotNull Element element, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        boolean keepWithNext = pageBuilder.hasKeepWithNextQueued();
        Integer linesBefore = style.getLinesBefore((Node)element, formatSelector.styleMap.getNamespaces());
        if (linesBefore != null) {
            pageBuilder.setMaxLines(linesBefore);
        } else {
            pageBuilder.addAtLeastLinesBefore(style.getLinesBefore());
        }
        pageBuilder.addAtLeastPages(style.getNewPagesBefore());
        int pbSize = pageBuilders.size();
        pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
        if (pageBuilders.size() > pbSize) {
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
            if (keepWithNext) {
                pageBuilder.addAtLeastLinesBefore(RangesKt.coerceAtLeast((int)style.getLinesBefore(), (int)1));
                pageBuilders.addAll((Collection<PageBuilder>)pageBuilder.processSpacing());
                pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
            }
        }
        List<Element> caption = TableUtils.INSTANCE.findCaptionBrl(element, formatSelector.styleMap);
        for (Element brl : caption) {
            PageBuilder pageBuilder2;
            PageBuilder $this$preFormat_u24lambda_u240 = pageBuilder2 = pageBuilder;
            boolean bl = false;
            $this$preFormat_u24lambda_u240.setFirstLineIndent(6);
            $this$preFormat_u24lambda_u240.setLeftIndent(4);
            $this$preFormat_u24lambda_u240.setRightIndent(0);
            $this$preFormat_u24lambda_u240.addAtLeastLinesBefore(1);
            $this$preFormat_u24lambda_u240.setStartOfBlock(true);
            pageBuilders.addAll(PageBuilder.addBrl$default(pageBuilder, brl, null, 2, null));
            pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
        }
        if (!((Collection)caption).isEmpty()) {
            pageBuilder.addAtLeastLinesBefore(2);
        }
        return pageBuilders;
    }

    @NotNull
    protected final Set<PageBuilder> addHeadings(@NotNull Set<PageBuilder> pageBuilders, @NotNull PageBuilder pageBuilder, @NotNull List<TableCell> headings, @NotNull int[] widths, int startOfPage, int startLine) throws BadSimpleTableException {
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter(headings, (String)"headings");
        Intrinsics.checkNotNullParameter((Object)widths, (String)"widths");
        PageBuilder curPageBuilder = pageBuilder;
        int startingLine = startLine;
        Integer finalLine = null;
        boolean beginningOfPage = curPageBuilder.getY() == 0 || curPageBuilder.getY() == 1 && ((CharSequence)curPageBuilder.getRunningHead()).length() > 0;
        for (int i = 0; i < headings.size(); ++i) {
            Integer n;
            TableCell curHeading = headings.get(i);
            if (curHeading.x == null) {
                curHeading.x = this.calculateXPos(i, widths);
            }
            if (curHeading.y == null) {
                curHeading.y = startingLine;
            }
            Integer n2 = curHeading.x;
            Intrinsics.checkNotNull((Object)n2);
            curPageBuilder.setX(n2);
            Integer n3 = curHeading.y;
            Intrinsics.checkNotNull((Object)n3);
            curPageBuilder.setY(n3);
            List<Element> brlElements = curHeading.getBrlElements();
            for (Element brl : brlElements) {
                if (brl.getAttributeValue("class") != null && Intrinsics.areEqual((Object)brl.getAttributeValue("class"), (Object)"sepline")) {
                    curPageBuilder.addAtLeastLinesBefore(1);
                    if (curPageBuilder.getY() + curPageBuilder.getPendingLinesBefore() == curPageBuilder.getLinesPerPage() - 1) {
                        curPageBuilder.addAtLeastPages(1);
                    }
                }
                PageBuilder pageBuilder2 = curPageBuilder.setFirstLineIndent(curHeading.x);
                Integer n4 = curHeading.x;
                Intrinsics.checkNotNull((Object)n4);
                pageBuilder2.setLeftIndent(n4).setRightIndent(widths[i]).setStartOfBlock(true);
                int curPages = pageBuilders.size();
                pageBuilders.addAll(PageBuilder.addBrl$default(curPageBuilder, brl, null, 2, null));
                if (pageBuilders.size() <= curPages) continue;
                if (beginningOfPage) {
                    this.log.error("A simple table heading failed to be created");
                    throw new BadSimpleTableException();
                }
                for (TableCell heading : headings) {
                    heading.x = null;
                    heading.y = null;
                    heading.removeFromPageBuilders(pageBuilders);
                }
                curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                finalLine = null;
                curPageBuilder.setX(0);
                curPageBuilder.setY(startOfPage);
                startingLine = startOfPage;
                i = -1;
                beginningOfPage = true;
                break;
            }
            curHeading.height = curPageBuilder.getY() - startingLine;
            if (finalLine == null) {
                n = curPageBuilder.getY();
            } else if (finalLine < curPageBuilder.getY()) {
                Iterable $this$forEach$iv = CollectionsKt.take((Iterable)headings, (int)i);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TableCell prevHeading = (TableCell)element$iv;
                    boolean bl = false;
                    prevHeading.removeFromPageBuilders(pageBuilders);
                    Integer n5 = prevHeading.y;
                    Intrinsics.checkNotNull((Object)n5);
                    int n6 = n5;
                    Integer n7 = curHeading.height;
                    Intrinsics.checkNotNull((Object)n7);
                    int n8 = n6 + n7;
                    Integer n9 = prevHeading.height;
                    Intrinsics.checkNotNull((Object)n9);
                    prevHeading.y = n8 - n9;
                }
                curHeading.removeFromPageBuilders(pageBuilders);
                i = -1;
                n = curPageBuilder.getY();
            } else if (finalLine > curPageBuilder.getY()) {
                Integer n10 = curHeading.y;
                Intrinsics.checkNotNull((Object)n10);
                curHeading.y = n10 + finalLine - curPageBuilder.getY();
                curHeading.removeFromPageBuilders(pageBuilders);
                --i;
                n = finalLine;
            } else {
                n = finalLine;
            }
            finalLine = n;
        }
        return pageBuilders;
    }

    @NotNull
    protected final Set<PageBuilder> addRow(@NotNull Set<PageBuilder> pageBuilders, @NotNull PageBuilder pageBuilder, @NotNull FormatSelector formatSelector, @NotNull List<TableCell> row, int startOfPage, int numOfCols, @NotNull int[] widths, boolean hasHeading, boolean hasEndingGuideDots, boolean lastRow) throws BadSimpleTableException {
        Set<PageBuilder> processNewLine;
        Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
        Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Intrinsics.checkNotNullParameter(row, (String)"row");
        Intrinsics.checkNotNullParameter((Object)widths, (String)"widths");
        PageBuilder curPageBuilder = pageBuilder;
        int endingY = 0;
        boolean atBeginningOfPage = curPageBuilder.getY() <= startOfPage;
        int n = ((Collection)row).size();
        for (int colNum = 0; colNum < n; ++colNum) {
            Element dotsElement;
            int startOfCol;
            TableCell col = row.get(colNum);
            int startPos = this.calculateXPos(col.getCol(), widths);
            curPageBuilder.setFirstLineIndent(startPos).setLeftIndent(startPos + 2).setRightIndent(widths[col.getCol()] - 2).setStartOfBlock(true);
            curPageBuilder.setX(startPos);
            int startingY = curPageBuilder.getY();
            Nodes brls = UTDHelper.INSTANCE.getDescendantBrlFastNodes((Node)col.getTd());
            int n2 = brls.size();
            for (int i = 0; i < n2; ++i) {
                Node node = brls.get(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                Element curBrl = (Element)node;
                int curPages = pageBuilders.size();
                pageBuilders.addAll(PageBuilder.addBrl$default(curPageBuilder, curBrl, null, 2, null));
                if (pageBuilders.size() > curPages) {
                    if (!atBeginningOfPage) {
                        for (int k = 0; k < colNum; ++k) {
                            TableCell prevCol = row.get(k);
                            prevCol.removeFromPageBuilders(pageBuilders);
                        }
                    } else {
                        this.log.error("A simple table failed to be created");
                        throw new BadSimpleTableException();
                    }
                    col.removeFromPageBuilders(pageBuilders);
                    curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
                    curPageBuilder.setX(0);
                    curPageBuilder.setY(startOfPage);
                    return this.addRow(pageBuilders, curPageBuilder, formatSelector, row, startOfPage, numOfCols, widths, hasHeading, hasEndingGuideDots, lastRow);
                }
                curPageBuilder.setStartOfBlock(false);
            }
            endingY = RangesKt.coerceAtLeast((int)endingY, (int)curPageBuilder.getY());
            col.y = startingY;
            col.height = endingY - startingY;
            if (!this.guideDotsEnabled) continue;
            if (colNum != 0 || !hasHeading) {
                curPageBuilder.setY(startingY);
            }
            if ((colNum == numOfCols - 1 || numOfCols <= 1) && (colNum != numOfCols - 1 || !hasEndingGuideDots) || (startOfCol = this.calculateXPos(colNum, widths) + RangesKt.coerceAtMost((int)col.getTextLength(), (int)2)) >= curPageBuilder.getCellsPerLine()) continue;
            curPageBuilder.setX(startOfCol);
            int endOfCol = colNum == numOfCols - 1 ? startOfCol + widths[colNum] - this.cellsBetweenCols : this.calculateXPos(colNum + 1, widths) - this.cellsBetweenCols;
            char guideDot = formatSelector.engine.getBrailleSettings().isUseAsciiBraille() ? (char)'\"' : '\u2810';
            Element element = dotsElement = ((CharSequence)col.getText()).length() == 0 ? curPageBuilder.fillSpace(guideDot, endOfCol - startOfCol, 0, 4) : curPageBuilder.fillSpace(guideDot, endOfCol - startOfCol + 1, 1, 4);
            if (dotsElement != null) {
                dotsElement.addAttribute(new Attribute("type", "guideDots"));
                dotsElement.addAttribute(new Attribute(GUIDE_DOTS_ATTRIB_NAME, GUIDE_DOTS_ATTRIB_VALUE));
            }
            col.setGuideDots(dotsElement);
        }
        curPageBuilder.setY(endingY);
        curPageBuilder.setForceSpacing(true);
        curPageBuilder.addAtLeastLinesBefore(1);
        if (!lastRow && curPageBuilder.getY() + curPageBuilder.getPendingLinesBefore() == curPageBuilder.getLinesPerPage() - 1 && this.shouldSkipBottomLine(curPageBuilder, formatSelector)) {
            curPageBuilder.addAtLeastPages(1);
        }
        if ((processNewLine = curPageBuilder.processSpacing()).size() > 1) {
            curPageBuilder = (PageBuilder)CollectionsKt.last((Iterable)processNewLine);
            if (!lastRow) {
                curPageBuilder.setY(this.shouldSkipTopLine(curPageBuilder, formatSelector) ? 1 : 0);
            }
        }
        pageBuilders.addAll((Collection<PageBuilder>)processNewLine);
        return pageBuilders;
    }

    private final void changeTable(Element element) {
        Nodes nodes = element.query("descendant::*[local-name()='span'][@class='sepline']", UTDElements.UTD_XPATH_CONTEXT);
        Intrinsics.checkNotNullExpressionValue((Object)nodes, (String)"query(...)");
        NodeUtilsKt.detachAll((Iterable)((Iterable)nodes));
    }

    @NotNull
    protected final int[] calculateColumnWidths(@NotNull List<? extends List<TableCell>> cells, int totalWidth, int numOfCols, boolean fullWidth) {
        int n;
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        int[] lengths = new int[numOfCols];
        int totalSpaceBetweenCols = (numOfCols - 1) * this.cellsBetweenCols;
        int startingWidth = (totalWidth - totalSpaceBetweenCols) / numOfCols;
        int leftoverSpace = 0;
        int n2 = 0;
        int[] nArray = new int[numOfCols];
        while (n2 < numOfCols) {
            n = n2++;
            nArray[n] = startingWidth;
        }
        int[] widths = nArray;
        for (int i = 0; i < numOfCols; ++i) {
            List<TableCell> curCol = this.getCellsInCol(cells, i);
            int longestWidth = 0;
            for (TableCell curCell : curCol) {
                longestWidth = Math.max(TableUtils.INSTANCE.getDescendantBrlNoFormatting(curCell.getTd()).stream().mapToInt(arg_0 -> SimpleTableFormatter.calculateColumnWidths$lambda$1(SimpleTableFormatter::calculateColumnWidths$lambda$0, arg_0)).sum(), longestWidth);
                lengths[i] = longestWidth = Math.max(longestWidth, 1);
            }
            if (longestWidth >= startingWidth) continue;
            widths[i] = longestWidth;
            leftoverSpace += startingWidth - longestWidth;
        }
        boolean changed = false;
        for (int i = 0; i < widths.length; ++i) {
            if (leftoverSpace > 0 && (widths[i] >= startingWidth && widths[i] != lengths[i] || fullWidth)) {
                n = i;
                int n3 = widths[n];
                widths[n] = n3 + 1;
                --leftoverSpace;
                changed = true;
            }
            if (i != widths.length - 1) continue;
            if (!changed || leftoverSpace == 0) break;
            i = -1;
            changed = false;
        }
        return widths;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean calculateSmallestFits(List<? extends List<TableCell>> cells, int totalWidth, int numOfCols, boolean fullWidth) {
        int totalSpaceBetweenCols = (numOfCols - 1) * this.cellsBetweenCols;
        int startingWidth = (totalWidth - totalSpaceBetweenCols) / numOfCols;
        int n = 0;
        int[] nArray = new int[numOfCols];
        while (n < numOfCols) {
            int n2 = n++;
            nArray[n2] = startingWidth;
        }
        int[] widths = nArray;
        for (int i = 0; i < numOfCols; ++i) {
            List<TableCell> curCol = this.getCellsInCol(cells, i);
            int longestWidth = 0;
            for (TableCell curCell : curCol) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = TableUtils.INSTANCE.getDescendantBrlNoFormatting(curCell.getTd());
                SimpleTableFormatter simpleTableFormatter = this;
                boolean $i$f$map = false;
                void var15_15 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Element element = (Element)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getValue();
                    if (string == null) {
                        string = "";
                    }
                    collection.add(string);
                }
                longestWidth = Math.max(simpleTableFormatter.smallestColumnWidthForTwoRows(CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), null, null, null, (int)0, null, SimpleTableFormatter::calculateSmallestFits$lambda$1, (int)31, null)), longestWidth);
                longestWidth = Math.max(longestWidth, 1);
            }
            widths[i] = longestWidth;
        }
        return ArraysKt.sum((int[])widths) + totalSpaceBetweenCols <= totalWidth;
    }

    private final int smallestColumnWidthForTwoRows(String input) {
        int right;
        CharSequence charSequence = input;
        Regex regex = new Regex("\\s+");
        int n = 0;
        List words = regex.split(charSequence, n);
        int left = 1;
        int result = right = input.length();
        while (left <= right) {
            int mid = (left + right) / 2;
            if (SimpleTableFormatter.smallestColumnWidthForTwoRows$canFitInTwoRows(words, mid)) {
                result = mid;
                right = mid - 1;
                continue;
            }
            left = mid + 1;
        }
        return result;
    }

    protected final int calculateNumOfCols(@NotNull List<? extends List<TableCell>> cells) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter(cells, (String)"cells");
        Iterator iterator = ((Iterable)cells).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            List it = (List)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(it.size());
            while (iterator.hasNext()) {
                List it2 = (List)iterator.next();
                $i$a$-maxOfOrNull-SimpleTableFormatter$calculateNumOfCols$1 = false;
                Comparable comparable3 = Integer.valueOf(it2.size());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        return n != null ? n : 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int calculateXPos(int col, int[] widths) {
        void $this$mapTo$iv$iv;
        int[] $this$map$iv = widths;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var11_11 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((int)(it + this.cellsBetweenCols));
        }
        return CollectionsKt.sumOfInt((Iterable)CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)RangesKt.coerceAtLeast((int)col, (int)0)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final List<List<TableCell>> findCells(@NotNull Element element, @NotNull IStyleMap iStyleMap) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)iStyleMap, (String)"iStyleMap");
        Iterable $this$mapIndexed$iv = TableUtils.INSTANCE.findRows(element, iStyleMap);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void $this$mapIndexedTo$iv$iv2;
            void row;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Element element2 = (Element)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$mapIndexed$iv2 = TableUtils.INSTANCE.findCols((Element)row, iStyleMap);
            boolean $i$f$mapIndexed2 = false;
            Iterable iterable2 = $this$mapIndexed$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv2, (int)10));
            boolean $i$f$mapIndexedTo2 = false;
            int index$iv$iv2 = 0;
            for (Object item$iv$iv2 : $this$mapIndexedTo$iv$iv2) {
                TableCell tableCell;
                void colIndex;
                void rowIndex;
                void col;
                int n3;
                if ((n3 = index$iv$iv2++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Element element3 = (Element)item$iv$iv2;
                int n4 = n3;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                col.addAttribute(new Attribute("row-col", (int)rowIndex + "-" + (int)colIndex));
                TableCell $this$findCells_u24lambda_u240_u240_u240 = tableCell = new TableCell((Element)col, (int)rowIndex, (int)colIndex);
                boolean bl3 = false;
                if (rowIndex == false) {
                    Iterable $this$forEach$iv = $this$findCells_u24lambda_u240_u240_u240.getBrlElements();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Element brl = (Element)element$iv;
                        boolean bl4 = false;
                        brl.addAttribute(new Attribute("tableHeading", colIndex == false ? GUIDE_DOTS_ATTRIB_VALUE : "false"));
                    }
                }
                collection2.add(tableCell);
            }
            collection.add((List)destination$iv$iv2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<TableCell> getCellsInCol(List<? extends List<TableCell>> cells, int col) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.flatten((Iterable)cells);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TableCell it = (TableCell)element$iv$iv;
            boolean bl = false;
            if (!(it.getCol() == col)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    protected final void addSeparationLines(@NotNull List<TableCell> headings, @NotNull FormatSelector formatSelector, @NotNull int[] widths) {
        Intrinsics.checkNotNullParameter(headings, (String)"headings");
        Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
        Intrinsics.checkNotNullParameter((Object)widths, (String)"widths");
        for (TableCell heading : headings) {
            String string;
            void $this$trim$iv;
            if (heading.getBrlElements().isEmpty()) continue;
            int width = widths[heading.getCol()];
            Element span = new TableDivider(TableDivider.DividerTypes.SIMPLE_SEP_LINE);
            span.appendChild(StringsKt.repeat((CharSequence)"-", (int)width));
            Element brl = UTDElements.BRL.create();
            if (formatSelector.engine.getBrailleSettings().isUseAsciiBraille()) {
                brl.appendChild("\"" + StringsKt.repeat((CharSequence)"3", (int)(width - 1)));
            } else {
                brl.appendChild("\u2810" + StringsKt.repeat((CharSequence)"\u2812", (int)(width - 1)));
            }
            brl.addAttribute(new Attribute("class", "sepline"));
            span.appendChild((Node)brl);
            StringBuilder index = new StringBuilder();
            for (int i = 0; i < width; ++i) {
                index.append(i).append(" ");
            }
            Intrinsics.checkNotNullExpressionValue((Object)index.toString(), (String)"toString(...)");
            String string2 = "index";
            Element element = brl;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string3 = string = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            String string4 = string2;
            element.addAttribute(new Attribute(string4, string3));
            brl.addAttribute(new Attribute("tableHeading", heading.getCol() == 0 ? GUIDE_DOTS_ATTRIB_VALUE : "false"));
            heading.getTd().appendChild((Node)span);
        }
    }

    @NotNull
    protected final Set<PageBuilder> handleBadSimpleTable(@NotNull Element element, @NotNull IStyle style, @NotNull Set<PageBuilder> pageBuilders, @NotNull FormatSelector formatSelector, @NotNull List<? extends List<TableCell>> cells, int startingPBSize) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
            Intrinsics.checkNotNullParameter((Object)formatSelector, (String)"formatSelector");
            Intrinsics.checkNotNullParameter(cells, (String)"cells");
            if (element.getAttribute("class") != null) {
                element.removeAttribute(element.getAttribute("class"));
            }
            for (List<TableCell> list : cells) {
                for (TableCell cell : list) {
                    cell.removeFromPageBuilders(pageBuilders);
                }
            }
            for (int i = pageBuilders.size() - 1; i >= 0 && pageBuilders.size() >= startingPBSize && pageBuilders.size() > 1; --i) {
                PageBuilder pageBuilder = (PageBuilder)CollectionsKt.elementAt((Iterable)pageBuilders, (int)i);
                if (!pageBuilder.isBlankPage()) continue;
                pageBuilders.remove(pageBuilder);
            }
            PageBuilder pageBuilder = (PageBuilder)CollectionsKt.last((Iterable)pageBuilders);
            pageBuilder.setY(pageBuilder.findLastBlankLine());
            this.changeTable(element);
            element.addAttribute(new Attribute("format", "listed"));
            element.addAttribute(new Attribute("utd-style", "Listed Table"));
            element.addAttribute(new Attribute("utd:fallback", "http://brailleblaster.org/ns/utd", GUIDE_DOTS_ATTRIB_VALUE));
            Attribute attribute = element.getAttribute("tableCopy", "http://brailleblaster.org/ns/utd");
            if (attribute == null) break block4;
            attribute.detach();
        }
        return new ListedTableFormatter().format((Node)element, style, pageBuilders, formatSelector);
    }

    private final boolean shouldSkipTopLine(PageBuilder pageBuilder, FormatSelector formatSelector) {
        PageNumberTracker braillePageNumber = pageBuilder.getBraillePageNumber();
        return PageBuilderHelper.getBraillePageNumberAt(formatSelector.engine.getPageSettings(), braillePageNumber.getPageNumber()).isTop() && ((CharSequence)pageBuilder.getBraillePageNum()).length() > 0 || PageBuilderHelper.getPrintPageNumberAt(formatSelector.engine.getPageSettings(), braillePageNumber.getPageNumber()).isTop() && ((CharSequence)pageBuilder.getPrintPageNumber()).length() > 0;
    }

    private final boolean shouldSkipBottomLine(PageBuilder pageBuilder, FormatSelector formatSelector) {
        PageNumberTracker braillePageNumber = pageBuilder.getBraillePageNumber();
        return PageBuilderHelper.getBraillePageNumberAt(formatSelector.engine.getPageSettings(), braillePageNumber.getPageNumber()).isBottom() && ((CharSequence)pageBuilder.getBraillePageNum()).length() > 0 || PageBuilderHelper.getPrintPageNumberAt(formatSelector.engine.getPageSettings(), braillePageNumber.getPageNumber()).isBottom() && ((CharSequence)pageBuilder.getPrintPageNumber()).length() > 0;
    }

    private static final int calculateColumnWidths$lambda$0(Element s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        return s.getValue().length();
    }

    private static final int calculateColumnWidths$lambda$1(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }

    private static final CharSequence calculateSmallestFits$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    private static final boolean smallestColumnWidthForTwoRows$canFitInTwoRows(List<String> words, int width) {
        int currentWidth = 0;
        int rowCount = 1;
        for (String word : words) {
            int wordLength = word.length();
            if (wordLength > width) {
                return false;
            }
            if (currentWidth + wordLength > width) {
                currentWidth = wordLength;
                if (++rowCount > 2) {
                    return false;
                }
            } else {
                currentWidth += wordLength;
            }
            ++currentWidth;
        }
        return rowCount <= 2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/utd/tables/SimpleTableFormatter$Companion;", "", "<init>", "()V", "GUIDE_DOTS_ATTRIB_NAME", "", "GUIDE_DOTS_ATTRIB_VALUE", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0005\b\u0004\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dJ\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR\u0016\u0010\u0016\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0018\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0017R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00030&8F\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000e\u00a8\u0006+"}, d2={"Lorg/brailleblaster/utd/tables/SimpleTableFormatter$TableCell;", "", "td", "Lnu/xom/Element;", "row", "", "col", "<init>", "(Lnu/xom/Element;II)V", "getTd", "()Lnu/xom/Element;", "setTd", "(Lnu/xom/Element;)V", "getRow", "()I", "setRow", "(I)V", "getCol", "setCol", "guideDots", "getGuideDots", "setGuideDots", "x", "Ljava/lang/Integer;", "y", "height", "removeFromPageBuilders", "", "pageBuilders", "", "Lorg/brailleblaster/utd/PageBuilder;", "removeFromPageBuilder", "pageBuilder", "text", "", "getText", "()Ljava/lang/String;", "brlElements", "", "getBrlElements", "()Ljava/util/List;", "textLength", "getTextLength", "utd"})
    @SourceDebugExtension(value={"SMAP\nSimpleTableFormatter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleTableFormatter.kt\norg/brailleblaster/utd/tables/SimpleTableFormatter$TableCell\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,756:1\n1#2:757\n*E\n"})
    protected static final class TableCell {
        @NotNull
        private Element td;
        private int row;
        private int col;
        @Nullable
        private Element guideDots;
        @JvmField
        @Nullable
        public Integer x;
        @JvmField
        @Nullable
        public Integer y;
        @JvmField
        @Nullable
        public Integer height;

        public TableCell(@NotNull Element td, int row, int col) {
            Intrinsics.checkNotNullParameter((Object)td, (String)"td");
            this.td = td;
            this.row = row;
            this.col = col;
        }

        @NotNull
        public final Element getTd() {
            return this.td;
        }

        public final void setTd(@NotNull Element element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"<set-?>");
            this.td = element;
        }

        public final int getRow() {
            return this.row;
        }

        public final void setRow(int n) {
            this.row = n;
        }

        public final int getCol() {
            return this.col;
        }

        public final void setCol(int n) {
            this.col = n;
        }

        @Nullable
        public final Element getGuideDots() {
            return this.guideDots;
        }

        public final void setGuideDots(@Nullable Element element) {
            this.guideDots = element;
        }

        public final void removeFromPageBuilders(@NotNull Set<PageBuilder> pageBuilders) {
            Intrinsics.checkNotNullParameter(pageBuilders, (String)"pageBuilders");
            for (PageBuilder pb : pageBuilders) {
                this.removeFromPageBuilder(pb);
            }
        }

        public final void removeFromPageBuilder(@NotNull PageBuilder pageBuilder) {
            Intrinsics.checkNotNullParameter((Object)pageBuilder, (String)"pageBuilder");
            List<Element> brls = this.getBrlElements();
            for (Element brl : brls) {
                pageBuilder.removeBrl(brl);
            }
            if (this.guideDots != null) {
                Element element = this.guideDots;
                Intrinsics.checkNotNull((Object)element);
                pageBuilder.removeFormattingElement(element);
            }
        }

        @NotNull
        public final String getText() {
            String string = this.td.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            return string;
        }

        @NotNull
        public final List<Element> getBrlElements() {
            return UTDHelper.getDescendantBrlFast((Node)this.td);
        }

        /*
         * WARNING - void declaration
         */
        public final int getTextLength() {
            List<Element> brls = this.getBrlElements();
            Iterable iterable = brls;
            int n = 0;
            for (Object t : iterable) {
                void e;
                Element element = (Element)t;
                int n2 = n;
                boolean bl = false;
                int n3 = e.getValue().length();
                n = n2 + n3;
            }
            return n;
        }
    }
}

