/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.IntPredicate;
import javax.imageio.ImageIO;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.utils.BrailleMapper;
import org.brailleblaster.utd.properties.UTDElements;
import org.brailleblaster.utd.utils.BBX2PEFConverterKt;
import org.brailleblaster.utils.xml.PEFNamespaceContext;
import org.brailleblaster.utils.xom.DocumentTraversal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0004\u0081\u0001\u0082\u0001Bu\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010H\u001a\u00020I2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003J\u0010\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010P\u001a\u00020I2\u0006\u0010N\u001a\u00020OH\u0016J\u0010\u0010Q\u001a\u00020I2\u0006\u0010R\u001a\u00020SH\u0016J\u0010\u0010T\u001a\u00020I2\u0006\u0010R\u001a\u00020SH\u0016J\b\u0010U\u001a\u00020'H\u0002J\b\u0010V\u001a\u00020'H\u0002J\b\u0010W\u001a\u00020'H\u0002J\b\u0010X\u001a\u00020IH\u0002J\b\u0010Y\u001a\u00020IH\u0002J\b\u0010Z\u001a\u00020IH\u0002J\b\u0010[\u001a\u00020IH\u0002J\b\u0010\\\u001a\u00020IH\u0002J\b\u0010_\u001a\u00020IH\u0002J\u0018\u0010`\u001a\u00020I2\u0006\u0010a\u001a\u00020\u00032\u0006\u0010b\u001a\u00020\u0003H\u0002J\u0018\u0010c\u001a\u00020'2\u0006\u0010d\u001a\u0002042\u0006\u0010e\u001a\u00020\u0003H\u0002J\u0018\u0010f\u001a\u00020I2\u0006\u0010g\u001a\u00020\u000f2\u0006\u0010h\u001a\u00020iH\u0002J\u0010\u0010j\u001a\u00020I2\u0006\u0010k\u001a\u00020OH\u0002J \u0010l\u001a\u00020I2\u0006\u0010m\u001a\u00020\u000f2\u0006\u0010n\u001a\u00020\u000f2\u0006\u0010o\u001a\u00020\u000fH\u0002J\u0010\u0010p\u001a\u00020I2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010q\u001a\u00020I2\u0006\u0010N\u001a\u00020OH\u0002J\u0012\u0010r\u001a\u0004\u0018\u00010i2\u0006\u0010s\u001a\u00020\u000fH\u0002J\u0012\u0010t\u001a\u0004\u0018\u00010i2\u0006\u0010u\u001a\u00020vH\u0002J\u0018\u0010w\u001a\u00020I2\u0006\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020yH\u0002J\u0018\u0010{\u001a\u00020I2\u0006\u0010x\u001a\u00020\u00032\u0006\u0010z\u001a\u00020\u0003H\u0002J\u0010\u0010|\u001a\u00020I2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010}\u001a\u00020I2\u0006\u0010~\u001a\u00020\u000fH\u0002J\u0011\u0010\u007f\u001a\u00020\u000f2\u0007\u0010\u0080\u0001\u001a\u000200H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0011\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010&\u001a\u0004\u0018\u00010'8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u000e\u0010*\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u00101R\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00109\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010:\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010<\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010=\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010?\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010@\u001a\u0004\u0018\u00010;X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010A\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010B\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010C\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010D\u001a\u0004\u0018\u00010'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\bG\u0010FR\u0011\u0010J\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010LR\u0016\u0010]\u001a\u0004\u0018\u00010'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b^\u0010)\u00a8\u0006\u0083\u0001"}, d2={"Lorg/brailleblaster/utd/utils/BBX2PEFConverter;", "Lorg/brailleblaster/utils/xom/DocumentTraversal$Handler;", "rows", "", "cols", "paperHeight", "", "paperWidth", "leftMargin", "rightMargin", "topMargin", "bottomMargin", "isDuplex", "", "defaultIdentifier", "", "volumeFilter", "Ljava/util/function/IntPredicate;", "<init>", "(IIDDDDDDZLjava/lang/String;Ljava/util/function/IntPredicate;)V", "getPaperHeight", "()D", "getPaperWidth", "getLeftMargin", "getRightMargin", "getTopMargin", "getBottomMargin", "()Z", "getDefaultIdentifier", "()Ljava/lang/String;", "setDefaultIdentifier", "(Ljava/lang/String;)V", "getVolumeFilter", "()Ljava/util/function/IntPredicate;", "docBuilder", "Ljavax/xml/parsers/DocumentBuilder;", "_pefDoc", "Lorg/w3c/dom/Document;", "imagesElement", "Lorg/w3c/dom/Element;", "getImagesElement", "()Lorg/w3c/dom/Element;", "volumeCounter", "includeVolume", "cursorX", "cursorY", "pageGrid", "", "", "[[C", "graphics", "", "Lorg/brailleblaster/utd/utils/BBX2PEFConverter$Graphic;", "imageCounter", "suppressNewPages", "cellType", "Lorg/brailleblaster/libembosser/spi/BrlCell;", "bodyElement", "findDCFormat", "Ljavax/xml/xpath/XPathExpression;", "metaElement", "findDCIdentifier", "findRelativePages", "findRelativeSections", "findVolumes", "curVolElement", "curPageElement", "curSectionElement", "graphicElement", "getRows", "()I", "getCols", "setPageSize", "", "pefDoc", "getPefDoc", "()Lorg/w3c/dom/Document;", "onStartElement", "e", "Lnu/xom/Element;", "onEndElement", "onStartDocument", "d", "Lnu/xom/Document;", "onEndDocument", "createPageElement", "createSectionElement", "createVolumeElement", "startVolume", "endVolume", "startSection", "endSection", "startPage", "insertionElement", "getInsertionElement", "endPage", "insertBlankLines", "lastNonBlankLine", "i", "createGraphicElement", "graphic", "lineLength", "addImageToStore", "imageId", "img", "Ljava/awt/image/BufferedImage;", "processHeadElement", "head", "addMetaItem", "namespaceUri", "name", "value", "processBrl", "processImagePlaceHolder", "loadImage", "imgSrc", "loadImageFile", "imgFile", "Ljava/io/File;", "moveTo", "x", "Ljava/math/BigDecimal;", "y", "setCursor", "insertTextValue", "insertText", "text", "getTrimmedLine", "line", "ListBackedNodeList", "Graphic", "utd"})
@SourceDebugExtension(value={"SMAP\nBBX2PEFConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BBX2PEFConverter.kt\norg/brailleblaster/utd/utils/BBX2PEFConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,711:1\n296#2,2:712\n296#2,2:714\n1#3:716\n*S KotlinDebug\n*F\n+ 1 BBX2PEFConverter.kt\norg/brailleblaster/utd/utils/BBX2PEFConverter\n*L\n395#1:712,2\n413#1:714,2\n*E\n"})
public final class BBX2PEFConverter
implements DocumentTraversal.Handler {
    private final double paperHeight;
    private final double paperWidth;
    private final double leftMargin;
    private final double rightMargin;
    private final double topMargin;
    private final double bottomMargin;
    private final boolean isDuplex;
    @NotNull
    private String defaultIdentifier;
    @NotNull
    private final IntPredicate volumeFilter;
    @Nullable
    private DocumentBuilder docBuilder;
    @Nullable
    private org.w3c.dom.Document _pefDoc;
    @Nullable
    private Element imagesElement;
    private int volumeCounter;
    private boolean includeVolume;
    private int cursorX;
    private int cursorY;
    @NotNull
    private char[][] pageGrid;
    @NotNull
    private final List<Graphic> graphics;
    private int imageCounter;
    private int suppressNewPages;
    @NotNull
    private final BrlCell cellType;
    @Nullable
    private Element bodyElement;
    @Nullable
    private XPathExpression findDCFormat;
    @Nullable
    private Element metaElement;
    @Nullable
    private XPathExpression findDCIdentifier;
    @Nullable
    private XPathExpression findRelativePages;
    @Nullable
    private XPathExpression findRelativeSections;
    @Nullable
    private XPathExpression findVolumes;
    @Nullable
    private Element curVolElement;
    @Nullable
    private Element curPageElement;
    @Nullable
    private Element curSectionElement;
    @Nullable
    private Element graphicElement;

    /*
     * WARNING - void declaration
     */
    public BBX2PEFConverter(int rows, int cols, double paperHeight, double paperWidth, double leftMargin, double rightMargin, double topMargin, double bottomMargin, boolean isDuplex, @NotNull String defaultIdentifier, @NotNull IntPredicate volumeFilter) {
        Intrinsics.checkNotNullParameter((Object)defaultIdentifier, (String)"defaultIdentifier");
        Intrinsics.checkNotNullParameter((Object)volumeFilter, (String)"volumeFilter");
        this.paperHeight = paperHeight;
        this.paperWidth = paperWidth;
        this.leftMargin = leftMargin;
        this.rightMargin = rightMargin;
        this.topMargin = topMargin;
        this.bottomMargin = bottomMargin;
        this.isDuplex = isDuplex;
        this.defaultIdentifier = defaultIdentifier;
        this.volumeFilter = volumeFilter;
        int n = 0;
        Object object = new char[rows][];
        BBX2PEFConverter bBX2PEFConverter = this;
        while (n < rows) {
            int n2 = n++;
            object[n2] = new char[cols];
        }
        bBX2PEFConverter.pageGrid = object;
        this.graphics = new ArrayList();
        this.cellType = BrlCell.NLS;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        bBX2PEFConverter = this;
        try {
            BBX2PEFConverter bBX2PEFConverter2 = bBX2PEFConverter;
            object = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            void e;
            BBX2PEFConverter bBX2PEFConverter3 = bBX2PEFConverter;
            throw new UnsupportedOperationException("No suitable XML DOM implementations.", (Throwable)e);
        }
        bBX2PEFConverter2.docBuilder = object;
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext((NamespaceContext)new PEFNamespaceContext());
        try {
            this.findDCFormat = xpath.compile("/pef:pef/pef:head/pef:meta/dc:format");
            this.findDCIdentifier = xpath.compile("/pef:pef/pef:head/pef:meta/dc:identifier");
            this.findVolumes = xpath.compile("pef:pef/pef:body/pef:volume");
            this.findRelativeSections = xpath.compile("./pef:section");
            this.findRelativePages = xpath.compile("./pef:page");
        }
        catch (XPathExpressionException e) {
            throw new UnsupportedOperationException("Unable to create some required XPath expressions", e);
        }
    }

    public /* synthetic */ BBX2PEFConverter(int n, int n2, double d, double d2, double d3, double d4, double d5, double d6, boolean bl, String string, IntPredicate intPredicate, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            n = 25;
        }
        if ((n3 & 2) != 0) {
            n2 = 40;
        }
        if ((n3 & 4) != 0) {
            d = 0.0;
        }
        if ((n3 & 8) != 0) {
            d2 = 0.0;
        }
        if ((n3 & 0x10) != 0) {
            d3 = 0.0;
        }
        if ((n3 & 0x20) != 0) {
            d4 = 0.0;
        }
        if ((n3 & 0x40) != 0) {
            d5 = 0.0;
        }
        if ((n3 & 0x80) != 0) {
            d6 = 0.0;
        }
        if ((n3 & 0x100) != 0) {
            bl = false;
        }
        if ((n3 & 0x200) != 0) {
            string = "TempID";
        }
        if ((n3 & 0x400) != 0) {
            intPredicate = BBX2PEFConverterKt.ALL_VOLUMES;
        }
        this(n, n2, d, d2, d3, d4, d5, d6, bl, string, intPredicate);
    }

    public final double getPaperHeight() {
        return this.paperHeight;
    }

    public final double getPaperWidth() {
        return this.paperWidth;
    }

    public final double getLeftMargin() {
        return this.leftMargin;
    }

    public final double getRightMargin() {
        return this.rightMargin;
    }

    public final double getTopMargin() {
        return this.topMargin;
    }

    public final double getBottomMargin() {
        return this.bottomMargin;
    }

    public final boolean isDuplex() {
        return this.isDuplex;
    }

    @NotNull
    public final String getDefaultIdentifier() {
        return this.defaultIdentifier;
    }

    public final void setDefaultIdentifier(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.defaultIdentifier = string;
    }

    @NotNull
    public final IntPredicate getVolumeFilter() {
        return this.volumeFilter;
    }

    private final Element getImagesElement() {
        if (this.imagesElement == null) {
            org.w3c.dom.Document document = this._pefDoc;
            Intrinsics.checkNotNull((Object)document);
            this.imagesElement = document.createElementNS("http://www.aph.org/ns/tactile-graphics/1.0", "tg:images");
            org.w3c.dom.Document document2 = this._pefDoc;
            Intrinsics.checkNotNull((Object)document2);
            document2.getDocumentElement().appendChild(this.imagesElement);
        }
        return this.imagesElement;
    }

    public final int getRows() {
        return ((Object[])this.pageGrid).length;
    }

    public final int getCols() {
        return this.getRows() > 0 ? this.pageGrid[0].length : 0;
    }

    public final void setPageSize(int rows, int cols) {
        int n = 0;
        char[][] cArrayArray = new char[rows][];
        BBX2PEFConverter bBX2PEFConverter = this;
        while (n < rows) {
            int n2 = n++;
            cArrayArray[n2] = new char[cols];
        }
        bBX2PEFConverter.pageGrid = cArrayArray;
    }

    @NotNull
    public final org.w3c.dom.Document getPefDoc() {
        org.w3c.dom.Document document = this._pefDoc;
        if (document == null) {
            throw new NoSuchElementException("No BBX has been converted");
        }
        return document;
    }

    public boolean onStartElement(@NotNull nu.xom.Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean descend = true;
        if (UTDElements.BRL.isA((Node)e)) {
            if (this.includeVolume) {
                this.processBrl(e);
            }
            descend = false;
        } else if (Intrinsics.areEqual((Object)"http://brailleblaster.org/ns/bb", (Object)e.getNamespaceURI()) && Intrinsics.areEqual((Object)"head", (Object)e.getLocalName())) {
            this.processHeadElement(e);
            descend = false;
        } else {
            String string = "http://brailleblaster.org/ns/bb";
            String string2 = e.getNamespaceURI();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNamespaceURI(...)");
            if (string.contentEquals(string2)) {
                string = "BLOCK";
                String string3 = e.getLocalName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getLocalName(...)");
                if (string.contentEquals(string3)) {
                    string = "IMAGE_PLACEHOLDER";
                    String string4 = e.getAttributeValue("type", "http://brailleblaster.org/ns/bb");
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAttributeValue(...)");
                    if (string.contentEquals(string4) && this.includeVolume) {
                        this.processImagePlaceHolder(e);
                        descend = false;
                    }
                }
            }
        }
        return descend;
    }

    public void onEndElement(@NotNull nu.xom.Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (Intrinsics.areEqual((Object)"http://brailleblaster.org/ns/bb", (Object)e.getNamespaceURI()) && Intrinsics.areEqual((Object)"CONTAINER", (Object)e.getLocalName()) && Intrinsics.areEqual((Object)"VOLUME", (Object)e.getAttributeValue("type", "http://brailleblaster.org/ns/bb"))) {
            this.endVolume();
            ++this.volumeCounter;
            this.includeVolume = this.volumeFilter.test(this.volumeCounter);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void onStartDocument(@NotNull Document d) {
        void $this$onStartDocument_u24lambda_u240;
        Element element;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.volumeCounter = 0;
        this.imageCounter = 0;
        this.suppressNewPages = 0;
        this.includeVolume = this.volumeFilter.test(this.volumeCounter);
        DocumentBuilder documentBuilder = this.docBuilder;
        Intrinsics.checkNotNull((Object)documentBuilder);
        org.w3c.dom.Document document = this._pefDoc = documentBuilder.newDocument();
        Intrinsics.checkNotNull((Object)document);
        Element rootElement = document.createElementNS("http://www.daisy.org/ns/2008/pef", "pef");
        rootElement.setAttribute("version", "2008-1");
        org.w3c.dom.Document document2 = this._pefDoc;
        Intrinsics.checkNotNull((Object)document2);
        document2.appendChild(rootElement);
        org.w3c.dom.Document document3 = this._pefDoc;
        Intrinsics.checkNotNull((Object)document3);
        Element headElement = document3.createElementNS("http://www.daisy.org/ns/2008/pef", "head");
        rootElement.appendChild(headElement);
        org.w3c.dom.Document document4 = this._pefDoc;
        Intrinsics.checkNotNull((Object)document4);
        Element element2 = element = document4.createElementNS("http://www.daisy.org/ns/2008/pef", "meta");
        BBX2PEFConverter bBX2PEFConverter = this;
        boolean bl = false;
        $this$onStartDocument_u24lambda_u240.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:dc", "http://purl.org/dc/elements/1.1/");
        $this$onStartDocument_u24lambda_u240.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:paper", "http://www.aph.org/ns/paper-dimensions/1.0");
        bBX2PEFConverter.metaElement = element;
        headElement.appendChild(this.metaElement);
        org.w3c.dom.Document document5 = this._pefDoc;
        Intrinsics.checkNotNull((Object)document5);
        this.bodyElement = document5.createElementNS("http://www.daisy.org/ns/2008/pef", "body");
        rootElement.appendChild(this.bodyElement);
    }

    public void onEndDocument(@NotNull Document d) {
        org.w3c.dom.Node n;
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.endVolume();
        try {
            XPathExpression xPathExpression = this.findDCFormat;
            Intrinsics.checkNotNull((Object)xPathExpression);
            Object object = xPathExpression.evaluate(this._pefDoc, XPathConstants.NODESET);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
            NodeList formatList = (NodeList)object;
            if (formatList.getLength() != 1) {
                int n2 = formatList.getLength();
                for (int i = 0; i < n2; ++i) {
                    n = formatList.item(i);
                    Element element = this.metaElement;
                    Intrinsics.checkNotNull((Object)element);
                    element.removeChild(n);
                }
                org.w3c.dom.Document document = this._pefDoc;
                Intrinsics.checkNotNull((Object)document);
                Element formatElement = document.createElementNS("http://purl.org/dc/elements/1.1/", "dc:format");
                formatElement.setTextContent("application/x-pef+xml");
                Element element = this.metaElement;
                Intrinsics.checkNotNull((Object)element);
                element.appendChild(formatElement);
            } else if (Intrinsics.areEqual((Object)"application/x-pef+xml", (Object)formatList.item(0).getTextContent())) {
                formatList.item(0).setTextContent("application/x-pef+xml");
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            org.w3c.dom.Document document = this._pefDoc;
            Intrinsics.checkNotNull((Object)document);
            Element formatElement = document.createElementNS("http://purl.org/dc/elements/1.1/", "dc:format");
            formatElement.setTextContent("application/x-pef+xml");
            Element element = this.metaElement;
            Intrinsics.checkNotNull((Object)element);
            element.appendChild(formatElement);
        }
        try {
            XPathExpression xPathExpression = this.findDCIdentifier;
            Intrinsics.checkNotNull((Object)xPathExpression);
            Object object = xPathExpression.evaluate(this._pefDoc, XPathConstants.NODESET);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
            NodeList identifierList = (NodeList)object;
            if (identifierList.getLength() > 1) {
                int formatElement = identifierList.getLength();
                for (int i = 0; i < formatElement; ++i) {
                    n = identifierList.item(i);
                    Element element = this.metaElement;
                    Intrinsics.checkNotNull((Object)element);
                    element.removeChild(n);
                }
            } else if (identifierList.getLength() < 1) {
                org.w3c.dom.Document document = this._pefDoc;
                Intrinsics.checkNotNull((Object)document);
                Element element = document.createElementNS("http://purl.org/dc/elements/1.1/", "dc:identifier");
                Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElementNS(...)");
                org.w3c.dom.Node identifier = element;
                identifier.setTextContent(this.defaultIdentifier);
                Element element2 = this.metaElement;
                Intrinsics.checkNotNull((Object)element2);
                element2.appendChild(identifier);
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            org.w3c.dom.Document document = this._pefDoc;
            Intrinsics.checkNotNull((Object)document);
            Element element = document.createElementNS("http://purl.org/dc/elements/1.1/", "dc:identifier");
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElementNS(...)");
            org.w3c.dom.Node identifier = element;
            identifier.setTextContent(this.defaultIdentifier);
            Element element3 = this.metaElement;
            Intrinsics.checkNotNull((Object)element3);
            element3.appendChild(identifier);
        }
        try {
            XPathExpression xPathExpression = this.findVolumes;
            Intrinsics.checkNotNull((Object)xPathExpression);
            Object object = xPathExpression.evaluate(this._pefDoc, XPathConstants.NODESET);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
            NodeList vols = (NodeList)object;
            if (vols.getLength() == 0) {
                Element newVol = this.createVolumeElement();
                Element element = this.bodyElement;
                Intrinsics.checkNotNull((Object)element);
                element.appendChild(newVol);
                vols = new ListBackedNodeList(CollectionsKt.listOf((Object)newVol));
            }
            int identifier = vols.getLength();
            for (int volIndex = 0; volIndex < identifier; ++volIndex) {
                org.w3c.dom.Node vol = vols.item(volIndex);
                XPathExpression xPathExpression2 = this.findRelativeSections;
                Intrinsics.checkNotNull((Object)xPathExpression2);
                Object object2 = xPathExpression2.evaluate(vol, XPathConstants.NODESET);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
                NodeList sections = (NodeList)object2;
                if (sections.getLength() == 0) {
                    Element section = this.createSectionElement();
                    vol.appendChild(section);
                    sections = new ListBackedNodeList(CollectionsKt.listOf((Object)section));
                }
                int n3 = sections.getLength();
                for (int sectionIndex = 0; sectionIndex < n3; ++sectionIndex) {
                    org.w3c.dom.Node section = sections.item(sectionIndex);
                    XPathExpression xPathExpression3 = this.findRelativePages;
                    Intrinsics.checkNotNull((Object)xPathExpression3);
                    Object object3 = xPathExpression3.evaluate(section, XPathConstants.NODESET);
                    Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type org.w3c.dom.NodeList");
                    NodeList pages = (NodeList)object3;
                    if (pages.getLength() != 0) continue;
                    section.appendChild(this.createPageElement());
                }
            }
        }
        catch (XPathExpressionException xPathExpressionException) {
            Element vol = this.createVolumeElement();
            Element element = this.bodyElement;
            Intrinsics.checkNotNull((Object)element);
            element.appendChild(vol);
            Element section = this.createSectionElement();
            vol.appendChild(section);
            Element page = this.createPageElement();
            section.appendChild(page);
        }
    }

    private final Element createPageElement() {
        org.w3c.dom.Document document = this._pefDoc;
        Intrinsics.checkNotNull((Object)document);
        Element element = document.createElementNS("http://www.daisy.org/ns/2008/pef", "page");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElementNS(...)");
        return element;
    }

    private final Element createSectionElement() {
        org.w3c.dom.Document document = this._pefDoc;
        Intrinsics.checkNotNull((Object)document);
        Element element = document.createElementNS("http://www.daisy.org/ns/2008/pef", "section");
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElementNS(...)");
        return element;
    }

    private final Element createVolumeElement() {
        org.w3c.dom.Document document = this._pefDoc;
        Intrinsics.checkNotNull((Object)document);
        Element newVol = document.createElementNS("http://www.daisy.org/ns/2008/pef", "volume");
        newVol.setAttribute("duplex", String.valueOf(this.isDuplex));
        newVol.setAttribute("rowgap", "0");
        newVol.setAttribute("rows", String.valueOf(this.getRows()));
        newVol.setAttribute("cols", String.valueOf(this.getCols()));
        Intrinsics.checkNotNull((Object)newVol);
        return newVol;
    }

    private final void startVolume() {
        this.curVolElement = this.createVolumeElement();
        Element element = this.bodyElement;
        Intrinsics.checkNotNull((Object)element);
        element.appendChild(this.curVolElement);
    }

    private final void endVolume() {
        this.endSection();
        this.curVolElement = null;
    }

    private final void startSection() {
        if (this.curVolElement == null) {
            this.startVolume();
        }
        this.curSectionElement = this.createSectionElement();
        Element element = this.curVolElement;
        Intrinsics.checkNotNull((Object)element);
        element.appendChild(this.curSectionElement);
    }

    private final void endSection() {
        this.endPage();
        this.curSectionElement = null;
    }

    private final void startPage() {
        if (this.curSectionElement == null) {
            this.startSection();
        }
        char[][] cArray = this.pageGrid;
        int n = ((Object[])cArray).length;
        for (int i = 0; i < n; ++i) {
            char[] row = cArray[i];
            Arrays.fill(row, '\u2800');
        }
        this.graphics.clear();
        this.setCursor(0, 0);
        this.curPageElement = this.createPageElement();
        Element element = this.curSectionElement;
        Intrinsics.checkNotNull((Object)element);
        element.appendChild(this.curPageElement);
    }

    private final Element getInsertionElement() {
        return this.graphicElement == null ? this.curPageElement : this.graphicElement;
    }

    private final void endPage() {
        if (this.curPageElement != null) {
            int lastNonBlankLine = -1;
            this.graphicElement = null;
            int n = ((Object[])this.pageGrid).length;
            for (int i = 0; i < n; ++i) {
                Object v4;
                Graphic graphic;
                block7: {
                    String curLine;
                    Object v0;
                    block6: {
                        Iterable $this$firstOrNull$iv = this.graphics;
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Graphic it = (Graphic)element$iv;
                            boolean bl = false;
                            if (!(it.getTopLine() == i)) continue;
                            v0 = element$iv;
                            break block6;
                        }
                        v0 = null;
                    }
                    graphic = v0;
                    if (graphic != null) {
                        this.insertBlankLines(lastNonBlankLine, i);
                        this.graphicElement = this.createGraphicElement(graphic, this.getCols());
                        Element element = this.curPageElement;
                        Intrinsics.checkNotNull((Object)element);
                        element.appendChild(this.graphicElement);
                        lastNonBlankLine = i - 1;
                    }
                    if (((CharSequence)(curLine = this.getTrimmedLine(this.pageGrid[i]))).length() > 0) {
                        this.insertBlankLines(lastNonBlankLine, i);
                        org.w3c.dom.Document document = this._pefDoc;
                        Intrinsics.checkNotNull((Object)document);
                        Element row = document.createElementNS("http://www.daisy.org/ns/2008/pef", "row");
                        row.setTextContent(curLine);
                        Element element = this.curPageElement;
                        Intrinsics.checkNotNull((Object)element);
                        element.appendChild(row);
                        lastNonBlankLine = i;
                    }
                    Iterable $this$firstOrNull$iv = this.graphics;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Graphic it = (Graphic)element$iv;
                        boolean bl = false;
                        if (!(it.getBottomLine() == i)) continue;
                        v4 = element$iv;
                        break block7;
                    }
                    v4 = null;
                }
                graphic = v4;
                if (graphic == null) continue;
                this.insertBlankLines(lastNonBlankLine, i + 1);
                lastNonBlankLine = i;
                this.graphicElement = null;
            }
        }
        this.curPageElement = null;
    }

    private final void insertBlankLines(int lastNonBlankLine, int i) {
        int n = i - lastNonBlankLine - 1;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Element element = this.getInsertionElement();
            Intrinsics.checkNotNull((Object)element);
            org.w3c.dom.Document document = this._pefDoc;
            Intrinsics.checkNotNull((Object)document);
            element.appendChild(document.createElementNS("http://www.daisy.org/ns/2008/pef", "row"));
        }
    }

    private final Element createGraphicElement(Graphic graphic, int lineLength) {
        org.w3c.dom.Document document = this._pefDoc;
        Intrinsics.checkNotNull((Object)document);
        Element gElem = document.createElementNS("http://www.aph.org/ns/tactile-graphics/1.0", "tg:graphic");
        gElem.setAttribute("height", String.valueOf(graphic.getBottomLine() + 1 - graphic.getTopLine()));
        gElem.setAttribute("width", String.valueOf(lineLength));
        if (graphic.getImage() != null) {
            this.addImageToStore(graphic.getIdString(), graphic.getImage());
            gElem.setAttribute("idref", graphic.getIdString());
        }
        Intrinsics.checkNotNull((Object)gElem);
        return gElem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void addImageToStore(String imageId, BufferedImage img) {
        try {
            Closeable closeable = new ByteArrayOutputStream();
            Throwable throwable = null;
            try {
                ByteArrayOutputStream output = (ByteArrayOutputStream)closeable;
                boolean bl = false;
                ImageIO.write((RenderedImage)img, "png", output);
                String string = BaseEncoding.base64().encode(output.toByteArray());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
                String imageData = string;
                org.w3c.dom.Document document = this._pefDoc;
                Intrinsics.checkNotNull((Object)document);
                Element imageElement = document.createElementNS("http://www.aph.org/ns/tactile-graphics/1.0", "tg:imageData");
                imageElement.setAttribute("format", "image/png");
                imageElement.setAttribute("encoding", "base64");
                imageElement.setTextContent(imageData);
                imageElement.setAttribute("id", imageId);
                Element element = this.getImagesElement();
                Intrinsics.checkNotNull((Object)element);
                org.w3c.dom.Node node = element.appendChild(imageElement);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private final void processHeadElement(nu.xom.Element head) {
        Elements childElements = head.getChildElements();
        int n = childElements.size();
        for (int i = 0; i < n; ++i) {
            String value;
            String name;
            nu.xom.Element child = childElements.get(i);
            if (Intrinsics.areEqual((Object)"http://purl.org/dc/elements/1.1/", (Object)child.getNamespaceURI())) {
                name = child.getLocalName();
                value = child.getValue();
                String string = "dc:" + name;
                Intrinsics.checkNotNull((Object)value);
                this.addMetaItem("http://purl.org/dc/elements/1.1/", string, value);
                continue;
            }
            if (!Intrinsics.areEqual((Object)"meta", (Object)child.getLocalName()) || (name = child.getAttributeValue("name")) == null || !StringsKt.startsWith$default((String)name, (String)"dc:", (boolean)false, (int)2, null)) continue;
            value = child.getValue();
            Intrinsics.checkNotNull((Object)value);
            this.addMetaItem("http://purl.org/dc/elements/1.1/", name, value);
        }
        String string = "%.1fmm";
        Object[] objectArray = new Object[]{this.paperHeight};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:height", string2);
        string = "%.1fmm";
        objectArray = new Object[]{this.paperWidth};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:width", string3);
        string = "%.1fmm";
        objectArray = new Object[]{this.leftMargin};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:leftMargin", string4);
        string = "%.1fmm";
        objectArray = new Object[]{this.rightMargin};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:rightMargin", string5);
        string = "%.1fmm";
        objectArray = new Object[]{this.topMargin};
        String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:topMargin", string6);
        string = "%.1fmm";
        objectArray = new Object[]{this.bottomMargin};
        String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        this.addMetaItem("http://www.aph.org/ns/paper-dimensions/1.0", "paper:bottomMargin", string7);
    }

    private final void addMetaItem(String namespaceUri, String name, String value) {
        org.w3c.dom.Document document = this._pefDoc;
        Intrinsics.checkNotNull((Object)document);
        Element element = document.createElementNS(namespaceUri, name);
        element.setTextContent(value);
        Element element2 = this.metaElement;
        Intrinsics.checkNotNull((Object)element2);
        element2.appendChild(element);
    }

    private final void processBrl(nu.xom.Element e) {
        int n = e.getChildCount();
        block5: for (int i = 0; i < n; ++i) {
            UTDElements utdElementType;
            Node child = e.getChild(i);
            if (child instanceof Text) {
                this.suppressNewPages = 0;
                String string = ((Text)child).getValue();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
                this.insertText(string);
                continue;
            }
            if (!(child instanceof nu.xom.Element) || (utdElementType = UTDElements.Companion.findType((nu.xom.Element)child)) == null) continue;
            switch (WhenMappings.$EnumSwitchMapping$0[utdElementType.ordinal()]) {
                case 1: {
                    if (this.suppressNewPages > 0) {
                        int n2 = this.suppressNewPages;
                        this.suppressNewPages = n2 + -1;
                        continue block5;
                    }
                    this.endPage();
                    this.startPage();
                    continue block5;
                }
                case 2: {
                    this.suppressNewPages = 0;
                    this.moveTo(new BigDecimal(((nu.xom.Element)child).getAttributeValue("hPos")), new BigDecimal(((nu.xom.Element)child).getAttributeValue("vPos")));
                    continue block5;
                }
                case 3: 
                case 4: 
                case 5: {
                    this.suppressNewPages = 0;
                    this.insertTextValue((nu.xom.Element)child);
                }
            }
        }
    }

    private final void processImagePlaceHolder(nu.xom.Element e) {
        BufferedImage bufferedImage;
        int imageHeight;
        Object object = e.getAttributeValue("skipLines", "http://brailleblaster.org/ns/utd");
        int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : (imageHeight = 1);
        if (imageHeight < 1) {
            return;
        }
        Object object2 = e.getAttributeValue("newPages", "http://brailleblaster.org/ns/utd");
        int n2 = this.suppressNewPages = object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 0;
        int n3 = 0;
        while (n3 < n2) {
            int it = n3++;
            boolean bl = false;
            this.endPage();
            this.startPage();
        }
        if (this.cursorX > 0) {
            n2 = this.cursorY;
            this.cursorY = n2 + 1;
            this.cursorX = 0;
        }
        if (this.cursorY + imageHeight >= ((Object[])this.pageGrid).length) {
            this.endPage();
            this.startPage();
        }
        String string = e.getAttributeValue("src", "http://brailleblaster.org/ns/utd");
        if (string != null) {
            String it = string;
            boolean bl = false;
            bufferedImage = this.loadImage(it);
        } else {
            bufferedImage = null;
        }
        BufferedImage image = bufferedImage;
        int endLine = this.cursorY + imageHeight - 1;
        int n4 = this.imageCounter;
        this.imageCounter = n4 + 1;
        Graphic graphic = new Graphic(n4, image, this.cursorY, endLine);
        this.graphics.add(graphic);
        this.cursorY = endLine;
        this.cursorX = this.pageGrid[endLine].length;
    }

    private final BufferedImage loadImage(String imgSrc) {
        URI uRI;
        try {
            uRI = new URI(imgSrc);
        }
        catch (URISyntaxException uRISyntaxException) {
            URI uRI2 = new File(imgSrc).toURI();
            Intrinsics.checkNotNull((Object)uRI2);
            uRI = uRI2;
        }
        URI imageUri = uRI;
        return Intrinsics.areEqual((Object)"file", (Object)imageUri.getScheme()) ? this.loadImageFile(new File(imageUri)) : null;
    }

    private final BufferedImage loadImageFile(File imgFile) {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(imgFile);
        }
        catch (IOException iOException) {
            bufferedImage = null;
        }
        return bufferedImage;
    }

    private final void moveTo(BigDecimal x, BigDecimal y) {
        int cells = this.cellType.getCellsForWidth(x);
        int lines = this.cellType.getLinesForHeight(y);
        this.setCursor(cells, lines);
    }

    private final void setCursor(int x, int y) {
        this.cursorX = Preconditions.checkPositionIndex((int)x, (int)this.getCols());
        this.cursorY = Preconditions.checkElementIndex((int)y, (int)this.getRows());
    }

    private final void insertTextValue(nu.xom.Element e) {
        int n = e.getChildCount();
        for (int i = 0; i < n; ++i) {
            Node child = e.getChild(i);
            if (!(child instanceof Text)) continue;
            String string = ((Text)child).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
            this.insertText(string);
        }
    }

    private final void insertText(String text) {
        int remainingCells = this.getCols() - this.cursorX;
        double d = remainingCells;
        double d2 = text.length();
        int insertEnd = (int)Math.min(d, d2);
        String unicodeBrl = BrailleMapper.ASCII_TO_UNICODE_FAST.map(text);
        Intrinsics.checkNotNull((Object)unicodeBrl);
        String string = unicodeBrl;
        char[] cArray = this.pageGrid[this.cursorY];
        int n = this.cursorX;
        int n2 = 0;
        string.getChars(n2, insertEnd, cArray, n);
        this.cursorX += insertEnd;
        int n3 = unicodeBrl.length();
        for (int i = insertEnd; i < n3; ++i) {
            char curChar = unicodeBrl.charAt(i);
            if (curChar == '\u2800' || Character.isWhitespace(curChar)) continue;
            String string2 = "Braille not permitted outside the page area, cursor at (%d,%d), Braille is \"%s\" insert end is %d";
            Object[] objectArray = new Object[]{this.cursorX, this.cursorY, text, insertEnd};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            throw new RuntimeException(string3);
        }
    }

    private final String getTrimmedLine(char[] line) {
        StringBuilder sb = new StringBuilder(line.length);
        int lastNonSpaceIndex = -1;
        int n = line.length;
        for (int i = 0; i < n; ++i) {
            if (line[i] == '\u0000' || line[i] == '\u2800' || Character.isWhitespace(line[i])) continue;
            sb.append(StringsKt.repeat((CharSequence)"\u2800", (int)((int)Math.max(0.0, (double)(i - (lastNonSpaceIndex + 1))))));
            lastNonSpaceIndex = i;
            sb.append(line[i]);
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public BBX2PEFConverter() {
        this(0, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 2047, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/utd/utils/BBX2PEFConverter$Graphic;", "", "id", "", "image", "Ljava/awt/image/BufferedImage;", "topLine", "bottomLine", "<init>", "(ILjava/awt/image/BufferedImage;II)V", "getId", "()I", "getImage", "()Ljava/awt/image/BufferedImage;", "getTopLine", "getBottomLine", "idString", "", "getIdString", "()Ljava/lang/String;", "utd"})
    private static final class Graphic {
        private final int id;
        @Nullable
        private final BufferedImage image;
        private final int topLine;
        private final int bottomLine;

        public Graphic(int id, @Nullable BufferedImage image, int topLine, int bottomLine) {
            this.id = id;
            this.image = image;
            this.topLine = topLine;
            this.bottomLine = bottomLine;
        }

        public final int getId() {
            return this.id;
        }

        @Nullable
        public final BufferedImage getImage() {
            return this.image;
        }

        public final int getTopLine() {
            return this.topLine;
        }

        public final int getBottomLine() {
            return this.bottomLine;
        }

        @NotNull
        public final String getIdString() {
            String string = "tg_img%05d";
            Object[] objectArray = new Object[]{this.id};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\bH\u0016R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/utd/utils/BBX2PEFConverter$ListBackedNodeList;", "Lorg/w3c/dom/NodeList;", "nodes", "", "Lorg/w3c/dom/Node;", "<init>", "(Ljava/util/List;)V", "getLength", "", "item", "index", "utd"})
    public static final class ListBackedNodeList
    implements NodeList {
        @NotNull
        private final List<org.w3c.dom.Node> nodes;

        public ListBackedNodeList(@NotNull List<? extends org.w3c.dom.Node> nodes) {
            Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
            this.nodes = nodes;
        }

        public /* synthetic */ ListBackedNodeList(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(list);
        }

        @Override
        public int getLength() {
            return this.nodes.size();
        }

        @Override
        @NotNull
        public org.w3c.dom.Node item(int index) {
            return this.nodes.get(index);
        }

        public ListBackedNodeList() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[UTDElements.values().length];
            try {
                nArray[UTDElements.NEW_PAGE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UTDElements.MOVE_TO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UTDElements.BRL_PAGE_NUM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UTDElements.PRINT_PAGE_NUM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[UTDElements.BRLONLY.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

