/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Builder;
import nu.xom.NodeFactory;
import org.apache.commons.io.input.BOMInputStream;
import org.brailleblaster.utd.internal.NormaliserFactory;
import org.brailleblaster.utils.xml.EntityMap;
import org.brailleblaster.utils.xml.LocalEntityMapHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.EntityResolver2;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J0\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u001c\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/utd/utils/LocalEntityResolver;", "Lorg/xml/sax/ext/EntityResolver2;", "<init>", "()V", "resolveEntity", "Lorg/xml/sax/InputSource;", "name", "", "publicId", "baseUri", "systemId", "resolveEntityImpl", "getExternalSubset", "baseURI", "Companion", "utd"})
public final class LocalEntityResolver
implements EntityResolver2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String SETTING_DISABLE_REMOTE_ENTITY = "localEntityResolver.disableRemoteEntity";
    @NotNull
    private static final Logger log;
    @NotNull
    public static final String ENCODED_URI_PREFIX = "jar-utd-encoded://";
    private static EntityMap localEntities;

    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String name, @Nullable String publicId, @Nullable String baseUri, @NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        try {
            return this.resolveEntityImpl(name, publicId, baseUri, systemId);
        }
        catch (Exception e) {
            throw new RuntimeException("Name '" + name + "' publicId '" + publicId + "' baseUri '" + baseUri + "' systemId '" + systemId + "'", e);
        }
    }

    private final InputSource resolveEntityImpl(String name, String publicId, String baseUri, String systemId) {
        EntityMap entityMap;
        Object[] objectArray = new Object[]{name, publicId, baseUri, systemId};
        log.info("Requested entity name={} publicId={} baseUri={} systemId={}", objectArray);
        if (publicId != null) {
            EntityMap entityMap2 = localEntities;
            if (entityMap2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
                entityMap2 = null;
            }
            if (entityMap2.containsPublicId(publicId)) {
                EntityMap entityMap3 = localEntities;
                if (entityMap3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
                    entityMap3 = null;
                }
                return entityMap3.getByPublicId(publicId);
            }
        }
        boolean noRemoteEntityLookup = Intrinsics.areEqual((Object)System.getProperty(SETTING_DISABLE_REMOTE_ENTITY, "true"), (Object)"true");
        boolean absoluteSystemId = false;
        try {
            URI systemIdUri = new URI(systemId);
            absoluteSystemId = systemIdUri.isAbsolute();
        }
        catch (URISyntaxException uRISyntaxException) {
            absoluteSystemId = false;
        }
        if (baseUri != null && StringsKt.startsWith$default((String)baseUri, (String)ENCODED_URI_PREFIX, (boolean)false, (int)2, null)) {
            try {
                String sourceURI = null;
                if (absoluteSystemId) {
                    EntityMap entityMap4 = localEntities;
                    if (entityMap4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
                        entityMap4 = null;
                    }
                    if (entityMap4.containsSystemId(systemId)) {
                        EntityMap entityMap5 = localEntities;
                        if (entityMap5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
                            entityMap5 = null;
                        }
                        return entityMap5.getBySystemId(systemId);
                    }
                    sourceURI = systemId;
                } else {
                    String string = baseUri.substring(18);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    URI correctedBaseUri = new URI(URLDecoder.decode(string, StandardCharsets.UTF_8));
                    Path basePath = Paths.get(correctedBaseUri);
                    Path sourcePath = basePath.resolveSibling(systemId);
                    String string2 = sourcePath.toUri().toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    sourceURI = string2;
                }
                if (!noRemoteEntityLookup || StringsKt.startsWith$default((String)sourceURI, (String)"jar:file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sourceURI, (String)"file:", (boolean)false, (int)2, null)) {
                    return new InputSource(sourceURI);
                }
            }
            catch (URISyntaxException sourceURI) {
                // empty catch block
            }
        }
        if ((entityMap = localEntities) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
            entityMap = null;
        }
        if (entityMap.containsSystemId(systemId)) {
            EntityMap entityMap6 = localEntities;
            if (entityMap6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"localEntities");
                entityMap6 = null;
            }
            return entityMap6.getBySystemId(systemId);
        }
        if (baseUri != null) {
            try {
                boolean localLookup;
                URI sourcePathUri = new URI(baseUri).resolve(systemId);
                String string = sourcePathUri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                String sourcePath = string;
                boolean bl = localLookup = StringsKt.startsWith$default((String)sourcePath, (String)"file:", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)sourcePath, (String)"jar:", (boolean)false, (int)2, null);
                if (!noRemoteEntityLookup || localLookup) {
                    if (!localLookup) {
                        log.error("No local entity found for publicId={} systemId={} fetching remotely", (Object)publicId, (Object)systemId);
                        return null;
                    }
                    return new InputSource((InputStream)((BOMInputStream.Builder)BOMInputStream.builder().setInputStream(Files.newInputStream(Paths.get(sourcePathUri), new OpenOption[0]))).get());
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error("URI of entity is invalid: {}", (Object)baseUri);
            }
            catch (IOException e) {
                log.error("Problem loading specified entity", (Throwable)e);
            }
        }
        log.error("No entity found for publicId={} systemId={} returning empty", (Object)publicId, (Object)systemId);
        return new InputSource(new StringReader(""));
    }

    @Override
    @Nullable
    public InputSource resolveEntity(@Nullable String publicId, @NotNull String systemId) {
        Intrinsics.checkNotNullParameter((Object)systemId, (String)"systemId");
        return this.resolveEntity(null, publicId, null, systemId);
    }

    @Override
    @Nullable
    public InputSource getExternalSubset(@NotNull String name, @Nullable String baseURI) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return null;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Builder createXomBuilder(boolean validate) throws SAXException, ParserConfigurationException {
        return Companion.createXomBuilder(validate);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Builder createXomBuilder() throws SAXException, ParserConfigurationException {
        return Companion.createXomBuilder();
    }

    static {
        Logger logger = LoggerFactory.getLogger(LocalEntityResolver.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        try {
            SAXParserFactory f = SAXParserFactory.newInstance();
            f.setNamespaceAware(true);
            f.setValidating(true);
            SAXParser sp = f.newSAXParser();
            XMLReader xr = sp.getXMLReader();
            LocalEntityMapHandler entityMapHandler = new LocalEntityMapHandler();
            xr.setContentHandler((ContentHandler)entityMapHandler);
            xr.setEntityResolver((EntityResolver)entityMapHandler);
            xr.parse(new InputSource(LocalEntityResolver.class.getResourceAsStream("/org/brailleblaster/utd/internal/xml/entityMap.xml")));
            localEntities = entityMapHandler.getEntityMap();
        }
        catch (SAXException e) {
            log.error("Problem with SAX parser for loading local XML entities", (Throwable)e);
        }
        catch (IOException e) {
            log.error("Problem accessing local XML entities map file", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.error("Problem creating parser", (Throwable)e);
            throw new RuntimeException("Problem with parser", e);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/brailleblaster/utd/utils/LocalEntityResolver$Companion;", "", "<init>", "()V", "SETTING_DISABLE_REMOTE_ENTITY", "", "log", "Lorg/slf4j/Logger;", "ENCODED_URI_PREFIX", "localEntities", "Lorg/brailleblaster/utils/xml/EntityMap;", "createXomBuilder", "Lnu/xom/Builder;", "validate", "", "utd"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Builder createXomBuilder(boolean validate) throws SAXException, ParserConfigurationException {
            XMLReader parser = SAXParserFactory.newNSInstance("org.apache.xerces.jaxp.SAXParserFactoryImpl", null).newSAXParser().getXMLReader();
            parser.setEntityResolver(new LocalEntityResolver());
            return new Builder(parser, validate, (NodeFactory)new NormaliserFactory());
        }

        public static /* synthetic */ Builder createXomBuilder$default(Companion companion, boolean bl, int n, Object object) throws SAXException, ParserConfigurationException {
            if ((n & 1) != 0) {
                bl = false;
            }
            return companion.createXomBuilder(bl);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Builder createXomBuilder() throws SAXException, ParserConfigurationException {
            return org.brailleblaster.utd.utils.LocalEntityResolver$Companion.createXomBuilder$default(this, false, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

