/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Node;
import nu.xom.Nodes;
import org.brailleblaster.utd.IStyleMap;
import org.brailleblaster.utd.ITranslationEngine;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/utd/utils/PageElementFinder;", "", "elementName", "", "<init>", "(Ljava/lang/String;)V", "getElementName", "()Ljava/lang/String;", "setElementName", "findPageNumbers", "", "document", "Lnu/xom/Node;", "engine", "Lorg/brailleblaster/utd/ITranslationEngine;", "Companion", "utd"})
public final class PageElementFinder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String elementName;
    private static final Logger log = LoggerFactory.getLogger(UTDTranslationEngine.class);

    public PageElementFinder(@NotNull String elementName) {
        Intrinsics.checkNotNullParameter((Object)elementName, (String)"elementName");
        this.elementName = "";
        this.elementName = elementName;
    }

    @NotNull
    public final String getElementName() {
        return this.elementName;
    }

    public final void setElementName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.elementName = string;
    }

    @NotNull
    public final List<String> findPageNumbers(@NotNull Node document, @NotNull ITranslationEngine engine) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)engine, (String)"engine");
        List pageNumsFound = new ArrayList();
        IStyleMap styleMap = engine.getStyleMap();
        Node ancestor = document;
        String lookUpDesc = "descendant::*[contains(name(), '" + this.elementName + "')]";
        try {
            if (document.getParent() != null) {
                Node node = document.query("ancestor::*").get(0);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
                ancestor = node;
            }
            Nodes pageNums = ancestor.query(lookUpDesc);
            int n = pageNums.size();
            for (int i = 0; i < n; ++i) {
                Node node = pageNums.get(i);
                Intrinsics.checkNotNullExpressionValue((Object)node, (String)"get(...)");
                Object v = styleMap.findValueOrDefault(node);
                Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.brailleblaster.utd.Style");
                Style style = (Style)v;
                style.setPageNum(true);
                String page = pageNums.get(i).getValue();
                Intrinsics.checkNotNull((Object)page);
                pageNumsFound.add(page);
            }
        }
        catch (NullPointerException e) {
            log.debug("No <" + this.elementName + "> found.");
        }
        return pageNumsFound;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/brailleblaster/utd/utils/PageElementFinder$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "utd"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

