/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.utd.utils;

import jakarta.xml.bind.JAXBElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import nu.xom.Attribute;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.brailleblaster.utd.Style;
import org.brailleblaster.utd.exceptions.UTDException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u0010\u0018\u001a\u00020\r2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fJ\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00110\u001b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0007J\u0014\u0010\u001c\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u000fH\u0007J \u0010\u001a\u001a\u00020\u001d2\b\u0010\u0019\u001a\u0004\u0018\u00010\u000f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00110\u001fH\u0007J\u001e\u0010 \u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u000f2\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u001fJ\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J\u000e\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000bJ\u0012\u0010%\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\tH\u0007J\u0012\u0010'\u001a\u00020\u00152\b\u0010&\u001a\u0004\u0018\u00010\tH\u0007J\u000e\u0010(\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0011J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,H\u0007J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020\u0011H\u0007J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020\u0011H\u0007J\u0012\u0010/\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0011H\u0007J\u0010\u00101\u001a\u0002002\u0006\u0010\u0017\u001a\u00020\u0011H\u0007J\u0014\u00102\u001a\u0004\u0018\u00010\u00112\b\u00103\u001a\u0004\u0018\u00010,H\u0007J\u0012\u00104\u001a\u0004\u0018\u00010\u00112\u0006\u0010.\u001a\u00020\u000fH\u0002J\u001e\u00105\u001a\u00020\t2\b\u00106\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u000107H\u0007J\u0010\u00108\u001a\u00020\u00152\b\u00109\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lorg/brailleblaster/utd/utils/UTDHelper;", "", "<init>", "()V", "hasBaseStyle", "", "style", "Lorg/brailleblaster/utd/Style;", "baseStyle", "", "BRAILLE_SPACE", "", "getBrlElements", "Lnu/xom/Nodes;", "node", "Lnu/xom/Node;", "getAssociatedBrlElement", "Lnu/xom/Element;", "parent", "Lnu/xom/ParentNode;", "idx", "", "getAssociatedNode", "brlElement", "getDescendantBrlFastNodes", "root", "getDescendantBrlFast", "", "getDescendantBrlFastFirst", "", "onBrl", "Ljava/util/function/Consumer;", "getTableCopies", "onTable", "containsBrl", "isWhitespace", "input", "endsWithWhitespace", "str", "startsWithWhitespace", "toXMLnoBRL", "toXMLnoUTD", "stripUTDRecursive", "rootRaw", "Lnu/xom/Document;", "stripBRLOnly", "element", "getTextChild", "Lnu/xom/Text;", "getFirstTextDescendant", "getDocumentHead", "document", "findHead", "autoToString", "object", "Lorg/apache/commons/lang3/builder/ToStringStyle;", "findCurrentVolumeNumber", "currNode", "utd"})
@SourceDebugExtension(value={"SMAP\nUTDHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UTDHelper.kt\norg/brailleblaster/utd/utils/UTDHelper\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,443:1\n1276#2,2:444\n1#3:446\n654#4,5:447\n812#5,12:452\n777#5:464\n873#5,2:465\n742#5,9:467\n37#6,2:476\n*S KotlinDebug\n*F\n+ 1 UTDHelper.kt\norg/brailleblaster/utd/utils/UTDHelper\n*L\n33#1:444,2\n278#1:447,5\n426#1:452,12\n427#1:464\n427#1:465,2\n436#1:467,9\n436#1:476,2\n*E\n"})
public final class UTDHelper {
    @NotNull
    public static final UTDHelper INSTANCE = new UTDHelper();
    public static final char BRAILLE_SPACE = '\u2800';

    private UTDHelper() {
    }

    public final boolean hasBaseStyle(@Nullable Style style, @NotNull String baseStyle) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)baseStyle, (String)"baseStyle");
            Sequence $this$any$iv = SequencesKt.generateSequence((Object)style, UTDHelper::hasBaseStyle$lambda$0);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Style it = (Style)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)baseStyle)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Nodes getBrlElements(@Nullable Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        Nodes returnNode = new Nodes();
        Element associatedBrl = UTDHelper.getAssociatedBrlElement(node);
        if (associatedBrl == null) {
            UTDHelper.getDescendantBrlFast(node, arg_0 -> UTDHelper.getBrlElements$lambda$0(returnNode, arg_0));
        } else {
            returnNode.append((Node)associatedBrl);
        }
        return returnNode;
    }

    @JvmStatic
    @Nullable
    public static final Element getAssociatedBrlElement(@Nullable Node node) {
        if (node == null) {
            throw new NullPointerException();
        }
        ParentNode parentNode = node.getParent();
        if (parentNode == null) {
            return null;
        }
        ParentNode parent = parentNode;
        int index = parent.indexOf(node);
        return UTDHelper.getAssociatedBrlElement(parent, index);
    }

    @JvmStatic
    @Nullable
    public static final Element getAssociatedBrlElement(@Nullable ParentNode parent, int idx) {
        Node returnElement;
        if (parent == null) {
            throw new NullPointerException("The parent cannot be null");
        }
        int index = idx + 1;
        if (index < parent.getChildCount() && UTDElements.BRL.isA(returnElement = parent.getChild(index))) {
            Intrinsics.checkNotNull((Object)returnElement, (String)"null cannot be cast to non-null type nu.xom.Element");
            String typeAttr = ((Element)returnElement).getAttributeValue("type");
            if (!Intrinsics.areEqual((Object)"brlonly", (Object)typeAttr) && !Intrinsics.areEqual((Object)"formatting", (Object)typeAttr)) {
                return (Element)returnElement;
            }
        }
        return null;
    }

    @JvmStatic
    @Nullable
    public static final Node getAssociatedNode(@Nullable Element brlElement) {
        if (brlElement == null) {
            throw new NullPointerException();
        }
        if (!UTDElements.BRL.isA((Node)brlElement)) {
            boolean $i$a$-require-UTDHelper$getAssociatedNode$22 = false;
            String $i$a$-require-UTDHelper$getAssociatedNode$22 = "This is not a brl element.";
            throw new IllegalArgumentException($i$a$-require-UTDHelper$getAssociatedNode$22.toString());
        }
        if (Intrinsics.areEqual((Object)"formatting", (Object)brlElement.getAttributeValue("type"))) {
            return null;
        }
        if (Intrinsics.areEqual((Object)"true", (Object)brlElement.getAttributeValue("brlonly"))) {
            return null;
        }
        ParentNode parentNode = brlElement.getParent();
        if (parentNode == null) {
            return null;
        }
        ParentNode parent = parentNode;
        int index = parent.indexOf((Node)brlElement) - 1;
        if (index < 0) {
            throw new UTDException("Invalid UTD. " + brlElement.toXML());
        }
        return parent.getChild(index);
    }

    @NotNull
    public final Nodes getDescendantBrlFastNodes(@Nullable Node root) {
        Nodes results = new Nodes();
        UTDHelper.getDescendantBrlFast(root, arg_0 -> UTDHelper.getDescendantBrlFastNodes$lambda$0(results, arg_0));
        return results;
    }

    @JvmStatic
    @NotNull
    public static final List<Element> getDescendantBrlFast(@Nullable Node root) {
        List results = new ArrayList();
        UTDHelper.getDescendantBrlFast(root, arg_0 -> UTDHelper.getDescendantBrlFast$lambda$0(results, arg_0));
        return results;
    }

    @JvmStatic
    @Nullable
    public static final Element getDescendantBrlFastFirst(@Nullable Node root) {
        List<Element> result = UTDHelper.getDescendantBrlFast(root);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    @JvmStatic
    public static final void getDescendantBrlFast(@Nullable Node root, @NotNull Consumer<Element> onBrl) {
        Intrinsics.checkNotNullParameter(onBrl, (String)"onBrl");
        if (!(root instanceof ParentNode)) {
            return;
        }
        if (UTDElements.BRL.isA(root)) {
            onBrl.accept((Element)root);
            return;
        }
        Element realRoot = XMLHandler.Companion.parentToElement((ParentNode)root);
        Iterator iterator = realRoot.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element childNode = (Element)iterator2.next();
            if (UTDElements.BRL.isA((Node)childNode)) {
                onBrl.accept(childNode);
                continue;
            }
            UTDHelper.getDescendantBrlFast((Node)childNode, onBrl);
        }
    }

    public final void getTableCopies(@NotNull Node root, @NotNull Consumer<Element> onTable) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(onTable, (String)"onTable");
        if (!(root instanceof ParentNode)) {
            return;
        }
        Element realRoot = XMLHandler.Companion.parentToElement((ParentNode)root);
        Iterator iterator = realRoot.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element childNode = (Element)iterator2.next();
            if (childNode.getAttribute("class") != null) {
                String string = childNode.getAttributeValue("class");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"utd:table", (boolean)false, (int)2, null)) {
                    onTable.accept(childNode);
                    continue;
                }
            }
            Intrinsics.checkNotNull((Object)childNode);
            this.getTableCopies((Node)childNode, onTable);
        }
    }

    @JvmStatic
    public static final boolean containsBrl(@NotNull Node root) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        if (!(root instanceof ParentNode)) {
            return false;
        }
        if (UTDElements.BRL.isA(root)) {
            return true;
        }
        Element realRoot = XMLHandler.Companion.parentToElement((ParentNode)root);
        Iterator iterator = realRoot.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element childNode = (Element)iterator2.next();
            if (UTDElements.BRL.isA((Node)childNode)) {
                return true;
            }
            Intrinsics.checkNotNull((Object)childNode);
            if (!UTDHelper.containsBrl((Node)childNode)) continue;
            return true;
        }
        return false;
    }

    public final boolean isWhitespace(char input) {
        return Character.isWhitespace(input) || input == '\u2800';
    }

    @JvmStatic
    public static final int endsWithWhitespace(@Nullable String str) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (((CharSequence)str).length() == 0) {
            return 0;
        }
        int counter = 0;
        for (int i = str.length() - 1; -1 < i && INSTANCE.isWhitespace(str.charAt(i)); --i) {
            ++counter;
        }
        return counter;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final int startsWithWhitespace(@Nullable String str) {
        String string;
        block3: {
            void var1_1;
            if (str == null) {
                throw new NullPointerException("str");
            }
            if (((CharSequence)str).length() == 0) {
                return 0;
            }
            String $this$takeWhile$iv = str;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (INSTANCE.isWhitespace(it)) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block3;
            }
            string = var1_1;
        }
        return string.length();
    }

    @NotNull
    public final String toXMLnoBRL(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element nodeCopy = node.copy();
        UTDHelper.getDescendantBrlFast((Node)nodeCopy, UTDHelper::toXMLnoBRL$lambda$0);
        String string = nodeCopy.toXML();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
        return string;
    }

    @NotNull
    public final String toXMLnoUTD(@NotNull Element node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Element nodeCopy = node.copy();
        Intrinsics.checkNotNull((Object)nodeCopy);
        UTDHelper.stripUTDRecursive(nodeCopy);
        String string = nodeCopy.toXML();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toXML(...)");
        return string;
    }

    @JvmStatic
    public static final void stripUTDRecursive(@NotNull Document rootRaw) {
        Intrinsics.checkNotNullParameter((Object)rootRaw, (String)"rootRaw");
        Element element = rootRaw.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        UTDHelper.stripUTDRecursive(element);
    }

    @JvmStatic
    public static final void stripUTDRecursive(@NotNull Element rootRaw) {
        Intrinsics.checkNotNullParameter((Object)rootRaw, (String)"rootRaw");
        if (UTDElements.BRL.isA((Node)rootRaw) || Intrinsics.areEqual((Object)"http://brailleblaster.org/ns/utd", (Object)rootRaw.getNamespaceURI()) && Intrinsics.areEqual((Object)"tablebrl", (Object)rootRaw.getLocalName())) {
            rootRaw.detach();
            return;
        }
        Attribute attrib = rootRaw.getAttribute("utd-action");
        if (attrib != null) {
            rootRaw.removeAttribute(attrib);
        }
        if ((attrib = rootRaw.getAttribute("utd-style")) != null) {
            rootRaw.removeAttribute(attrib);
        }
        Iterator iterator = rootRaw.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element curChild = (Element)iterator2.next();
            Intrinsics.checkNotNull((Object)curChild);
            UTDHelper.stripUTDRecursive(curChild);
        }
    }

    @JvmStatic
    public static final void stripBRLOnly(@NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (UTDElements.BRLONLY.isA((Node)element) && element.getAttribute("type") != null && Intrinsics.areEqual((Object)element.getAttributeValue("type"), (Object)"guideDots")) {
            element.detach();
            return;
        }
        if (UTDElements.MOVE_TO.isA((Node)element)) {
            element.detach();
            return;
        }
        Iterator iterator = element.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element child = (Element)iterator2.next();
            Intrinsics.checkNotNull((Object)child);
            UTDHelper.stripBRLOnly(child);
        }
    }

    @JvmStatic
    @NotNull
    public static final Text getTextChild(@Nullable Element brlElement) {
        Text text = new Text("");
        if (brlElement != null) {
            int n = brlElement.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (!(brlElement.getChild(i) instanceof Text)) continue;
                Node node = brlElement.getChild(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                return (Text)node;
            }
        }
        return text;
    }

    @JvmStatic
    @NotNull
    public static final Text getFirstTextDescendant(@NotNull Element brlElement) {
        Intrinsics.checkNotNullParameter((Object)brlElement, (String)"brlElement");
        Text text = new Text("");
        int n = brlElement.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (brlElement.getChild(i) instanceof Text) {
                Node node = brlElement.getChild(i);
                Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Text");
                return (Text)node;
            }
            if (!(brlElement.getChild(i) instanceof Element)) continue;
            Node node = brlElement.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            return UTDHelper.getFirstTextDescendant((Element)node);
        }
        return text;
    }

    @JvmStatic
    @Nullable
    public static final Element getDocumentHead(@Nullable Document document) {
        if (document == null) {
            return null;
        }
        Element element = document.getRootElement();
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"getRootElement(...)");
        Node rootNode = (Node)element;
        return INSTANCE.findHead(rootNode);
    }

    private final Element findHead(Node element) {
        int n = element.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!(element.getChild(i) instanceof Element)) continue;
            Node node = element.getChild(i);
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
            Element child = (Element)node;
            if (Intrinsics.areEqual((Object)child.getLocalName(), (Object)"head")) {
                return child;
            }
            if (Intrinsics.areEqual((Object)child.getLocalName(), (Object)"book")) {
                return null;
            }
            return this.findHead((Node)child);
        }
        return null;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String autoToString(@Nullable Object object, @Nullable ToStringStyle style) {
        String string = new ReflectionToStringBuilder(object, style){

            protected Object getValue(Field field) throws IllegalArgumentException, IllegalAccessException {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Object value = field.get(this.getObject());
                return value == null ? null : (Node.class.isAssignableFrom(field.getType()) ? XMLHandler.Companion.toXMLSimple((Node)value) : (JAXBElement.class.isAssignableFrom(field.getType()) ? ((JAXBElement)value).getValue() : value));
            }
        }.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public static /* synthetic */ String autoToString$default(Object object, ToStringStyle toStringStyle, int n, Object object2) {
        if ((n & 2) != 0) {
            toStringStyle = null;
        }
        return UTDHelper.autoToString(object, toStringStyle);
    }

    /*
     * WARNING - void declaration
     */
    public final int findCurrentVolumeNumber(@Nullable Node currNode) {
        void $this$filterTo$iv$iv;
        Iterable $this$filterIsInstanceTo$iv$iv;
        if (currNode == null) {
            return 0;
        }
        Iterable<Node> $this$filterIsInstance$iv = FastXPath.INSTANCE.preceding(currNode);
        boolean $i$f$filterIsInstance = false;
        Iterable<Node> iterable = $this$filterIsInstance$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof Element)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Element curNode = (Element)element$iv$iv;
            boolean bl = false;
            boolean bl2 = curNode.getAttribute("utd-style") != null && Intrinsics.areEqual((Object)curNode.getAttributeValue("utd-style"), (Object)"Volume End");
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List volumes = (List)destination$iv$iv;
        if (!((Collection)volumes).isEmpty()) {
            void $this$toTypedArray$iv;
            List list;
            Collection $this$dropLastWhile$iv;
            Element volumeBefore = (Element)volumes.get(0);
            String endOfVolumeText = UTDHelper.getFirstTextDescendant(volumeBefore).getValue();
            Intrinsics.checkNotNull((Object)endOfVolumeText);
            destination$iv$iv = endOfVolumeText;
            Regex $i$f$filterTo2 = new Regex(" ");
            int n = 0;
            destination$iv$iv = $i$f$filterTo2.split((CharSequence)destination$iv$iv, n);
            boolean $i$f$dropLastWhile = false;
            if (!$this$dropLastWhile$iv.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list = CollectionsKt.emptyList();
            }
            $this$dropLastWhile$iv = list;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] split = thisCollection$iv.toArray(new String[0]);
            return Integer.parseInt(split[split.length - 1]) + 1;
        }
        return 0;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String autoToString(@Nullable Object object) {
        return UTDHelper.autoToString$default(object, null, 2, null);
    }

    private static final Style hasBaseStyle$lambda$0(Style it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getBaseStyle();
    }

    private static final void getBrlElements$lambda$0(Nodes $returnNode, Element brl) {
        Intrinsics.checkNotNullParameter((Object)brl, (String)"brl");
        String typeAttrib = brl.getAttributeValue("type");
        if (typeAttrib != null && (Intrinsics.areEqual((Object)typeAttrib, (Object)"brlonly") || Intrinsics.areEqual((Object)typeAttrib, (Object)"formatting"))) {
            return;
        }
        $returnNode.append((Node)brl);
    }

    private static final void getDescendantBrlFastNodes$lambda$0(Nodes $results, Element node) {
        $results.append((Node)node);
    }

    private static final void getDescendantBrlFast$lambda$0(List $results, Element e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        $results.add(e);
    }

    private static final void toXMLnoBRL$lambda$0(Element obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        obj.detach();
    }
}

