/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.debug;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableCellTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TableTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\b\u0010\u000e\u001a\u00020\rH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/debug/MapListDebugger;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "dialog", "Lorg/eclipse/swt/widgets/Shell;", "mapListViewer", "Lorg/eclipse/swt/custom/StyledText;", "showBrailleList", "", "open", "", "reload", "setMapText", "", "newElem", "Lorg/brailleblaster/perspectives/braille/mapping/elements/TextMapElement;", "curIndex", "", "brailleblaster-debug-tools"})
@SourceDebugExtension(value={"SMAP\nMapListDebugger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MapListDebugger.kt\norg/brailleblaster/debug/MapListDebugger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1#2:135\n*E\n"})
public final class MapListDebugger {
    @NotNull
    private final Manager m;
    @Nullable
    private Shell dialog;
    private StyledText mapListViewer;
    private boolean showBrailleList;

    public MapListDebugger(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
    }

    public final void open() {
        Shell dialog;
        this.dialog = dialog = EasySWT.INSTANCE.makeDialogFloating(this.m.getWpManager().getShell());
        dialog.setSize(400, 300);
        dialog.setLayout((Layout)new GridLayout(3, false));
        this.mapListViewer = new StyledText((Composite)dialog, 2570);
        StyledText styledText = this.mapListViewer;
        if (styledText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
            styledText = null;
        }
        EasySWT.INSTANCE.setGridData((Control)styledText);
        StyledText styledText2 = this.mapListViewer;
        if (styledText2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
            styledText2 = null;
        }
        Intrinsics.checkNotNull((Object)styledText2.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
        ((GridData)styledText2.getLayoutData()).horizontalSpan = 3;
        StyledText styledText3 = this.mapListViewer;
        if (styledText3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
            styledText3 = null;
        }
        Intrinsics.checkNotNull((Object)styledText3.getLayoutData(), (String)"null cannot be cast to non-null type org.eclipse.swt.layout.GridData");
        ((GridData)styledText3.getLayoutData()).grabExcessVerticalSpace = true;
        Button updateButton = new Button((Composite)dialog, 8);
        updateButton.setText("Update");
        updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
            final /* synthetic */ MapListDebugger this$0;
            {
                this.this$0 = $receiver;
            }

            public void widgetSelected(SelectionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                StyledText styledText = MapListDebugger.access$getMapListViewer$p(this.this$0);
                if (styledText == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
                    styledText = null;
                }
                TextMapElement textMapElement = MapListDebugger.access$getM$p(this.this$0).getMapList().getCurrent();
                Intrinsics.checkNotNullExpressionValue((Object)textMapElement, (String)"getCurrent(...)");
                styledText.setText(this.this$0.setMapText(textMapElement, MapListDebugger.access$getM$p(this.this$0).getMapList().getCurrentIndex()));
            }
        });
        Button seeWholeList = new Button((Composite)dialog, 8);
        seeWholeList.setText("See Whole List");
        EasySWT.addSelectionListener((Button)seeWholeList, arg_0 -> MapListDebugger.open$lambda$0(this, arg_0));
        Button showBrailleButton = new Button((Composite)dialog, 32);
        showBrailleButton.setText("Show Braille MapList");
        showBrailleButton.setSelection(this.showBrailleList);
        EasySWT.addSelectionListener((Button)showBrailleButton, arg_0 -> MapListDebugger.open$lambda$1(this, showBrailleButton, arg_0));
        dialog.open();
    }

    private final void reload() {
        String output = this.m.getMapList().printContents(this.showBrailleList);
        StyledText styledText = this.mapListViewer;
        if (styledText == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
            styledText = null;
        }
        styledText.setText(output);
        int start = 0;
        int nextStart = 0;
        while (true) {
            int nextNewLine;
            block8: {
                block9: {
                    block7: {
                        int n;
                        Intrinsics.checkNotNull((Object)output);
                        int it = n = StringsKt.indexOf$default((CharSequence)output, (String)"\n", (int)start, (boolean)false, (int)4, null);
                        boolean bl = false;
                        nextStart = it;
                        if (n == -1 || (nextNewLine = StringsKt.indexOf$default((CharSequence)output, (String)"\n", (int)(nextStart + 1), (boolean)false, (int)4, null)) == -1) break;
                        if (output.charAt(nextStart + 1) != '-') break block7;
                        StyleRange range = new StyleRange();
                        range.start = nextStart;
                        range.length = nextNewLine - nextStart;
                        range.background = Display.getCurrent().getSystemColor(11);
                        range.background = Display.getCurrent().getSystemColor(5);
                        StyledText styledText2 = this.mapListViewer;
                        if (styledText2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
                            styledText2 = null;
                        }
                        styledText2.setStyleRange(range);
                        break block8;
                    }
                    String string = output.substring(nextStart, nextNewLine);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Offsets:-1", (boolean)false, (int)2, null)) break block9;
                    String string2 = output.substring(nextStart, nextNewLine);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    if (!StringsKt.contains$default((CharSequence)string2, (CharSequence)"--1", (boolean)false, (int)2, null)) break block8;
                }
                StyleRange range = new StyleRange();
                range.start = nextStart;
                range.length = nextNewLine - nextStart;
                range.background = Display.getCurrent().getSystemColor(3);
                StyledText styledText3 = this.mapListViewer;
                if (styledText3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"mapListViewer");
                    styledText3 = null;
                }
                styledText3.setStyleRange(range);
            }
            start = nextNewLine;
        }
        Shell shell = this.dialog;
        Intrinsics.checkNotNull((Object)shell);
        EasySWT.INSTANCE.setLargeDialogSize(shell);
    }

    @NotNull
    public final String setMapText(@NotNull TextMapElement newElem, int curIndex) {
        Intrinsics.checkNotNullParameter((Object)newElem, (String)"newElem");
        StringBuilder newText = new StringBuilder();
        newText.append("Current TextMapElement: ").append(newElem.getNode().toXML()).append("\nSize of BrailleList: ").append(newElem.brailleList.size()).append("\nIndex: ").append(curIndex).append("  Offsets: Start: ").append(newElem.getStart(this.m.getMapList())).append(" End: ").append(newElem.getEnd(this.m.getMapList())).append("\nContents of BrailleList:");
        int n = ((Collection)newElem.brailleList).size();
        for (int i = 0; i < n; ++i) {
            newText.append("\n\t").append(((BrailleMapElement)newElem.brailleList.get(i)).getText()).append(" Braille View Offsets: ").append(((BrailleMapElement)newElem.brailleList.get(i)).getStart(this.m.getMapList())).append("-").append(((BrailleMapElement)newElem.brailleList.get(i)).getEnd(this.m.getMapList()));
        }
        if (newElem instanceof TableTextMapElement) {
            newText.append("\n----- Table Elements -----\n");
            Iterator iterator = ((Iterable)((TableTextMapElement)newElem).tableElements).iterator();
            n = 0;
            while (iterator.hasNext()) {
                int k = n++;
                TableCellTextMapElement cell = (TableCellTextMapElement)iterator.next();
                newText.append(this.setMapText((TextMapElement)cell, k)).append("\n-----\n");
            }
            newText.append("\n--------------------------");
        }
        String string = newText.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void open$lambda$0(MapListDebugger this$0, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.reload();
    }

    private static final void open$lambda$1(MapListDebugger this$0, Button $showBrailleButton, SelectionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.showBrailleList = $showBrailleButton.getSelection();
        this$0.reload();
    }

    public static final /* synthetic */ StyledText access$getMapListViewer$p(MapListDebugger $this) {
        return $this.mapListViewer;
    }

    public static final /* synthetic */ Manager access$getM$p(MapListDebugger $this) {
        return $this.m;
    }
}

