/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.debug;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.perspectives.braille.mapping.elements.BrailleMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.BraillePageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PageIndicatorTextMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.PrintPageBrlMapElement;
import org.brailleblaster.perspectives.braille.mapping.elements.SectionElement;
import org.brailleblaster.perspectives.braille.mapping.elements.TextMapElement;
import org.brailleblaster.util.ConstantsKt;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lorg/brailleblaster/debug/PageNumberDebugger;", "", "manager", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "brailleblaster-debug-tools"})
public final class PageNumberDebugger {
    public PageNumberDebugger(@NotNull Manager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Shell shell = EasySWT.INSTANCE.makeDialogFloating(manager.getWpManager().getShell());
        shell.setLayout((Layout)new GridLayout(1, true));
        TabFolder tabContainer = new TabFolder((Composite)shell, 0);
        EasySWT.INSTANCE.setGridDataVertical((Control)tabContainer);
        TabItem printPageTab = new TabItem(tabContainer, 0);
        printPageTab.setText("Print Pages");
        StyledText printPageLabel = new StyledText((Composite)tabContainer, 520);
        printPageTab.setControl((Control)printPageLabel);
        TabItem braillePageTab = new TabItem(tabContainer, 0);
        braillePageTab.setText("Braille Pages");
        StyledText braillePageLabel = new StyledText((Composite)tabContainer, 520);
        braillePageTab.setControl((Control)braillePageLabel);
        StringBuilder printPageBuilder = new StringBuilder();
        StringBuilder braillePageBuilder = new StringBuilder();
        Iterator iterator = manager.getSectionList().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Iterator iterator3;
            SectionElement curSection = (SectionElement)iterator2.next();
            Intrinsics.checkNotNullExpressionValue((Object)curSection.list.iterator(), (String)"iterator(...)");
            while (iterator3.hasNext()) {
                Iterator iterator4;
                Object e = iterator3.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                TextMapElement curMapping = (TextMapElement)e;
                if (curMapping instanceof PageIndicatorTextMapElement) {
                    Element usableNode;
                    String brlPageNum;
                    Node node = ((PageIndicatorTextMapElement)curMapping).getNode();
                    Element element = node instanceof Element ? (Element)node : null;
                    if (element == null) {
                        element = ((PageIndicatorTextMapElement)curMapping).getNodeParent();
                    }
                    if ((brlPageNum = (usableNode = element).getAttributeValue("printPage")) == null) continue;
                    printPageBuilder.append("PageMapElement: ").append(brlPageNum).append(ConstantsKt.getLINE_BREAK());
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue(curMapping.brailleList.iterator(), (String)"iterator(...)");
                while (iterator4.hasNext()) {
                    BrailleMapElement curBrailleElement = (BrailleMapElement)iterator4.next();
                    if (curBrailleElement instanceof PrintPageBrlMapElement) {
                        Node node = ((PrintPageBrlMapElement)curBrailleElement).getNode();
                        Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type nu.xom.Element");
                        String origPage = ((Element)node).getAttributeValue("printPage");
                        String braillePage = ((PrintPageBrlMapElement)curBrailleElement).getNode().getValue();
                        printPageBuilder.append("PrintPageMapElement: ").append(origPage).append(" - ").append(braillePage).append(ConstantsKt.getLINE_BREAK());
                        continue;
                    }
                    if (!(curBrailleElement instanceof BraillePageBrlMapElement)) continue;
                    String page = ((BraillePageBrlMapElement)curBrailleElement).getNode().getValue();
                    braillePageBuilder.append("BraillePageMapElement: ").append(page).append(ConstantsKt.getLINE_BREAK());
                }
            }
        }
        printPageLabel.setText(printPageBuilder.toString());
        braillePageLabel.setText(braillePageBuilder.toString());
        shell.open();
    }
}

