/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.context.StyleAttributeLayoutContext;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.JEuclidNode;
import net.sourceforge.jeuclid.elements.support.ElementListSupport;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.AttributesHelper;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.TextContent;
import net.sourceforge.jeuclid.layout.LayoutInfo;
import net.sourceforge.jeuclid.layout.LayoutStage;
import net.sourceforge.jeuclid.layout.LayoutView;
import net.sourceforge.jeuclid.layout.LayoutableNode;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericElementNS;
import org.apache.batik.dom.events.DOMMutationEvent;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.events.Event;
import org.w3c.dom.mathml.MathMLElement;
import org.w3c.dom.mathml.MathMLMathElement;
import org.w3c.dom.mathml.MathMLNodeList;

public abstract class AbstractJEuclidElement
extends GenericElementNS
implements JEuclidElement {
    public static final String ATTR_MATHVARIANT = "mathvariant";
    public static final String ATTR_MATHCOLOR = "mathcolor";
    public static final String ATTR_MATHSIZE = "mathsize";
    public static final String ATTR_DEPRECATED_FONTFAMILY = "fontfamily";
    public static final String ATTR_DEPRECATED_FONTSTYLE = "fontstyle";
    public static final String ATTR_DEPRECATED_FONTWEIGHT = "fontweight";
    public static final String ATTR_DEPRECATED_FONTSIZE = "fontsize";
    public static final String ATTR_DEPRECATED_COLOR = "color";
    public static final String ATTR_DEPRECATED_BACKGROUND = "background";
    public static final String ATTR_CLASS = "class";
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_ID = "id";
    public static final String ATTR_HREF = "xlink:href";
    public static final String ATTR_XREF = "xref";
    public static final String ATTR_MATHBACKGROUND = "mathbackground";
    public static final int TRIVIAL_SPACE_MAX = 32;
    public static final String URI = "http://www.w3.org/1998/Math/MathML";
    private static final float MIDDLE_SHIFT = 0.38f;
    private static final Set<String> DEPRECATED_ATTRIBUTES = new HashSet<String>();
    private JEuclidElement fakeParent;
    private final Map<String, String> defaultMathAttributes = new HashMap<String, String>();

    public AbstractJEuclidElement(String string, AbstractDocument abstractDocument) {
        super(URI, string, abstractDocument);
    }

    public AbstractJEuclidElement(String string, String string2, AbstractDocument abstractDocument) {
        super(string, string2, abstractDocument);
    }

    public Font getFont(LayoutContext layoutContext) {
        String string = this.getText();
        int n = !string.isEmpty() ? (int)string.charAt(0) : 65;
        return this.getMathvariantAsVariant().createFont(GraphicsSupport.getFontsizeInPoint(layoutContext), n, this.applyLocalAttributesToContext(layoutContext), true);
    }

    @Override
    public MathVariant getMathvariantAsVariant() {
        MathVariant mathVariant;
        String string = this.getMathAttribute(ATTR_MATHVARIANT, false);
        for (JEuclidElement jEuclidElement = this.getParent(); string == null && jEuclidElement != null; jEuclidElement = jEuclidElement.getParent()) {
            if (!(jEuclidElement instanceof AbstractJEuclidElement)) continue;
            string = ((AbstractJEuclidElement)jEuclidElement).getMathAttribute(ATTR_MATHVARIANT, false);
        }
        if (string == null) {
            string = this.defaultMathAttributes.get(ATTR_MATHVARIANT);
        }
        if (string == null) {
            mathVariant = MathVariant.NORMAL;
        } else {
            mathVariant = MathVariant.stringToMathVariant(string);
            if (mathVariant == null) {
                mathVariant = MathVariant.NORMAL;
            }
        }
        return mathVariant;
    }

    public final void addMathElement(MathMLElement mathMLElement) {
        if (mathMLElement != null) {
            this.appendChild(mathMLElement);
        }
    }

    protected JEuclidElement getMathElement(int n) {
        List<Node> list = ElementListSupport.createListOfChildren(this);
        int n2 = 0;
        for (Node node : list) {
            if (!(node instanceof JEuclidElement)) continue;
            if (n2 == n) {
                return (JEuclidElement)node;
            }
            ++n2;
        }
        while (n2 < n) {
            this.appendChild(this.ownerDocument.createElement("mtext"));
            ++n2;
        }
        JEuclidElement jEuclidElement = (JEuclidElement)this.ownerDocument.createElement("mtext");
        this.appendChild(jEuclidElement);
        return jEuclidElement;
    }

    protected void setMathElement(int n, MathMLElement mathMLElement) {
        NodeList nodeList = this.getChildNodes();
        while (nodeList.getLength() < n) {
            this.appendChild(this.getOwnerDocument().createTextNode(""));
        }
        if (nodeList.getLength() == n) {
            this.addMathElement(mathMLElement);
        } else {
            this.replaceChild(mathMLElement, nodeList.item(n));
        }
    }

    @Override
    public int getIndexOfMathElement(JEuclidElement jEuclidElement) {
        NodeList nodeList = this.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (!nodeList.item(i).equals(jEuclidElement)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getMathElementCount() {
        List<Node> list = ElementListSupport.createListOfChildren(this);
        int n = 0;
        for (Node node : list) {
            if (!(node instanceof JEuclidElement)) continue;
            ++n;
        }
        return n;
    }

    public String getText() {
        return TextContent.getText(this);
    }

    @Override
    public void setFakeParent(JEuclidElement jEuclidElement) {
        this.fakeParent = jEuclidElement;
    }

    private JEuclidNode getParentAsJEuclidNode() {
        Node node = this.getParentNode();
        JEuclidNode jEuclidNode = node instanceof JEuclidNode ? (JEuclidNode)((Object)node) : null;
        if (jEuclidNode == null) {
            return this.fakeParent;
        }
        return jEuclidNode;
    }

    @Override
    public JEuclidElement getParent() {
        JEuclidNode jEuclidNode = this.getParentAsJEuclidNode();
        if (jEuclidNode instanceof JEuclidElement) {
            return (JEuclidElement)jEuclidNode;
        }
        return null;
    }

    public void setMathvariant(String string) {
        this.setAttribute(ATTR_MATHVARIANT, string);
    }

    public String getMathvariant() {
        return this.getMathAttribute(ATTR_MATHVARIANT);
    }

    public FontMetrics getFontMetrics(Graphics2D graphics2D, LayoutContext layoutContext) {
        return graphics2D.getFontMetrics(this.getFont(layoutContext));
    }

    public void setMathcolor(String string) {
        this.setAttribute(ATTR_MATHCOLOR, string);
    }

    public String getMathcolor() {
        String string = this.getMathAttribute(ATTR_MATHCOLOR);
        if (string == null) {
            string = this.getMathAttribute(ATTR_DEPRECATED_COLOR);
        }
        return string;
    }

    public String getMathsize() {
        String string = this.getMathAttribute(ATTR_MATHSIZE);
        if (string == null) {
            string = this.getMathAttribute(ATTR_DEPRECATED_FONTSIZE);
        }
        return string;
    }

    public void setMathsize(String string) {
        this.setAttribute(ATTR_MATHSIZE, string);
    }

    protected void setDefaultMathAttribute(String string, String string2) {
        this.defaultMathAttributes.put(string, string2);
    }

    protected String getMathAttribute(String string) {
        return this.getMathAttribute(string, true);
    }

    protected String getMathAttribute(String string, boolean bl) {
        Attr attr = this.getAttributeNodeNS(URI, string);
        if (attr == null) {
            attr = this.getAttributeNode(string);
        }
        String string2 = attr == null ? (bl ? this.getDefaultMathAttribute(string) : null) : attr.getValue().trim();
        return string2;
    }

    private String getDefaultMathAttribute(String string) {
        return this.defaultMathAttributes.get(string);
    }

    public String getMathbackground() {
        String string = this.getMathAttribute(ATTR_MATHBACKGROUND);
        if (string == null) {
            string = this.getMathAttribute(ATTR_DEPRECATED_BACKGROUND);
        }
        return string;
    }

    public void setMathbackground(String string) {
        this.setAttribute(ATTR_MATHBACKGROUND, string);
    }

    public float getMiddleShift(Graphics2D graphics2D, LayoutContext layoutContext) {
        return (float)this.getFontMetrics(graphics2D, layoutContext).getAscent() * 0.38f;
    }

    @Override
    public String getClassName() {
        return this.getAttribute(ATTR_CLASS);
    }

    @Override
    public void setClassName(String string) {
        this.setAttribute(ATTR_CLASS, string);
    }

    @Override
    public String getMathElementStyle() {
        return this.getAttribute(ATTR_STYLE);
    }

    @Override
    public void setMathElementStyle(String string) {
        this.setAttribute(ATTR_STYLE, string);
    }

    @Override
    public String getId() {
        return this.getAttribute(ATTR_ID);
    }

    @Override
    public void setId(String string) {
        this.setAttribute(ATTR_ID, string);
    }

    @Override
    public String getXref() {
        return this.getAttribute(ATTR_XREF);
    }

    @Override
    public void setXref(String string) {
        this.setAttribute(ATTR_XREF, string);
    }

    @Override
    public String getHref() {
        return this.getAttribute(ATTR_HREF);
    }

    @Override
    public void setHref(String string) {
        this.setAttribute(ATTR_HREF, string);
    }

    @Override
    public MathMLMathElement getOwnerMathElement() {
        for (JEuclidElement jEuclidElement = this.getParent(); jEuclidElement != null; jEuclidElement = jEuclidElement.getParent()) {
            if (!(jEuclidElement instanceof MathMLMathElement)) continue;
            return (MathMLMathElement)((Object)jEuclidElement);
        }
        return null;
    }

    @Override
    public boolean hasChildPrescripts(JEuclidElement jEuclidElement) {
        return false;
    }

    @Override
    public boolean hasChildPostscripts(JEuclidElement jEuclidElement, LayoutContext layoutContext) {
        return false;
    }

    public MathMLNodeList getContents() {
        return (MathMLNodeList)this.getChildNodes();
    }

    @Override
    public LayoutContext getChildLayoutContext(int n, LayoutContext layoutContext) {
        return this.applyLocalAttributesToContext(layoutContext);
    }

    public LayoutContext applyLocalAttributesToContext(LayoutContext layoutContext) {
        return this.applyStyleAttributes(layoutContext);
    }

    private LayoutContext applyStyleAttributes(LayoutContext layoutContext) {
        LayoutContext layoutContext2 = layoutContext;
        String string = this.getMathsize();
        String string2 = this.getMathcolor();
        Color color = string2 == null ? null : AttributesHelper.stringToColor(string2, Color.BLACK);
        if (string != null || color != null) {
            layoutContext2 = new StyleAttributeLayoutContext(layoutContext, string, color);
        }
        return layoutContext2;
    }

    @Override
    public List<LayoutableNode> getChildrenToLayout() {
        List<LayoutableNode> list = ElementListSupport.createListOfLayoutChildren(this);
        return list;
    }

    @Override
    public List<LayoutableNode> getChildrenToDraw() {
        List<LayoutableNode> list = ElementListSupport.createListOfLayoutChildren(this);
        return list;
    }

    protected void layoutStageInvariant(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        ElementListSupport.layoutSequential(layoutView, layoutInfo, this.getChildrenToLayout(), layoutStage);
    }

    @Override
    public void layoutStage1(LayoutView layoutView, LayoutInfo layoutInfo, LayoutStage layoutStage, LayoutContext layoutContext) {
        this.layoutStageInvariant(layoutView, layoutInfo, LayoutStage.STAGE1, layoutContext);
        if (this.getMathbackground() == null) {
            layoutInfo.setLayoutStage(layoutStage);
        } else {
            layoutInfo.setLayoutStage(LayoutStage.STAGE1);
        }
    }

    @Override
    public void layoutStage2(LayoutView layoutView, LayoutInfo layoutInfo, LayoutContext layoutContext) {
        this.layoutStageInvariant(layoutView, layoutInfo, LayoutStage.STAGE2, layoutContext);
        String string = this.getMathbackground();
        Color color = AttributesHelper.stringToColor(string, null);
        ElementListSupport.addBackground(color, layoutInfo, false);
        layoutInfo.setLayoutStage(LayoutStage.STAGE2);
    }

    protected void changeHook() {
    }

    public boolean dispatchEvent(Event event) {
        if (event instanceof DOMMutationEvent) {
            this.changeHook();
        }
        return super.dispatchEvent(event);
    }

    static {
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_COLOR);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_BACKGROUND);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTSIZE);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTWEIGHT);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTSTYLE);
        DEPRECATED_ATTRIBUTES.add(ATTR_DEPRECATED_FONTFAMILY);
        DEPRECATED_ATTRIBUTES.add("moveablelimits");
    }
}

