/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.jeuclid.elements.JEuclidElement;
import net.sourceforge.jeuclid.elements.content.semantic.Annotation;
import net.sourceforge.jeuclid.elements.content.semantic.Semantics;
import net.sourceforge.jeuclid.elements.generic.ForeignElement;
import net.sourceforge.jeuclid.elements.generic.MathImpl;
import net.sourceforge.jeuclid.elements.presentation.enlivening.Maction;
import net.sourceforge.jeuclid.elements.presentation.general.Menclose;
import net.sourceforge.jeuclid.elements.presentation.general.Merror;
import net.sourceforge.jeuclid.elements.presentation.general.Mfenced;
import net.sourceforge.jeuclid.elements.presentation.general.Mfrac;
import net.sourceforge.jeuclid.elements.presentation.general.Mpadded;
import net.sourceforge.jeuclid.elements.presentation.general.Mphantom;
import net.sourceforge.jeuclid.elements.presentation.general.Mroot;
import net.sourceforge.jeuclid.elements.presentation.general.Mrow;
import net.sourceforge.jeuclid.elements.presentation.general.Msqrt;
import net.sourceforge.jeuclid.elements.presentation.general.Mstyle;
import net.sourceforge.jeuclid.elements.presentation.script.Mmultiscripts;
import net.sourceforge.jeuclid.elements.presentation.script.Mover;
import net.sourceforge.jeuclid.elements.presentation.script.Mprescripts;
import net.sourceforge.jeuclid.elements.presentation.script.Msub;
import net.sourceforge.jeuclid.elements.presentation.script.Msubsup;
import net.sourceforge.jeuclid.elements.presentation.script.Msup;
import net.sourceforge.jeuclid.elements.presentation.script.Munder;
import net.sourceforge.jeuclid.elements.presentation.script.Munderover;
import net.sourceforge.jeuclid.elements.presentation.script.None;
import net.sourceforge.jeuclid.elements.presentation.table.Maligngroup;
import net.sourceforge.jeuclid.elements.presentation.table.Malignmark;
import net.sourceforge.jeuclid.elements.presentation.table.Mlabeledtr;
import net.sourceforge.jeuclid.elements.presentation.table.Mtable;
import net.sourceforge.jeuclid.elements.presentation.table.Mtd;
import net.sourceforge.jeuclid.elements.presentation.table.Mtr;
import net.sourceforge.jeuclid.elements.presentation.token.Mglyph;
import net.sourceforge.jeuclid.elements.presentation.token.Mi;
import net.sourceforge.jeuclid.elements.presentation.token.Mn;
import net.sourceforge.jeuclid.elements.presentation.token.Mo;
import net.sourceforge.jeuclid.elements.presentation.token.Ms;
import net.sourceforge.jeuclid.elements.presentation.token.Mspace;
import net.sourceforge.jeuclid.elements.presentation.token.Mtext;
import org.apache.batik.dom.AbstractDocument;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class JEuclidElementFactory {
    private static final Log LOGGER = LogFactory.getLog(JEuclidElementFactory.class);
    private static final Map<String, Constructor<? extends JEuclidElement>> IMPL_CLASSES = new HashMap<String, Constructor<? extends JEuclidElement>>();

    private JEuclidElementFactory() {
    }

    private static String removeNSPrefix(String string) {
        int n = string.indexOf(58);
        if (n >= 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static Constructor<? extends JEuclidElement> getJEuclidElementConstructor(String string, String string2) {
        String string3 = JEuclidElementFactory.removeNSPrefix(string2);
        if (string == null || string.isEmpty() || "http://www.w3.org/1998/Math/MathML".equals(string)) {
            return IMPL_CLASSES.get(string3);
        }
        return null;
    }

    public static Element elementFromName(String string, String string2, Document document) {
        JEuclidElement jEuclidElement = null;
        Constructor<? extends JEuclidElement> constructor = JEuclidElementFactory.getJEuclidElementConstructor(string, string2);
        if (constructor != null) {
            try {
                jEuclidElement = constructor.newInstance(string2, document);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                jEuclidElement = null;
            }
        }
        if (jEuclidElement == null) {
            jEuclidElement = new ForeignElement(string, string2, (AbstractDocument)document);
        }
        return jEuclidElement;
    }

    private static void addClass(Class<? extends JEuclidElement> clazz) {
        try {
            Field field = clazz.getField("ELEMENT");
            String string = (String)field.get(null);
            IMPL_CLASSES.put(string, clazz.getConstructor(String.class, AbstractDocument.class));
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException reflectiveOperationException) {
            LOGGER.warn((Object)clazz.toString(), (Throwable)reflectiveOperationException);
        }
    }

    static {
        JEuclidElementFactory.addClass(MathImpl.class);
        JEuclidElementFactory.addClass(Mfenced.class);
        JEuclidElementFactory.addClass(Mfrac.class);
        JEuclidElementFactory.addClass(Menclose.class);
        JEuclidElementFactory.addClass(Mphantom.class);
        JEuclidElementFactory.addClass(Msup.class);
        JEuclidElementFactory.addClass(Msub.class);
        JEuclidElementFactory.addClass(Mmultiscripts.class);
        JEuclidElementFactory.addClass(Mprescripts.class);
        JEuclidElementFactory.addClass(None.class);
        JEuclidElementFactory.addClass(Msubsup.class);
        JEuclidElementFactory.addClass(Munder.class);
        JEuclidElementFactory.addClass(Mover.class);
        JEuclidElementFactory.addClass(Munderover.class);
        JEuclidElementFactory.addClass(Mspace.class);
        JEuclidElementFactory.addClass(Ms.class);
        JEuclidElementFactory.addClass(Mstyle.class);
        JEuclidElementFactory.addClass(Msqrt.class);
        JEuclidElementFactory.addClass(Mroot.class);
        JEuclidElementFactory.addClass(Mtable.class);
        JEuclidElementFactory.addClass(Mtr.class);
        JEuclidElementFactory.addClass(Mlabeledtr.class);
        JEuclidElementFactory.addClass(Mtd.class);
        JEuclidElementFactory.addClass(Mo.class);
        JEuclidElementFactory.addClass(Mi.class);
        JEuclidElementFactory.addClass(Mn.class);
        JEuclidElementFactory.addClass(Mtext.class);
        JEuclidElementFactory.addClass(Mrow.class);
        JEuclidElementFactory.addClass(Maligngroup.class);
        JEuclidElementFactory.addClass(Malignmark.class);
        JEuclidElementFactory.addClass(Semantics.class);
        JEuclidElementFactory.addClass(Annotation.class);
        JEuclidElementFactory.addClass(Mpadded.class);
        JEuclidElementFactory.addClass(Merror.class);
        JEuclidElementFactory.addClass(Maction.class);
        JEuclidElementFactory.addClass(Mglyph.class);
    }
}

