/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.presentation.token;

import java.text.AttributedCharacterIterator;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.presentation.token.AbstractTokenWithTextLayout;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import net.sourceforge.jeuclid.elements.support.attributes.MathVariant;
import net.sourceforge.jeuclid.elements.support.text.MultiAttributedCharacterIterator;
import net.sourceforge.jeuclid.elements.support.text.StringUtil;
import net.sourceforge.jeuclid.elements.support.text.TextContentModifier;
import org.apache.batik.dom.AbstractDocument;
import org.w3c.dom.Node;
import org.w3c.dom.mathml.MathMLStringLitElement;

public final class Ms
extends AbstractTokenWithTextLayout
implements MathMLStringLitElement,
TextContentModifier {
    public static final String ELEMENT = "ms";
    public static final String ATTR_LQUOTE = "lquote";
    public static final String ATTR_RQUOTE = "rquote";
    private static final String VALUE_DOUBLEQUOTE = "\"";
    private static final long serialVersionUID = 1L;

    public Ms(String string, AbstractDocument abstractDocument) {
        super(string, abstractDocument);
        this.setDefaultMathAttribute(ATTR_LQUOTE, VALUE_DOUBLEQUOTE);
        this.setDefaultMathAttribute(ATTR_RQUOTE, VALUE_DOUBLEQUOTE);
    }

    protected Node newNode() {
        return new Ms(this.nodeName, this.ownerDocument);
    }

    @Override
    public void setLquote(String string) {
        this.setAttribute(ATTR_LQUOTE, string);
    }

    @Override
    public String getLquote() {
        return this.getMathAttribute(ATTR_LQUOTE);
    }

    @Override
    public void setRquote(String string) {
        this.setAttribute(ATTR_RQUOTE, string);
    }

    @Override
    public String getRquote() {
        return this.getMathAttribute(ATTR_RQUOTE);
    }

    @Override
    public AttributedCharacterIterator modifyTextContent(AttributedCharacterIterator attributedCharacterIterator, LayoutContext layoutContext) {
        float f = GraphicsSupport.getFontsizeInPoint(layoutContext);
        MathVariant mathVariant = this.getMathvariantAsVariant();
        MultiAttributedCharacterIterator multiAttributedCharacterIterator = new MultiAttributedCharacterIterator();
        multiAttributedCharacterIterator.appendAttributedCharacterIterator(StringUtil.convertStringtoAttributedString(this.getLquote(), mathVariant, f, layoutContext).getIterator());
        multiAttributedCharacterIterator.appendAttributedCharacterIterator(attributedCharacterIterator);
        multiAttributedCharacterIterator.appendAttributedCharacterIterator(StringUtil.convertStringtoAttributedString(this.getRquote(), mathVariant, f, layoutContext).getIterator());
        return multiAttributedCharacterIterator;
    }
}

