/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.attributes;

import java.awt.Color;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.jeuclid.LayoutContext;
import net.sourceforge.jeuclid.elements.support.GraphicsSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class AttributesHelper {
    public static final String COLOR_TRANSPARENT = "transparent";
    public static final String VERYVERYTHINMATHSPACE = "0.0555556em";
    public static final String VERYTHINMATHSPACE = "0.111111em";
    public static final String THINMATHSPACE = "0.166667em";
    public static final String MEDIUMMATHSPACE = "0.222222em";
    public static final String THICKMATHSPACE = "0.277778em";
    public static final String VERYTHICKMATHSPACE = "0.333333em";
    public static final String VERYVERYTHICKMATHSPACE = "0.388889em";
    public static final String PT = "pt";
    public static final String INFINITY = "9999999pt";
    private static final String ERROR_PARSING_NUMBER = "Error Parsing number: ";
    private static final int HASHSHORT_ALPHA = 5;
    private static final int HASHSHORT_NO_ALPHA = 4;
    private static final int SHORT_INDEX_RED = 1;
    private static final int SHORT_INDEX_GREEN = 2;
    private static final int SHORT_INDEX_BLUE = 3;
    private static final int HASHLEN_ALPHA = 9;
    private static final int HASHLEN_NO_ALPHA = 7;
    private static final int HEXBASE = 16;
    private static final float MAX_HEXCHAR_AS_FLOAT = 15.0f;
    private static final int MAX_BYTE = 255;
    private static final float MAX_PERCENT_AS_FLOAT = 100.0f;
    private static final float MAX_BYTE_AS_FLOAT = 255.0f;
    private static final String PERCENT_SIGN = "%";
    private static final String COMMA = ",";
    private static final float EM = 0.8388889f;
    private static final float EX = 0.5f;
    private static final float DPI = 72.0f;
    private static final float PERCENT = 0.01f;
    private static final float CM_PER_INCH = 2.54f;
    private static final float MM_PER_INCH = 25.4f;
    private static final float PT_PER_PC = 12.0f;
    private static final Map<String, String> SIZETRANSLATIONS = new HashMap<String, String>();
    private static final Map<String, Float> RELATIVE_UNITS = new HashMap<String, Float>();
    private static final Map<String, Float> ABSOLUTE_UNITS = new HashMap<String, Float>();
    private static final Map<String, Color> COLOR_MAPPINGS = new HashMap<String, Color>();
    private static final Log LOGGER = LogFactory.getLog(AttributesHelper.class);

    private AttributesHelper() {
    }

    public static float parseRelativeSize(String string, LayoutContext layoutContext, float f) {
        float f2;
        if (string == null) {
            return f;
        }
        String string2 = AttributesHelper.prepareSizeString(string);
        try {
            if (string2.length() >= 2) {
                int n = string2.length() - 2;
                String string3 = string2.substring(n);
                float f3 = Float.parseFloat(string2.substring(0, n));
                f2 = ABSOLUTE_UNITS.containsKey(string3) ? AttributesHelper.convertSizeToPt(string, layoutContext, PT) : (RELATIVE_UNITS.containsKey(string3) ? f3 * f * RELATIVE_UNITS.get(string3).floatValue() : Float.parseFloat(string2) * f);
            } else {
                f2 = Float.parseFloat(string2) * f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            f2 = f;
            LOGGER.warn((Object)(ERROR_PARSING_NUMBER + string));
        }
        return f2;
    }

    public static float convertSizeToPt(String string, LayoutContext layoutContext, String string2) {
        float f;
        String string3 = AttributesHelper.prepareSizeString(string);
        if (string3.isEmpty()) {
            return 0.0f;
        }
        try {
            float f2;
            String string4;
            if (string3.length() <= 2) {
                string4 = string2;
                f2 = Float.parseFloat(string3);
            } else {
                int n = string3.length() - 2;
                string4 = string3.substring(n);
                f2 = Float.parseFloat(string3.substring(0, n));
            }
            if (f2 == 0.0f) {
                f = 0.0f;
            } else if (RELATIVE_UNITS.containsKey(string4)) {
                f = f2 * GraphicsSupport.getFontsizeInPoint(layoutContext) * RELATIVE_UNITS.get(string4).floatValue();
            } else if (ABSOLUTE_UNITS.containsKey(string4)) {
                f = f2 * ABSOLUTE_UNITS.get(string4).floatValue();
            } else if (!string2.isEmpty()) {
                f = AttributesHelper.convertSizeToPt(string + string2, layoutContext, "");
            } else {
                f = Float.parseFloat(string3);
                LOGGER.warn((Object)("Error Parsing attribute: " + string + " assuming " + f + PT));
            }
        }
        catch (NumberFormatException numberFormatException) {
            f = 1.0f;
            LOGGER.warn((Object)(ERROR_PARSING_NUMBER + string + " falling back to " + f + PT));
        }
        return f;
    }

    private static String prepareSizeString(String string) {
        if (string == null) {
            return "";
        }
        String string2 = string.trim().toLowerCase(Locale.ENGLISH);
        String string3 = SIZETRANSLATIONS.get(string2);
        if (string3 != null) {
            string2 = string3;
        }
        if (string2.endsWith(PERCENT_SIGN)) {
            string2 = string2 + ' ';
        }
        return string2;
    }

    public static Color stringToColor(String string, Color color) {
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase(Locale.ENGLISH);
        Color color2 = null;
        if (COLOR_MAPPINGS.containsKey(string2)) {
            color2 = COLOR_MAPPINGS.get(string2);
        } else {
            if (string.charAt(0) == '#') {
                color2 = AttributesHelper.parseWithHash(string);
            } else if (string.startsWith("rgb(")) {
                color2 = AttributesHelper.parseAsRGB(string);
            } else if (string.startsWith("java.awt.Color")) {
                color2 = AttributesHelper.parseAsJavaAWTColor(string);
            }
            if (color2 == null) {
                color2 = color;
            }
            if (color2 != null) {
                COLOR_MAPPINGS.put(string, color2);
            }
        }
        return color2;
    }

    private static Color parseAsJavaAWTColor(String string) {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        Color color = n == -1 || n2 == -1 ? null : AttributesHelper.parseCommaSeparatedString(string.substring(n + 1, n2));
        return color;
    }

    private static Color parseAsRGB(String string) {
        int n = string.indexOf(40);
        int n2 = string.indexOf(41);
        Color color = n == -1 || n2 == -1 ? null : AttributesHelper.parseCommaSeparatedString(string.substring(n + 1, n2));
        return color;
    }

    private static Color parseCommaSeparatedString(String string) {
        Color color;
        StringTokenizer stringTokenizer = new StringTokenizer(string, COMMA);
        try {
            String string2;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                f = AttributesHelper.parseFloatOrPercent(string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                f2 = AttributesHelper.parseFloatOrPercent(string2);
            }
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken().trim();
                f3 = AttributesHelper.parseFloatOrPercent(string2);
            }
            color = new Color(f, f2, f3);
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn((Object)numberFormatException);
            color = null;
        }
        return color;
    }

    private static float parseFloatOrPercent(String string) {
        float f = string.endsWith(PERCENT_SIGN) ? Float.parseFloat(string.substring(0, string.length() - 1)) / 100.0f : Float.parseFloat(string) / 255.0f;
        if (f < 0.0f || f > 1.0f) {
            throw new NumberFormatException(string + " is out of Range");
        }
        return f;
    }

    private static Color parseWithHash(String string) {
        Color color;
        block6: {
            color = null;
            try {
                int n = string.length();
                if (n >= 4 && n <= 5) {
                    float f = (float)Integer.parseInt(string.substring(1, 2), 16) / 15.0f;
                    float f2 = (float)Integer.parseInt(string.substring(2, 3), 16) / 15.0f;
                    float f3 = (float)Integer.parseInt(string.substring(3, 4), 16) / 15.0f;
                    float f4 = 1.0f;
                    if (n == 5) {
                        f4 = (float)Integer.parseInt(string.substring(4), 16) / 15.0f;
                    }
                    color = new Color(f, f2, f3, f4);
                    break block6;
                }
                if (n == 7 || n == 9) {
                    int n2 = Integer.parseInt(string.substring(1, 3), 16);
                    int n3 = Integer.parseInt(string.substring(3, 5), 16);
                    int n4 = Integer.parseInt(string.substring(5, 7), 16);
                    int n5 = 255;
                    if (n == 9) {
                        n5 = Integer.parseInt(string.substring(7), 16);
                    }
                    color = new Color(n2, n3, n4, n5);
                    break block6;
                }
                throw new NumberFormatException();
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return color;
    }

    public static String colorTOsRGBString(Color color) {
        if (color == null) {
            return COLOR_TRANSPARENT;
        }
        StringBuilder stringBuilder = new StringBuilder(10);
        stringBuilder.append('#');
        String string = Integer.toHexString(color.getRed());
        if (string.length() == 1) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        string = Integer.toHexString(color.getGreen());
        if (string.length() == 1) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        string = Integer.toHexString(color.getBlue());
        if (string.length() == 1) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        if (color.getAlpha() != 255) {
            string = Integer.toHexString(color.getAlpha());
            if (string.length() == 1) {
                stringBuilder.append('0');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    static {
        SIZETRANSLATIONS.put("veryverythinmathspace", VERYVERYTHINMATHSPACE);
        SIZETRANSLATIONS.put("verythinmathspace", VERYTHINMATHSPACE);
        SIZETRANSLATIONS.put("thinmathspace", THINMATHSPACE);
        SIZETRANSLATIONS.put("mediummathspace", MEDIUMMATHSPACE);
        SIZETRANSLATIONS.put("thickmathspace", THICKMATHSPACE);
        SIZETRANSLATIONS.put("verythickmathspace", VERYTHICKMATHSPACE);
        SIZETRANSLATIONS.put("veryverythickmathspace", VERYVERYTHICKMATHSPACE);
        SIZETRANSLATIONS.put("infinity", INFINITY);
        SIZETRANSLATIONS.put("small", "68%");
        SIZETRANSLATIONS.put("normal", "100%");
        SIZETRANSLATIONS.put("big", "147%");
        SIZETRANSLATIONS.put("thin", "0.5");
        SIZETRANSLATIONS.put("medium", "1");
        SIZETRANSLATIONS.put("thick", "2");
        SIZETRANSLATIONS.put("null", "0");
        RELATIVE_UNITS.put("em", Float.valueOf(0.8388889f));
        RELATIVE_UNITS.put("ex", Float.valueOf(0.5f));
        RELATIVE_UNITS.put("% ", Float.valueOf(0.01f));
        ABSOLUTE_UNITS.put("px", Float.valueOf(1.0f));
        ABSOLUTE_UNITS.put("in", Float.valueOf(72.0f));
        ABSOLUTE_UNITS.put("cm", Float.valueOf(28.346457f));
        ABSOLUTE_UNITS.put("mm", Float.valueOf(2.8346457f));
        ABSOLUTE_UNITS.put(PT, Float.valueOf(1.0f));
        ABSOLUTE_UNITS.put("pc", Float.valueOf(12.0f));
        COLOR_MAPPINGS.put("aqua", new Color(0, 255, 255));
        COLOR_MAPPINGS.put("black", Color.BLACK);
        COLOR_MAPPINGS.put("blue", Color.BLUE);
        COLOR_MAPPINGS.put("fuchsia", new Color(255, 0, 255));
        COLOR_MAPPINGS.put("gray", Color.GRAY);
        COLOR_MAPPINGS.put("green", Color.GREEN);
        COLOR_MAPPINGS.put("lime", new Color(0, 255, 0));
        COLOR_MAPPINGS.put("maroon", new Color(128, 0, 0));
        COLOR_MAPPINGS.put("navy", new Color(0, 0, 128));
        COLOR_MAPPINGS.put("olive", new Color(128, 128, 0));
        COLOR_MAPPINGS.put("purple", new Color(128, 0, 128));
        COLOR_MAPPINGS.put("red", Color.RED);
        COLOR_MAPPINGS.put("silver", new Color(192, 192, 192));
        COLOR_MAPPINGS.put("teal", new Color(0, 128, 128));
        COLOR_MAPPINGS.put("white", Color.WHITE);
        COLOR_MAPPINGS.put("yellow", Color.YELLOW);
        COLOR_MAPPINGS.put(COLOR_TRANSPARENT, null);
        COLOR_MAPPINGS.put("null", null);
        COLOR_MAPPINGS.put("", null);
    }
}

