/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.elements.support.operatordict;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sourceforge.jeuclid.elements.support.NamespaceContextAdder;
import net.sourceforge.jeuclid.elements.support.operatordict.AbstractOperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorAttribute;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorDictionary;
import net.sourceforge.jeuclid.elements.support.operatordict.OperatorForm;
import net.sourceforge.jeuclid.elements.support.operatordict.UnknownAttributeException;
import net.sourceforge.jeuclid.parser.Parser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class OperatorDictionary3
extends AbstractOperatorDictionary
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(OperatorDictionary3.class);
    private static final String NO_SPACE = "0em";
    private static final int INT_NO_SPACE = 0;
    private static final int INT_VERYVERYTHINMATHSPACE = 1;
    private static final int INT_VERYTHINMATHSPACE = 2;
    private static final int INT_THINMATHSPACE = 3;
    private static final int INT_MEDIUMMATHSPACE = 4;
    private static final int INT_THICKMATHSPACE = 5;
    private static final int INT_VERYTHICKMATHSPACE = 6;
    private static final int INT_VERYVERYTHICKMATHSPACE = 7;
    private static final long serialVersionUID = 1L;
    private static final String DICTIONARY_FILE = "/net/sourceforge/jeuclid/appendixc.xml";
    private static final String DICTIONARY_SERIALIZED = "/net/sourceforge/jeuclid/appendixc.ser";
    private static OperatorDictionary instance;

    private OperatorDictionary3() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OperatorDictionary getInstance() {
        Class<OperatorDictionary3> clazz = OperatorDictionary3.class;
        synchronized (OperatorDictionary3.class) {
            if (instance == null) {
                OperatorDictionary operatorDictionary = AbstractOperatorDictionary.deserialize(DICTIONARY_SERIALIZED);
                instance = operatorDictionary == null ? new OperatorDictionary3() : operatorDictionary;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    protected void initializeFromXML(Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) {
        try {
            Document document = this.loadDocument();
            XPath xPath = this.createXPath();
            this.extractValuesFromDocument(document, xPath, map);
        }
        catch (SAXException sAXException) {
            LOGGER.warn((Object)"XML Could not be parsed in operator dictionary", (Throwable)sAXException);
        }
        catch (IOException iOException) {
            LOGGER.warn((Object)"IO error reading operator dictionary", (Throwable)iOException);
        }
        catch (XPathExpressionException xPathExpressionException) {
            LOGGER.warn((Object)"XPath error in operator dictionary", (Throwable)xPathExpressionException);
        }
    }

    private void extractValuesFromDocument(Document document, XPath xPath, Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) throws XPathExpressionException {
        XPathExpression xPathExpression = xPath.compile("//html:table[@class='sortable']/html:tbody/html:tr");
        XPathExpression xPathExpression2 = xPath.compile("html:th[2]/text()");
        XPathExpression xPathExpression3 = xPath.compile("html:th[4]/text()");
        XPathExpression xPathExpression4 = xPath.compile("html:td[2]/text()");
        XPathExpression xPathExpression5 = xPath.compile("html:td[3]/text()");
        XPathExpression xPathExpression6 = xPath.compile("html:td[4]/text()");
        XPathExpression xPathExpression7 = xPath.compile("html:td[5]/text()");
        NodeList nodeList = (NodeList)xPathExpression.evaluate(document, XPathConstants.NODESET);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            String string = (String)xPathExpression2.evaluate(node, XPathConstants.STRING);
            String string2 = (String)xPathExpression3.evaluate(node, XPathConstants.STRING);
            OperatorForm operatorForm = OperatorForm.parseOperatorForm(string2);
            String string3 = (String)xPathExpression4.evaluate(node, XPathConstants.STRING);
            String string4 = (String)xPathExpression5.evaluate(node, XPathConstants.STRING);
            String string5 = (String)xPathExpression6.evaluate(node, XPathConstants.STRING);
            String string6 = (String)xPathExpression7.evaluate(node, XPathConstants.STRING);
            this.addAttr(string, operatorForm, OperatorAttribute.LSPACE, this.intToSpace(string3), map);
            this.addAttr(string, operatorForm, OperatorAttribute.RSPACE, this.intToSpace(string4), map);
            if (!string5.isEmpty()) {
                this.addAttr(string, operatorForm, OperatorAttribute.MINSIZE, string5, map);
            }
            this.addProperties(string, operatorForm, string6, map);
        }
    }

    private Document loadDocument() throws SAXException, IOException {
        InputStream inputStream = OperatorDictionary3.class.getResourceAsStream(DICTIONARY_FILE);
        Document document = Parser.getInstance().getDocumentBuilder().parse(inputStream);
        return document;
    }

    private XPath createXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        NamespaceContextAdder namespaceContextAdder = new NamespaceContextAdder("xml", "http://www.w3.org/XML/1998/namespace", null);
        NamespaceContextAdder namespaceContextAdder2 = new NamespaceContextAdder("html", "http://www.w3.org/1999/xhtml", namespaceContextAdder);
        xPath.setNamespaceContext(namespaceContextAdder2);
        return xPath;
    }

    private void addProperties(String string, OperatorForm operatorForm, String string2, Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) {
        String[] stringArray;
        for (String string3 : stringArray = string2.split(" ")) {
            if (string3.isEmpty()) continue;
            try {
                OperatorAttribute operatorAttribute = OperatorAttribute.parseOperatorAttribute(string3);
                this.addAttr(string, operatorForm, operatorAttribute, "true", map);
            }
            catch (UnknownAttributeException unknownAttributeException) {
                LOGGER.warn((Object)("Unkown Attribute when reading operator dictionary: " + string3), (Throwable)unknownAttributeException);
            }
        }
    }

    private void addAttr(String string2, OperatorForm operatorForm, OperatorAttribute operatorAttribute2, String string3, Map<OperatorAttribute, Map<String, Map<OperatorForm, String>>> map) {
        Map map2 = map.computeIfAbsent(operatorAttribute2, operatorAttribute -> new HashMap());
        Map map3 = map2.computeIfAbsent(string2, string -> new EnumMap(OperatorForm.class));
        map3.put(operatorForm, string3);
    }

    private String intToSpace(String string) {
        String string2;
        try {
            int n = Integer.parseInt(string);
            switch (n) {
                case 0: {
                    string2 = NO_SPACE;
                    break;
                }
                case 1: {
                    string2 = "veryverythinmathspace";
                    break;
                }
                case 2: {
                    string2 = "verythinmathspace";
                    break;
                }
                case 3: {
                    string2 = "thinmathspace";
                    break;
                }
                case 4: {
                    string2 = "mediummathspace";
                    break;
                }
                case 5: {
                    string2 = "thickmathspace";
                    break;
                }
                case 6: {
                    string2 = "verythickmathspace";
                    break;
                }
                case 7: {
                    string2 = "veryverythickmathspace";
                    break;
                }
                default: {
                    string2 = NO_SPACE;
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = NO_SPACE;
        }
        return string2;
    }

    private static class PersonalNamespaceContext
    implements NamespaceContext {
        @Override
        public String getNamespaceURI(String string) {
            String string2 = "html".equals(string) ? "http://www.w3.org/1999/xhtml" : ("xml".equals(string) ? "http://www.w3.org/XML/1998/namespace" : "");
            return string2;
        }

        @Override
        public String getPrefix(String string) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<String> getPrefixes(String string) {
            throw new UnsupportedOperationException();
        }
    }
}

