/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jeuclid.layout;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import net.sourceforge.jeuclid.layout.GraphicsObject;

public class Path2DShapeObject
implements GraphicsObject {
    private final Path2D path2D;
    private final float width;
    private final Color col;
    private final boolean dash;
    private final EdgeStyle edgeStyle;

    public Path2DShapeObject(Path2D path2D, float f, Color color, boolean bl, EdgeStyle edgeStyle) {
        this.path2D = path2D;
        this.width = f;
        this.col = color;
        this.dash = bl;
        this.edgeStyle = edgeStyle;
    }

    @Override
    public void paint(float f, float f2, Graphics2D graphics2D) {
        graphics2D.setColor(this.col);
        Stroke stroke = graphics2D.getStroke();
        int n = 2;
        int n2 = 0;
        switch (this.edgeStyle) {
            case Round: {
                n = 1;
                n2 = 1;
                break;
            }
        }
        if (this.dash) {
            float f3 = 3.0f * this.width;
            graphics2D.setStroke(new BasicStroke(this.width, n, n2, this.width, new float[]{f3, f3}, 0.0f));
        } else {
            graphics2D.setStroke(new BasicStroke(this.width, n, n2));
        }
        AffineTransform affineTransform = graphics2D.getTransform();
        graphics2D.translate(f, f2);
        graphics2D.draw(this.path2D);
        graphics2D.setTransform(affineTransform);
        graphics2D.setStroke(stroke);
    }

    public static enum EdgeStyle {
        Miter,
        Round;

    }
}

