/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.spi;

import java.math.BigDecimal;

public final class Rectangle {
    private final BigDecimal width;
    private final BigDecimal height;

    public Rectangle(String width, String height) {
        this(new BigDecimal(width), new BigDecimal(height));
    }

    public Rectangle(BigDecimal width, BigDecimal height) {
        if (width == null || height == null) {
            throw new NullPointerException("Neither width or height can be null");
        }
        this.width = width;
        this.height = height;
    }

    public BigDecimal getWidth() {
        return this.width;
    }

    public BigDecimal getHeight() {
        return this.height;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.height == null ? 0 : this.height.intValue());
        result = 31 * result + (this.width == null ? 0 : this.width.intValue());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Rectangle other = (Rectangle)obj;
        if (this.height == null ? other.height != null : this.height.compareTo(other.height) != 0) {
            return false;
        }
        if (this.width == null) {
            return other.width == null;
        }
        return this.width.compareTo(other.width) == 0;
    }
}

