/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.math;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.brailleblaster.math.MathOption;
import org.brailleblaster.math.mathml.MathModuleUtils;
import org.brailleblaster.perspectives.mvc.modules.views.DebugModule;
import org.brailleblaster.util.ImageHelper;
import org.brailleblaster.utils.localization.LocaleHandler;
import org.brailleblaster.utils.swt.EasySWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/brailleblaster/math/AboutMathDialog;", "", "<init>", "()V", "createDialog", "", "parent", "Lorg/eclipse/swt/widgets/Shell;", "addResizeListener", "control", "Lorg/eclipse/swt/widgets/Control;", "sc", "Lorg/eclipse/swt/custom/ScrolledComposite;", "comp", "Lorg/eclipse/swt/widgets/Composite;", "localeHandler", "Lorg/brailleblaster/utils/localization/LocaleHandler;", "getImage", "Lorg/eclipse/swt/graphics/Image;", "imgName", "", "wrapText", "s", "charsPerLine", "", "brailleblaster-math-tools"})
@SourceDebugExtension(value={"SMAP\nAboutMathDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AboutMathDialog.kt\norg/brailleblaster/math/AboutMathDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,118:1\n742#2,9:119\n37#3,2:128\n*S KotlinDebug\n*F\n+ 1 AboutMathDialog.kt\norg/brailleblaster/math/AboutMathDialog\n*L\n107#1:119,9\n107#1:128,2\n*E\n"})
public final class AboutMathDialog {
    @NotNull
    public static final AboutMathDialog INSTANCE = new AboutMathDialog();
    @NotNull
    private static final LocaleHandler localeHandler = LocaleHandler.Companion.getDefault$default((LocaleHandler.Companion)LocaleHandler.Companion, null, (int)1, null);

    private AboutMathDialog() {
    }

    public final void createDialog(@Nullable Shell parent) {
        Shell shell = new Shell(parent, 2160);
        shell.setData((Object)new GridData(4, 4, true, true));
        shell.setLayout((Layout)new GridLayout(1, false));
        shell.setText(MathModuleUtils.MATH_HELP);
        Composite outer = new Composite((Composite)shell, 0);
        outer.setLayout((Layout)new GridLayout(1, false));
        outer.setLayoutData((Object)new GridData(4, 4, true, true));
        ScrolledComposite sc = new ScrolledComposite(outer, 2816);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite comp = new Composite((Composite)sc, 0);
        comp.setLayoutData((Object)new GridData(4, 4, true, true));
        comp.setLayout((Layout)new GridLayout(3, false));
        boolean debug = DebugModule.enabled;
        for (MathOption item : MathOption.getEntries()) {
            if (!debug && !item.getEnabled()) continue;
            Text text = new Text(comp, 0);
            text.setData((Object)new GridData());
            text.setText(item.getPrettyString());
            Label imageLabel = new Label(comp, 0);
            imageLabel.setData((Object)new GridData());
            Image i = this.getImage(item.getKey());
            if (i == null) {
                imageLabel.setText(item.getPrettyString());
            } else {
                imageLabel.setImage(i);
            }
            String description = localeHandler.get("mhelp." + item.getKey());
            StyledText textLabel = new StyledText(comp, 0);
            textLabel.setData((Object)new GridData());
            textLabel.setText(this.wrapText(description, 80));
            textLabel.setEditable(false);
        }
        this.addResizeListener((Control)shell, sc, comp);
        EasySWT.INSTANCE.addEscapeCloseListener(shell);
        sc.setContent((Control)comp);
        shell.pack();
        shell.layout(true);
        shell.open();
    }

    private final void addResizeListener(Control control, ScrolledComposite sc, Composite comp) {
        control.addControlListener(new ControlListener(comp, sc){
            final /* synthetic */ Composite $comp;
            final /* synthetic */ ScrolledComposite $sc;
            {
                this.$comp = $comp;
                this.$sc = $sc;
            }

            public void controlMoved(ControlEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            public void controlResized(ControlEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$comp.layout();
                this.$sc.setMinSize(this.$comp.computeSize(-1, -1));
            }
        });
    }

    private final Image getImage(String imgName) {
        Path imagePath = ImageHelper.INSTANCE.getImagesPath();
        String fileName = "toolbar/large/" + imgName + ".png";
        Path path = imagePath.resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        return !Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? null : ImageHelper.createScaledImage$default((ImageHelper)ImageHelper.INSTANCE, (String)fileName, (float)1.0f, null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String wrapText(String s, int charsPerLine) {
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        StringBuilder s2 = new StringBuilder();
        int curChars = 0;
        Object object = s;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] array = thisCollection$iv.toArray(new String[0]);
        int n2 = array.length;
        for (int i = 0; i < n2; ++i) {
            if (curChars > charsPerLine) {
                s2.append("\n");
                curChars = 0;
            }
            s2.append(array[i]).append(" ");
            curChars += array[i].length();
        }
        String string = s2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

