/*
 * Decompiled with CFR 0.152.
 */
package org.mwhapples.jlouis;

import jakarta.annotation.Nonnull;
import java.util.Arrays;

public class TranslationResult {
    private final String translation;
    private final int[] inputPos;
    private final int[] outputPos;
    private final int cursorPos;

    TranslationResult(@Nonnull String translation, int[] outputPos, @Nonnull int[] inputPos, int cursorPos) {
        if (translation.length() > inputPos.length) {
            throw new IllegalArgumentException("The inputPos is too short, it should be at least as long as the translation string");
        }
        this.translation = translation;
        this.inputPos = Arrays.copyOf(inputPos, translation.length());
        this.outputPos = outputPos;
        this.cursorPos = cursorPos;
    }

    @Nonnull
    public String getTranslation() {
        return this.translation;
    }

    @Nonnull
    public int[] getInputPos() {
        return this.inputPos;
    }

    public int[] getOutputPos() {
        return this.outputPos;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }
}

