/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.drivers.viewplus;

import com.google.common.base.Preconditions;
import java.awt.Font;
import java.util.Map;
import java.util.stream.Stream;
import org.brailleblaster.libembosser.drivers.utils.BaseGraphicsEmbosser;
import org.brailleblaster.libembosser.drivers.utils.DefaultNotificationImpl;
import org.brailleblaster.libembosser.drivers.utils.DocumentToPrintableHandler;
import org.brailleblaster.libembosser.drivers.viewplus.ViewPlusLayoutHelper;
import org.brailleblaster.libembosser.spi.BrlCell;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.brailleblaster.libembosser.spi.Notification;
import org.brailleblaster.libembosser.spi.Rectangle;

public class ViewPlusEmbosser
extends BaseGraphicsEmbosser {
    private final Rectangle minPaper;
    private final Rectangle maxPaper;
    private final boolean duplex;

    public ViewPlusEmbosser(String id, String model, Rectangle minPaper, Rectangle maxPaper, boolean duplex) {
        this(id, "ViewPlus Technologies", model, minPaper, maxPaper, duplex);
    }

    public ViewPlusEmbosser(String id, String manufacturer, String model, Rectangle minPaper, Rectangle maxPaper, boolean duplex) {
        super(id, manufacturer, model);
        this.minPaper = (Rectangle)Preconditions.checkNotNull((Object)minPaper);
        this.maxPaper = (Rectangle)Preconditions.checkNotNull((Object)maxPaper);
        this.duplex = duplex;
    }

    public Rectangle getMaximumPaper() {
        return this.maxPaper;
    }

    public Rectangle getMinimumPaper() {
        return this.minPaper;
    }

    public boolean supportsInterpoint() {
        return this.duplex;
    }

    public DocumentToPrintableHandler.LayoutHelper getLayoutHelper(BrlCell cell) {
        return new ViewPlusLayoutHelper();
    }

    public Stream<Notification> checkPrerequisites() {
        return this.checkFontInstalled() ? Stream.of(new DefaultNotificationImpl(Notification.NotificationType.WARNING, "org.brailleblaster.libembosser.drivers.i18n.ViewPlus", "NoFont")) : Stream.empty();
    }

    public Stream<Notification> checkEmboss(int cellsPerLine, int linesPerPage, EmbossingAttributeSet attributes) {
        return this.checkFontInstalled() ? Stream.of(new DefaultNotificationImpl(Notification.NotificationType.WARNING, "org.brailleblaster.libembosser.drivers.i18n.ViewPlus", "NoFont")) : Stream.empty();
    }

    private boolean checkFontInstalled() {
        Map attrs = this.getLayoutHelper(BrlCell.NLS).getBrailleAttributes(BrlCell.NLS);
        Font font = Font.getFont(attrs);
        return !font.getName().equals("Braille29");
    }
}

