/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.libembosser.utils;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.w3c.dom.Element;

public enum PEFElementType {
    PEF("http://www.daisy.org/ns/2008/pef", "pef", (List<Predicate<Element>>)ImmutableList.of(e -> "2008-1".equals(e.getAttribute("version")))),
    HEAD("http://www.daisy.org/ns/2008/pef", "head"),
    META("http://www.daisy.org/ns/2008/pef", "meta"),
    DC_FORMAT("http://purl.org/dc/elements/1.1/", "format", (List<Predicate<Element>>)ImmutableList.of(e -> "application/x-pef+xml".equals(e.getTextContent()))),
    DC_IDENTIFIER("http://purl.org/dc/elements/1.1/", "identifier"),
    BODY("http://www.daisy.org/ns/2008/pef", "body"),
    GRAPHIC("http://www.aph.org/ns/tactile-graphics/1.0", "graphic"),
    VOLUME("http://www.daisy.org/ns/2008/pef", "volume"),
    SECTION("http://www.daisy.org/ns/2008/pef", "section"),
    PAGE("http://www.daisy.org/ns/2008/pef", "page"),
    ROW("http://www.daisy.org/ns/2008/pef", "row");

    private String ns;
    private String elemName;
    private List<Predicate<Element>> additionalChecks;

    private PEFElementType(String ns, String elemName) {
        this(ns, elemName, (List<Predicate<Element>>)ImmutableList.of());
    }

    private PEFElementType(String ns, String elemName, List<Predicate<Element>> additionalChecks) {
        this.ns = ns;
        this.elemName = elemName;
        this.additionalChecks = additionalChecks;
    }

    public String getNamespaceUri() {
        return this.ns;
    }

    public String getElementName() {
        return this.elemName;
    }

    public static Optional<PEFElementType> findElementType(Element element) {
        return Arrays.stream(PEFElementType.values()).filter(t -> t.ns.equals(element.getNamespaceURI()) && t.elemName.equals(element.getLocalName()) && t.additionalChecks.stream().allMatch(c -> c.test(element))).findFirst();
    }
}

