/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster;

import java.io.Closeable;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import onl.mdw.mathcat4j.api.MathCat;
import org.brailleblaster.BBBootstrap;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.ZipHandles;
import org.brailleblaster.firstrun.FirstRunWizardKt;
import org.brailleblaster.logging.LogUtils;
import org.brailleblaster.usage.BBUsageManager;
import org.brailleblaster.usage.UsageLogger;
import org.brailleblaster.usage.UsageLoggerKt;
import org.brailleblaster.usage.UsageManagerKt;
import org.brailleblaster.usage.UsageRecord;
import org.brailleblaster.userHelp.Project;
import org.brailleblaster.util.Notify;
import org.brailleblaster.util.NotifyUtils;
import org.brailleblaster.util.SoundManager;
import org.brailleblaster.util.WorkingDialog;
import org.brailleblaster.utils.BBData;
import org.brailleblaster.utils.PropertyFileManager;
import org.brailleblaster.utils.braille.MathCATUtilsKt;
import org.brailleblaster.wordprocessor.WPManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007\u00a2\u0006\u0002\u0010\rJ\u0019\u0010\u000e\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ \u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"Lorg/brailleblaster/Main;", "", "<init>", "()V", "value", "", "isInitted", "()Z", "main", "", "args", "", "", "([Ljava/lang/String;)V", "start", "initBB", "argsToParse", "", "initBBIni", "handleFatalException", "t", "", "deleteExceptionFiles", "dumpClassLoader", "curClassLoader", "Ljava/lang/ClassLoader;", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nMain.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Main.kt\norg/brailleblaster/Main\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,225:1\n14060#2,2:226\n*S KotlinDebug\n*F\n+ 1 Main.kt\norg/brailleblaster/Main\n*L\n200#1:226,2\n*E\n"})
public final class Main {
    @NotNull
    public static final Main INSTANCE = new Main();
    private static boolean isInitted;

    private Main() {
    }

    public final boolean isInitted() {
        return isInitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        try {
            INSTANCE.start(args);
        }
        catch (Throwable e) {
            Main.handleFatalException(e);
        }
        finally {
            ZipHandles.INSTANCE.closeAll();
        }
        System.exit(0);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull String[] args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        List argsToParse = ArraysKt.toMutableList((Object[])args);
        Main.initBB$default(this, argsToParse, false, 2, null);
        if (Intrinsics.areEqual((Object)System.getProperty("dumpClassPath", "false"), (Object)"true")) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"getSystemClassLoader(...)");
            this.dumpClassLoader(classLoader);
            if (ClassLoader.getSystemClassLoader() != Thread.currentThread().getContextClassLoader()) {
                ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
                Intrinsics.checkNotNullExpressionValue((Object)classLoader2, (String)"getContextClassLoader(...)");
                this.dumpClassLoader(classLoader2);
            }
        }
        Path fileToOpen = null;
        if (!((Collection)argsToParse).isEmpty()) {
            String firstArg = (String)argsToParse.get(0);
            try {
                fileToOpen = Paths.get(firstArg, new String[0]);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(Main.class).error("Failed to open " + firstArg, (Throwable)e);
                BBBootstrap.RECOVERABLE_BOOT_EXCEPTIONS.add(e);
            }
            argsToParse.remove(0);
        }
        if (!((Collection)argsToParse).isEmpty()) {
            LoggerFactory.getLogger(Main.class).error("Unknown extra arguments beyond file: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        }
        Closeable closeable = UsageManagerKt.createDefaultBBUsageManager();
        Throwable throwable = null;
        try {
            BBUsageManager usageManager = (BBUsageManager)closeable;
            boolean bl = false;
            PropertyFileManager propertyFileManager = BBIni.getPropertyFileManager();
            if (FirstRunWizardKt.runFirstRunWizard$default(null, propertyFileManager, usageManager, 1, null)) {
                UUID runId = UUID.randomUUID();
                usageManager.getLogger().log(new UsageRecord("BrailleBlaster", "product", Project.BB.INSTANCE.getDisplayName(), null, 8, null));
                usageManager.getLogger().log(new UsageRecord("BrailleBlaster", "version", Project.BB.INSTANCE.getVersion(), null, 8, null));
                UsageLogger usageLogger = usageManager.getLogger();
                String string = System.getProperty("os.name");
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
                usageLogger.log(new UsageRecord("BrailleBlaster", "os", string, null, 8, null));
                UsageLogger usageLogger2 = usageManager.getLogger();
                String string2 = System.getProperty("os.version");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getProperty(...)");
                usageLogger2.log(new UsageRecord("BrailleBlaster", "os-version", string2, null, 8, null));
                BBUsageManager.startPeriodicDataReporting$default(usageManager, 0L, 5L, TimeUnit.MINUTES, null, 8, null);
                Instant bbStartTime = Instant.now();
                UsageLogger usageLogger3 = usageManager.getLogger();
                String string3 = runId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
                UsageLoggerKt.logStart$default(usageLogger3, "BrailleBlaster", string3, null, 4, null);
                WPManager.Companion.createInstance(fileToOpen, usageManager).start();
                UsageLogger usageLogger4 = usageManager.getLogger();
                Duration duration = Duration.between(bbStartTime, Instant.now());
                Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(...)");
                UsageLoggerKt.logDurationSeconds$default(usageLogger4, "BrailleBlaster", duration, null, 4, null);
                UsageLogger usageLogger5 = usageManager.getLogger();
                String string4 = runId.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toString(...)");
                UsageLoggerKt.logEnd$default(usageLogger5, "BrailleBlaster", string4, null, 4, null);
                BBUsageManager.reportDataAsync$default(usageManager, null, 1, null).get();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @JvmOverloads
    public final void initBB(@NotNull List<String> argsToParse, boolean initBBIni) {
        Intrinsics.checkNotNullParameter(argsToParse, (String)"argsToParse");
        if (isInitted && !BBIni.getDebugging()) {
            throw new RuntimeException("Do not call init twice");
        }
        File bbPath = BBData.INSTANCE.getBrailleblasterPath();
        System.out.println((Object)("BrailleBlaster path: " + bbPath));
        File userPath = BBData.INSTANCE.getUserDataPath();
        File bbLogConfig = new File(userPath, "programData/settings/logback.xml");
        if (!bbLogConfig.exists()) {
            bbLogConfig = new File(bbPath, "programData/settings/logback.xml");
        }
        LogUtils.initLogback(bbLogConfig);
        MathCATUtilsKt.singleThreadedMathCAT(arg_0 -> Main.initBB$lambda$0(bbPath, arg_0));
        if (System.getProperty("nodeexception.folder") == null) {
            System.setProperty("nodeexception.folder", userPath.toString());
        }
        Thread.UncaughtExceptionHandler oldHandler = Thread.getDefaultUncaughtExceptionHandler();
        if (!BBIni.getDebugging()) {
            Thread.setDefaultUncaughtExceptionHandler(Main::initBB$lambda$1);
        }
        if (initBBIni) {
            BBIni.initialize$default(BBIni.INSTANCE, CollectionsKt.toMutableList((Collection)argsToParse), bbPath, userPath, null, 8, null);
        }
        if (BBIni.getDebugging()) {
            Thread.setDefaultUncaughtExceptionHandler(oldHandler);
        }
        isInitted = true;
    }

    public static /* synthetic */ void initBB$default(Main main, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        main.initBB(list, bl);
    }

    @JvmStatic
    public static final void handleFatalException(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        System.out.println((Object)"---Fatal Exception caught by Main---");
        t.printStackTrace();
        String message = NotifyUtils.INSTANCE.generateExceptionMessage("FATAL ERROR: BrailleBlaster must now close. You may choose to send an error report to APH below.", new RuntimeException("Fatal exception caught by Main, see logs", t));
        if (BBIni.INSTANCE.getAutoSaveCrashPath() != null) {
            BBIni.INSTANCE.createAutoSaveCrashFile();
        }
        SoundManager.INSTANCE.playBeep();
        Notify.INSTANCE.handleFatalException(message, "Fatal Error", t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void deleteExceptionFiles() {
        List filesToDelete = new ArrayList();
        File[] fileArray = BBData.INSTANCE.getUserDataPath().listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File curFile = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = curFile.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (!StringsKt.startsWith$default((String)string, (String)"node_exception", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNull((Object)curFile);
            filesToDelete.add(curFile);
            curFile.delete();
        }
        if (!((Collection)filesToDelete).isEmpty()) {
            AutoCloseable autoCloseable = new WorkingDialog("Cleanup Exception Files...");
            Throwable throwable = null;
            try {
                WorkingDialog it = (WorkingDialog)autoCloseable;
                boolean bl = false;
                for (File curFile : filesToDelete) {
                    LogUtils.preLog(Main.class, "Deleting old exception file " + curFile.getAbsolutePath(), new Object[0]);
                    curFile.delete();
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
    }

    private final void dumpClassLoader(ClassLoader curClassLoader) {
        if (curClassLoader instanceof URLClassLoader) {
            URL[] uRLArray = ((URLClassLoader)curClassLoader).getURLs();
            Intrinsics.checkNotNullExpressionValue((Object)uRLArray, (String)"getURLs(...)");
            for (URL curString : uRLArray) {
                System.out.println((Object)("ClassPath: " + curString));
            }
        } else {
            System.out.println((Object)("Unknown ClassLoader " + curClassLoader.getClass()));
        }
    }

    @JvmOverloads
    public final void initBB(@NotNull List<String> argsToParse) {
        Intrinsics.checkNotNullParameter(argsToParse, (String)"argsToParse");
        Main.initBB$default(this, argsToParse, false, 2, null);
    }

    private static final Unit initBB$lambda$0(File $bbPath, MathCat $this$singleThreadedMathCAT) {
        Intrinsics.checkNotNullParameter((Object)$this$singleThreadedMathCAT, (String)"$this$singleThreadedMathCAT");
        $this$singleThreadedMathCAT.setRulesDir(new File($bbPath, "programData/MathCAT/Rules").getAbsolutePath());
        return Unit.INSTANCE;
    }

    private static final void initBB$lambda$1(Thread thread, Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Main.handleFatalException(e);
    }
}

