/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.abstractClasses;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import nu.xom.Text;
import org.brailleblaster.utd.properties.UTDElements;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\t\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u000e\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011H\u0007\u00a8\u0006\u0013"}, d2={"Lorg/brailleblaster/abstractClasses/ViewUtils;", "", "<init>", "()V", "isElement", "", "n", "Lnu/xom/Node;", "isText", "isMoveTo", "e", "Lnu/xom/Element;", "isNewPage", "followsMoveTo", "followsBraillePage", "followsNewPage", "getAttributeValue", "", "val", "brailleblaster-core"})
public final class ViewUtils {
    @NotNull
    public static final ViewUtils INSTANCE = new ViewUtils();

    private ViewUtils() {
    }

    @JvmStatic
    public static final boolean isElement(@Nullable Node n) {
        return n instanceof Element;
    }

    public final boolean isText(@Nullable Node n) {
        return n instanceof Text;
    }

    public final boolean isMoveTo(@Nullable Element e) {
        return UTDElements.MOVE_TO.isA((Node)e);
    }

    public final boolean isNewPage(@Nullable Element e) {
        return UTDElements.NEW_PAGE.isA((Node)e);
    }

    @JvmStatic
    public static final boolean followsMoveTo(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int index = parent.indexOf(n);
        return index > 0 && UTDElements.MOVE_TO.isA(parent.getChild(index - 1));
    }

    public final boolean followsBraillePage(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int index = parent.indexOf(n);
        if (index > 0 && ViewUtils.isElement(parent.getChild(index - 1))) {
            return UTDElements.BRLONLY.isA(parent.getChild(index - 1));
        }
        return false;
    }

    @JvmStatic
    public static final boolean followsNewPage(@NotNull Node n) {
        Intrinsics.checkNotNullParameter((Object)n, (String)"n");
        ParentNode parentNode = n.getParent();
        Intrinsics.checkNotNull((Object)parentNode, (String)"null cannot be cast to non-null type nu.xom.Element");
        Element parent = (Element)parentNode;
        int index = parent.indexOf(n);
        return index > 0 && UTDElements.NEW_PAGE.isA(parent.getChild(index - 1));
    }

    @JvmStatic
    @Nullable
    public static final String getAttributeValue(@NotNull Element e, @Nullable String val) {
        Attribute atr;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Attribute attribute = atr = e.getAttribute(val);
        return attribute != null ? attribute.getValue() : null;
    }
}

