/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import jakarta.xml.bind.DatatypeConverter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.BBXArchiverLoader;
import org.brailleblaster.archiver2.BBZArchiver;
import org.brailleblaster.archiver2.BRFArchiverLoader;
import org.brailleblaster.archiver2.BRLArchiverLoader;
import org.brailleblaster.archiver2.NimasFileArchiverLoader;
import org.brailleblaster.archiver2.NimasZipArchiverLoader;
import org.brailleblaster.archiver2.PandocArchiverLoader;
import org.brailleblaster.archiver2.TextArchiveLoader;
import org.brailleblaster.archiver2.ZipHandles;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.exceptions.BBNotifyException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0004 !\"#B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u001c\u001a\u00020\rJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00132\u0006\u0010\u001c\u001a\u00020\rR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\n0\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\n0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0015R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n0\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0015R\u0016\u0010\u001d\u001a\n \u001f*\u0004\u0018\u00010\u001e0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory;", "", "<init>", "()V", "loaders", "", "Lorg/brailleblaster/archiver2/ArchiverFactory$Types;", "", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "supportedExtensionAndDesc", "", "pandocExts", "load", "Lorg/brailleblaster/archiver2/Archiver2;", "path", "Ljava/nio/file/Path;", "detectFileType", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "supportedExtensions", "", "getSupportedExtensions", "()Ljava/util/Collection;", "supportedDescriptions", "getSupportedDescriptions", "supportedExtensionsWithCombinedEntry", "getSupportedExtensionsWithCombinedEntry", "supportedDescriptionsWithCombinedEntry", "getSupportedDescriptionsWithCombinedEntry", "archiver", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "ExtensionSupport", "FileLoader", "Types", "ParseData", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nArchiverFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiverFactory.kt\norg/brailleblaster/archiver2/ArchiverFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,250:1\n777#2:251\n873#2,2:252\n491#3,7:254\n*S KotlinDebug\n*F\n+ 1 ArchiverFactory.kt\norg/brailleblaster/archiver2/ArchiverFactory\n*L\n182#1:251\n182#1:252,2\n187#1:254,7\n*E\n"})
public final class ArchiverFactory {
    @NotNull
    public static final ArchiverFactory INSTANCE = new ArchiverFactory();
    @NotNull
    private static final Map<Types, List<FileLoader>> loaders;
    @NotNull
    private static final Map<String, String> supportedExtensionAndDesc;
    @NotNull
    private static final List<String> pandocExts;
    private static final Logger log;

    private ArchiverFactory() {
    }

    @NotNull
    public final Archiver2 load(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        log.info("Loading file " + path);
        ParseData parseData = null;
        try {
            Archiver2 archiver;
            block11: {
                parseData = this.detectFileType(path);
                log.info("Parsed file {} as {}", (Object)path, (Object)parseData);
                List<FileLoader> list = loaders.get((Object)parseData.getType());
                if (list != null) {
                    for (FileLoader curLoader : (Iterable)list) {
                        boolean bl = false;
                        log.info("Attempting to load {} with loader {}", (Object)path, (Object)curLoader);
                        Archiver2 archiver2 = curLoader.tryLoad(path, parseData);
                        if (archiver2 == null) continue;
                        v1 = archiver2;
                        break block11;
                    }
                    v1 = null;
                } else {
                    v1 = archiver = null;
                }
            }
            if (archiver != null) {
                return archiver;
            }
        }
        catch (Exception e) {
            throw new BBNotifyException("Failed when opening file " + path, (Throwable)e);
        }
        log.info("Failed to load the file {}", (Object)path);
        switch (WhenMappings.$EnumSwitchMapping$0[parseData.getType().ordinal()]) {
            case 1: {
                throw new BBNotifyException(path + " is not a valid BBX or NIMAS XML file");
            }
            case 2: {
                throw new BBNotifyException(path + " is not a valid BBZ or NIMAS ZIP file");
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                throw new BBNotifyException(path + " is not a valid DOCX, EPUB, HTML, TEX, MD. or ODT that can be opened by BrailleBlaster");
            }
        }
        throw new BBNotifyException(path + " cannot be opened by BrailleBlaster");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParseData detectFileType(Path path) throws IOException {
        Object object = ((Object)path).toString();
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string = object.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String testpath = string;
        if (StringsKt.endsWith$default((String)testpath, (String)".docx", (boolean)false, (int)2, null)) {
            return new ParseData(Types.DOCX, null);
        }
        if (StringsKt.endsWith$default((String)testpath, (String)".epub", (boolean)false, (int)2, null)) {
            return new ParseData(Types.EPUB, null);
        }
        if (StringsKt.endsWith$default((String)testpath, (String)".html", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)testpath, (String)".htm", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)testpath, (String)".xhtml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)testpath, (String)".xhtm", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)testpath, (String)".xht", (boolean)false, (int)2, null)) {
            return new ParseData(Types.HTML, null);
        }
        if (StringsKt.endsWith$default((String)testpath, (String)".odt", (boolean)false, (int)2, null)) {
            return new ParseData(Types.ODT, null);
        }
        if (StringsKt.endsWith$default((String)testpath, (String)".md", (boolean)false, (int)2, null)) {
            return new ParseData(Types.MD, null);
        }
        if (StringsKt.endsWith$default((String)testpath, (String)".tex", (boolean)false, (int)2, null)) {
            return new ParseData(Types.TEX, null);
        }
        log.warn("File {} not of pandoc type", (Object)path);
        if (ZipHandles.has(path)) {
            return new ParseData(Types.ZIP, null);
        }
        object = new OpenOption[]{StandardOpenOption.READ};
        object = Files.newInputStream(path, object);
        Throwable throwable = null;
        try {
            InputStream rawInput = (InputStream)object;
            boolean bl = false;
            byte[] header = new byte[4];
            rawInput.read(header, 0, 4);
            if (header[0] == 80 && header[1] == 75) {
                log.trace("Detected zip");
                if (header[2] == 3 && header[3] == 4) {
                    ParseData parseData = new ParseData(Types.ZIP, null);
                    return parseData;
                }
                if (header[2] == 5 && header[3] == 6) {
                    throw new BBNotifyException("Cannot open empty ZIP file");
                }
                if (header[2] == 7 && header[3] == 8) {
                    throw new BBNotifyException("Spanned/Multi-part ZIP is not supported");
                }
                log.error("Potential zip file has unknown signature {}", (Object)DatatypeConverter.printHexBinary((byte[])header));
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        try {
            return new ParseData(Types.XML, FileLoader.Companion.loadXML(path));
        }
        catch (Exception e) {
            log.warn("Failed to load {} as an XML file", (Object)path, (Object)e);
            return new ParseData(Types.OTHER, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<String> getSupportedExtensions() {
        void $this$filterTo$iv$iv;
        String pandoc = System.getProperty("PANDOC");
        Iterable $this$filter$iv = supportedExtensionAndDesc.keySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!(pandoc != null || !pandocExts.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Collection<String> getSupportedDescriptions() {
        String pandoc = System.getProperty("PANDOC");
        Map<String, String> $this$filterKeys$iv = supportedExtensionAndDesc;
        boolean $i$f$filterKeys = false;
        LinkedHashMap<String, String> result$iv = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry$iv : $this$filterKeys$iv.entrySet()) {
            String it = entry$iv.getKey();
            boolean bl = false;
            if (!(pandoc != null || !pandocExts.contains(it))) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        return ((Map)result$iv).values();
    }

    @NotNull
    public final Collection<String> getSupportedExtensionsWithCombinedEntry() {
        Collection<String> supported = this.getSupportedExtensions();
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)CollectionsKt.joinToString$default((Iterable)supported, (CharSequence)";", null, null, (int)0, null, null, (int)62, null)), (Iterable)supported);
    }

    @NotNull
    public final Collection<String> getSupportedDescriptionsWithCombinedEntry() {
        Collection<String> supported = this.getSupportedDescriptions();
        return CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)("All BB Documents (" + CollectionsKt.joinToString$default((Iterable)this.getSupportedExtensions(), (CharSequence)";", null, null, (int)0, null, null, (int)62, null) + ")")), (Iterable)supported);
    }

    @NotNull
    public final Collection<String> getSupportedExtensions(@NotNull Archiver2 archiver) {
        Intrinsics.checkNotNullParameter((Object)archiver, (String)"archiver");
        return archiver.getExtensionsAndDescription().keySet();
    }

    @NotNull
    public final Collection<String> getSupportedDescriptions(@NotNull Archiver2 archiver) {
        Intrinsics.checkNotNullParameter((Object)archiver, (String)"archiver");
        return archiver.getExtensionsAndDescription().values();
    }

    private static final String supportedExtensionAndDesc$lambda$0$0(String existing, String current) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
        return existing + " " + current;
    }

    private static final String supportedExtensionAndDesc$lambda$0$1(Function2 $tmp0, Object p0, Object p1) {
        return (String)$tmp0.invoke(p0, p1);
    }

    static {
        Object[] objectArray = new Pair[10];
        Object[] objectArray2 = new FileLoader[]{BBZArchiver.Loader.Companion.getINSTANCE(), NimasZipArchiverLoader.Companion.getINSTANCE()};
        objectArray[0] = TuplesKt.to((Object)((Object)Types.ZIP), (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray2 = new FileLoader[]{BBXArchiverLoader.INSTANCE, NimasFileArchiverLoader.INSTANCE};
        objectArray[1] = TuplesKt.to((Object)((Object)Types.XML), (Object)CollectionsKt.listOf((Object[])objectArray2));
        objectArray[2] = TuplesKt.to((Object)((Object)Types.DOCX), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[3] = TuplesKt.to((Object)((Object)Types.EPUB), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[4] = TuplesKt.to((Object)((Object)Types.MD), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[5] = TuplesKt.to((Object)((Object)Types.MD), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[6] = TuplesKt.to((Object)((Object)Types.HTML), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[7] = TuplesKt.to((Object)((Object)Types.ODT), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray[8] = TuplesKt.to((Object)((Object)Types.TEX), (Object)CollectionsKt.listOf((Object)PandocArchiverLoader.INSTANCE));
        objectArray2 = new FileLoader[]{BRLArchiverLoader.Companion.getINSTANCE(), BRFArchiverLoader.Companion.getINSTANCE(), TextArchiveLoader.Companion.getINSTANCE()};
        objectArray[9] = TuplesKt.to((Object)((Object)Types.OTHER), (Object)CollectionsKt.listOf((Object[])objectArray2));
        loaders = MapsKt.mapOf((Pair[])objectArray);
        objectArray = MapsKt.createMapBuilder();
        Object[] $this$supportedExtensionAndDesc_u24lambda_u240 = objectArray;
        boolean bl = false;
        boolean alreadyLoaded = false;
        for (FileLoader loader : CollectionsKt.flatten((Iterable)loaders.values())) {
            if (loader instanceof PandocArchiverLoader) {
                if (alreadyLoaded) continue;
                alreadyLoaded = true;
            }
            for (Map.Entry<String, String> entry : loader.getExtensionsAndDescription().entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                $this$supportedExtensionAndDesc_u24lambda_u240.merge(key, value, (arg_0, arg_1) -> ArchiverFactory.supportedExtensionAndDesc$lambda$0$1(ArchiverFactory::supportedExtensionAndDesc$lambda$0$0, arg_0, arg_1));
            }
        }
        supportedExtensionAndDesc = MapsKt.toSortedMap((Map)MapsKt.build((Map)objectArray));
        objectArray = new String[]{"*.docx", "*.epub", "*.htm", "*.html", "*.xhtml;*.xhtm;*.xht", "*.md", "*.odt", "*tex"};
        pandocExts = CollectionsKt.listOf((Object[])objectArray);
        log = LoggerFactory.getLogger(ArchiverFactory.class);
        System.setProperty("PANDOC", "true");
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory$ExtensionSupport;", "", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "brailleblaster-core"})
    public static interface ExtensionSupport {
        @NotNull
        public Map<String, String> getExtensionsAndDescription();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$ExtensionSupport;", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "Companion", "brailleblaster-core"})
    public static interface FileLoader
    extends ExtensionSupport {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        @Nullable
        public Archiver2 tryLoad(@NotNull Path var1, @NotNull ParseData var2) throws Exception;

        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ \u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader$Companion;", "", "<init>", "()V", "loadXML", "Lnu/xom/Document;", "file", "Ljava/nio/file/Path;", "convert", "standard", "", "book", "brailleblaster-core"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Document loadXML(@NotNull Path file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                return new XMLHandler().load(file);
            }

            @NotNull
            public final Document convert(@NotNull Path file, @NotNull String standard) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)standard, (String)"standard");
                return this.convert(file, null, standard);
            }

            @NotNull
            public final Document convert(@NotNull Path file, @Nullable Document book, @NotNull String standard) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                Intrinsics.checkNotNullParameter((Object)standard, (String)"standard");
                log.info("Converting nimas {} to bbx", (Object)file.toUri());
                BookToBBXConverter converter = BookToBBXConverter.Companion.fromConfig(standard);
                Document document = book;
                if (document == null) {
                    document = this.loadXML(file);
                }
                return BookToBBXConverter.convert$default(converter, document, null, 2, null);
            }

            static {
                $$INSTANCE = new Companion();
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\f\u001a\u00020\rH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "", "type", "Lorg/brailleblaster/archiver2/ArchiverFactory$Types;", "doc", "Lnu/xom/Document;", "<init>", "(Lorg/brailleblaster/archiver2/ArchiverFactory$Types;Lnu/xom/Document;)V", "getType", "()Lorg/brailleblaster/archiver2/ArchiverFactory$Types;", "getDoc", "()Lnu/xom/Document;", "toString", "", "brailleblaster-core"})
    public static final class ParseData {
        @NotNull
        private final Types type;
        @Nullable
        private final Document doc;

        public ParseData(@NotNull Types type, @Nullable Document doc) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
            this.doc = doc;
        }

        @NotNull
        public final Types getType() {
            return this.type;
        }

        @Nullable
        public final Document getDoc() {
            return this.doc;
        }

        @NotNull
        public String toString() {
            return "ParseData{type=" + this.type + ", doc=" + this.doc + "}";
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/archiver2/ArchiverFactory$Types;", "", "<init>", "(Ljava/lang/String;I)V", "ZIP", "XML", "DOCX", "EPUB", "HTML", "MD", "ODT", "TEX", "OTHER", "brailleblaster-core"})
    public static final class Types
    extends Enum<Types> {
        public static final /* enum */ Types ZIP = new Types();
        public static final /* enum */ Types XML = new Types();
        public static final /* enum */ Types DOCX = new Types();
        public static final /* enum */ Types EPUB = new Types();
        public static final /* enum */ Types HTML = new Types();
        public static final /* enum */ Types MD = new Types();
        public static final /* enum */ Types ODT = new Types();
        public static final /* enum */ Types TEX = new Types();
        public static final /* enum */ Types OTHER = new Types();
        private static final /* synthetic */ Types[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Types[] values() {
            return (Types[])$VALUES.clone();
        }

        public static Types valueOf(String value) {
            return Enum.valueOf(Types.class, value);
        }

        @NotNull
        public static EnumEntries<Types> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typesArray = new Types[]{Types.ZIP, Types.XML, Types.DOCX, Types.EPUB, Types.HTML, Types.MD, Types.ODT, Types.TEX, Types.OTHER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Types.values().length];
            try {
                nArray[Types.XML.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.ZIP.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.DOCX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.EPUB.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.HTML.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.MD.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.ODT.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Types.TEX.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

