/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.brailleblaster.BBIni;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.perspectives.braille.Manager;
import org.brailleblaster.utd.UTDTranslationEngine;
import org.brailleblaster.util.Notify;
import org.eclipse.swt.widgets.Display;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/archiver2/ArchiverRecoverThread;", "", "m", "Lorg/brailleblaster/perspectives/braille/Manager;", "<init>", "(Lorg/brailleblaster/perspectives/braille/Manager;)V", "handler", "Ljava/util/concurrent/ScheduledFuture;", "firstOpen", "", "addFile", "", "saveFile", "path", "Ljava/nio/file/Path;", "saveAutoSaveFile", "removeFile", "autoSave", "status", "Companion", "brailleblaster-core"})
public final class ArchiverRecoverThread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Manager m;
    @Nullable
    private ScheduledFuture<?> handler;
    private boolean firstOpen;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final SimpleDateFormat dateFormatter;
    @NotNull
    private static final List<Path> RECENT_SAVE_FILES;
    private static final int MAX_RECENT_SAVES = 10;
    private static final long AUTO_SAVE_MILLISECONDS = 300000L;
    private static final ScheduledExecutorService scheduler;

    public ArchiverRecoverThread(@NotNull Manager m) {
        Intrinsics.checkNotNullParameter((Object)m, (String)"m");
        this.m = m;
        this.firstOpen = true;
    }

    private final void addFile() {
        Path fileName = this.m.getArchiver().getPath().getFileName();
        if (this.firstOpen) {
            String oldAutoSavePath = ((Object)this.m.getArchiver().getPath()).toString();
            if (StringsKt.contains$default((CharSequence)oldAutoSavePath, (CharSequence)((Object)BBIni.getAutoSavePath()).toString(), (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNull((Object)fileName);
                this.saveAutoSaveFile(fileName);
                Path path = Paths.get(oldAutoSavePath, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                ArchiverRecoverThread.Companion.removeSavedFile(path);
                this.firstOpen = false;
                return;
            }
            this.firstOpen = false;
        }
        if (this.m.getText().hasChanged && this.m.getLastCopiedDoc() != null && !BBIni.getDebugging()) {
            Intrinsics.checkNotNull((Object)fileName);
            this.saveFile(fileName);
        }
    }

    private final void saveFile(Path path) {
        String fileName = ArchiverRecoverThread.Companion.fileReName(path);
        Archiver2 archiver2 = this.m.getArchiver();
        Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
        Archiver2 arch = archiver2;
        UTDTranslationEngine engine = this.m.getDocument().getEngine();
        Path path2 = BBIni.getAutoSavePath().resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Document document = this.m.getLastCopiedDoc();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getLastCopiedDoc(...)");
        arch.save(path2, document, engine, SetsKt.emptySet());
        Path path3 = BBIni.getAutoSavePath().resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Companion.addRecentSave(path3);
    }

    private final void saveAutoSaveFile(Path path) {
        String fileName = ArchiverRecoverThread.Companion.fileReName(path);
        Archiver2 archiver2 = this.m.getArchiver();
        Intrinsics.checkNotNullExpressionValue((Object)archiver2, (String)"<get-archiver>(...)");
        Archiver2 arch = archiver2;
        UTDTranslationEngine engine = this.m.getDocument().getEngine();
        Path path2 = BBIni.getAutoSavePath().resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        arch.save(path2, arch.getBbxDocument(), engine, SetsKt.emptySet());
        Path path3 = BBIni.getAutoSavePath().resolve(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        Companion.addRecentSave(path3);
    }

    public final void removeFile() {
        Path path = this.m.getArchiver().getPath().getFileName();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getFileName(...)");
        Companion.removeFile(path);
    }

    public final void autoSave(boolean status) {
        ScheduledFuture<?> scheduledFuture = this.handler;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
        if (status) {
            this.handler = scheduler.scheduleWithFixedDelay(() -> ArchiverRecoverThread.autoSave$lambda$0(this), 300000L, 300000L, TimeUnit.MILLISECONDS);
        }
    }

    private static final void autoSave$lambda$0$0(RuntimeException $e) {
        Notify.INSTANCE.showException($e);
    }

    private static final void autoSave$lambda$0(ArchiverRecoverThread this$0) {
        try {
            this$0.addFile();
        }
        catch (RuntimeException e) {
            Display.getDefault().syncExec(() -> ArchiverRecoverThread.autoSave$lambda$0$0(e));
        }
    }

    @NotNull
    public static final List<Path> getRecentSaves() {
        return Companion.getRecentSaves();
    }

    @JvmStatic
    @NotNull
    public static final List<Path> readRecentSaves() {
        return Companion.readRecentSaves();
    }

    static {
        Logger logger = LoggerFactory.getLogger(ArchiverRecoverThread.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        dateFormatter = new SimpleDateFormat("yyyyMMddHHmmss");
        RECENT_SAVE_FILES = Companion.readRecentSaves();
        scheduler = Executors.newSingleThreadScheduledExecutor();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\nH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\nH\u0002J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\b\u0010\u001f\u001a\u00020\u0013H\u0002J\u000e\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nJ\u000e\u0010!\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001a8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u0003\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lorg/brailleblaster/archiver2/ArchiverRecoverThread$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "dateFormatter", "Ljava/text/SimpleDateFormat;", "RECENT_SAVE_FILES", "", "Ljava/nio/file/Path;", "MAX_RECENT_SAVES", "", "AUTO_SAVE_MILLISECONDS", "", "scheduler", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "removeFile", "", "path", "removeSavedFile", "savedPath", "fileReName", "", "recentSaves", "", "getRecentSaves$annotations", "getRecentSaves", "()Ljava/util/List;", "readRecentSaves", "writeRecentSaves", "addRecentSave", "deleteRecentSave", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nArchiverRecoverThread.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArchiverRecoverThread.kt\norg/brailleblaster/archiver2/ArchiverRecoverThread$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,202:1\n1642#2,10:203\n1915#2:213\n1916#2:215\n1652#2:216\n1586#2:217\n1661#2,3:218\n1#3:214\n*S KotlinDebug\n*F\n+ 1 ArchiverRecoverThread.kt\norg/brailleblaster/archiver2/ArchiverRecoverThread$Companion\n*L\n149#1:203,10\n149#1:213\n149#1:215\n149#1:216\n173#1:217\n173#1:218,3\n149#1:214\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void removeFile(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            String fileName = this.fileReName(path);
            Path path2 = Paths.get(((Object)BBIni.getAutoSavePath().resolve(fileName)).toString(), new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
            this.removeSavedFile(path2);
        }

        private final void removeSavedFile(Path savedPath) {
            try {
                Files.deleteIfExists(savedPath);
                this.deleteRecentSave(savedPath);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        private final String fileReName(Path path) {
            Date cal = Calendar.getInstance().getTime();
            String dateTimeString = dateFormatter.format(cal);
            return PathsKt.getNameWithoutExtension((Path)path) + " " + dateTimeString + "." + PathsKt.getExtension((Path)path);
        }

        @NotNull
        public final List<Path> getRecentSaves() {
            return RECENT_SAVE_FILES;
        }

        @JvmStatic
        public static /* synthetic */ void getRecentSaves$annotations() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<Path> readRecentSaves() {
            try {
                void $this$mapNotNullTo$iv$iv;
                List<String> list = Files.readAllLines(BBIni.getRecentSaves(), BBIni.INSTANCE.getCharset());
                Intrinsics.checkNotNullExpressionValue(list, (String)"readAllLines(...)");
                Iterable $this$mapNotNull$iv = list;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    Path it$iv$iv;
                    Path path;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    String strPath = (String)element$iv$iv;
                    boolean bl2 = false;
                    try {
                        Intrinsics.checkNotNullExpressionValue((Object)Paths.get(strPath, new String[0]), (String)"get(...)");
                    }
                    catch (InvalidPathException e) {
                        log.error("Recent Saves file corrupted at " + BBIni.getRecentSaves(), (Throwable)e);
                        path = null;
                    }
                    if (path == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            }
            catch (Exception e) {
                Notify.INSTANCE.showException(e);
                return new ArrayList();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        private final void writeRecentSaves() {
            List list = RECENT_SAVE_FILES;
            synchronized (list) {
                Iterable iterable;
                boolean bl = false;
                try {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    iterable = RECENT_SAVE_FILES;
                    Path path = BBIni.getRecentSaves();
                    boolean $i$f$map = false;
                    void var6_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void curPath;
                        Path path2 = (Path)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(((Object)curPath.toAbsolutePath()).toString());
                    }
                    iterable = Files.write(path, (Iterable<? extends CharSequence>)((List)destination$iv$iv), new OpenOption[0]);
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to save recent docs file", e);
                }
                Iterable iterable2 = iterable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void addRecentSave(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            List list = RECENT_SAVE_FILES;
            synchronized (list) {
                boolean bl = false;
                RECENT_SAVE_FILES.remove(path);
                while (RECENT_SAVE_FILES.size() >= 10) {
                    RECENT_SAVE_FILES.remove(RECENT_SAVE_FILES.size() - 1);
                }
                RECENT_SAVE_FILES.add(0, path);
                Companion.writeRecentSaves();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final synchronized void deleteRecentSave(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            List list = RECENT_SAVE_FILES;
            synchronized (list) {
                boolean bl = false;
                RECENT_SAVE_FILES.remove(path);
                Companion.writeRecentSaves();
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

