/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Text;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.TextArchiveLoader;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.utd.properties.EmphasisType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0014R \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0014"}, d2={"Lorg/brailleblaster/archiver2/BRLArchiverLoader;", "Lorg/brailleblaster/archiver2/TextArchiveLoader;", "<init>", "()V", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "createBlock", "Lnu/xom/Element;", "usableText", "Lnu/xom/Text;", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "Companion", "brailleblaster-core"})
public final class BRLArchiverLoader
extends TextArchiveLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.brl", (Object)"Braille Text (*.brl)"));
    @NotNull
    private static final BRLArchiverLoader INSTANCE = new BRLArchiverLoader();

    @Override
    @Nullable
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        return StringsKt.endsWith((String)((Object)file.getFileName()).toString(), (String)".brl", (boolean)true) ? super.tryLoad(file, fileData) : null;
    }

    @Override
    @NotNull
    protected Element createBlock(@Nullable Text usableText) {
        Element block = BBX.BLOCK.DEFAULT.create();
        EmphasisType[] emphasisTypeArray = new EmphasisType[]{EmphasisType.NO_TRANSLATE};
        Element direct = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
        direct.appendChild((Node)usableText);
        block.appendChild((Node)direct);
        Intrinsics.checkNotNull((Object)block);
        return block;
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return this.extensionsAndDescription;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/archiver2/BRLArchiverLoader$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/brailleblaster/archiver2/BRLArchiverLoader;", "getINSTANCE", "()Lorg/brailleblaster/archiver2/BRLArchiverLoader;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BRLArchiverLoader getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

