/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.BBZArchiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/brailleblaster/archiver2/NimasFileArchiverLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "brailleblaster-core"})
public final class NimasFileArchiverLoader
implements ArchiverFactory.FileLoader {
    @NotNull
    public static final NimasFileArchiverLoader INSTANCE = new NimasFileArchiverLoader();
    @NotNull
    private static final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.xml", (Object)"Nimas XML (*.xml)"));
    private static final Logger log = LoggerFactory.getLogger(NimasFileArchiverLoader.class);

    private NimasFileArchiverLoader() {
    }

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return extensionsAndDescription;
    }

    @Override
    @Nullable
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        Archiver2 archiver2;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        Document document = fileData.getDoc();
        Intrinsics.checkNotNull((Object)document);
        String rootName = document.getRootElement().getLocalName();
        if (Intrinsics.areEqual((Object)rootName, (Object)"dtbook")) {
            Archiver2 archiver = BBZArchiver.Companion.createImportedBBZ(file, ArchiverFactory.FileLoader.Companion.convert(file, "nimas"));
            Object fileStr = ((Object)file).toString();
            String string = fileStr;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            fileStr = (String)(StringsKt.endsWith$default((String)string2, (String)".xml", (boolean)false, (int)2, null) ? StringsKt.dropLast((String)fileStr, (int)4) : fileStr) + ".bbz";
            archiver.setNewPath(Paths.get((String)fileStr, new String[0]));
            archiver2 = archiver;
        } else {
            log.error("File " + file.toUri() + " has root element '" + rootName + "', not nimas dtbook");
            archiver2 = null;
        }
        return archiver2;
    }
}

