/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Node;
import org.brailleblaster.archiver2.Archiver2;
import org.brailleblaster.archiver2.ArchiverFactory;
import org.brailleblaster.archiver2.BBZArchiver;
import org.brailleblaster.archiver2.OPFUtils;
import org.brailleblaster.archiver2.ZipHandles;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/brailleblaster/archiver2/NimasZipArchiverLoader;", "Lorg/brailleblaster/archiver2/ArchiverFactory$FileLoader;", "<init>", "()V", "extensionsAndDescription", "", "", "getExtensionsAndDescription", "()Ljava/util/Map;", "tryLoad", "Lorg/brailleblaster/archiver2/Archiver2;", "file", "Ljava/nio/file/Path;", "fileData", "Lorg/brailleblaster/archiver2/ArchiverFactory$ParseData;", "Companion", "brailleblaster-core"})
public final class NimasZipArchiverLoader
implements ArchiverFactory.FileLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, String> extensionsAndDescription = MapsKt.mapOf((Pair)TuplesKt.to((Object)"*.zip", (Object)"Nimas ZIP (*.zip)"));
    @NotNull
    private static final NimasZipArchiverLoader INSTANCE = new NimasZipArchiverLoader();
    @NotNull
    private static final Logger log;

    @Override
    @NotNull
    public Map<String, String> getExtensionsAndDescription() {
        return this.extensionsAndDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Archiver2 tryLoad(@NotNull Path file, @NotNull ArchiverFactory.ParseData fileData) throws Exception {
        Document document;
        Object opfFile;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileData, (String)"fileData");
        FileSystem zipFS = ZipHandles.open(file, false);
        Path zipRoot = zipFS.getPath("/", new String[0]);
        Object bookPath = null;
        Intrinsics.checkNotNull((Object)zipRoot);
        List<Path> opfFiles = OPFUtils.findOPFFilesInFolder(zipRoot);
        if (!opfFiles.isEmpty()) {
            if (opfFiles.size() > 1) {
                log.warn("Detected multiple OPF files, picking first: {}", opfFiles);
            }
            opfFile = (Path)CollectionsKt.first(opfFiles);
            log.info("Detected nimas OPF file at {}", opfFile);
            try {
                document = new XMLHandler().load((Path)opfFile);
            }
            catch (Exception e) {
                log.error("Failed to open OPF file", (Throwable)e);
                document = null;
            }
            Document opfDocument = document;
            if (opfDocument != null) {
                OPFUtils.ManifestEntry bookManifest = Companion.guessNimasLocation(opfDocument);
                bookPath = opfFile.resolveSibling(bookManifest.href);
                if (!Files.exists((Path)bookPath, new LinkOption[0])) {
                    AutoCloseable e = Files.list(bookPath.getParent());
                    Throwable throwable = null;
                    try {
                        Stream filesStream = (Stream)e;
                        boolean bl = false;
                        bookPath = filesStream.filter(arg_0 -> NimasZipArchiverLoader.tryLoad$lambda$0$1(arg_0 -> NimasZipArchiverLoader.tryLoad$lambda$0$0(bookManifest, arg_0), arg_0)).findFirst().orElseThrow(() -> NimasZipArchiverLoader.tryLoad$lambda$0$2(bookManifest, (Path)opfFile));
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)e, (Throwable)throwable);
                    }
                }
            }
        }
        if (bookPath == null) {
            log.warn("No opf files detected, brute forcing");
            opfFile = Files.walk(zipRoot, new FileVisitOption[0]);
            Throwable throwable = null;
            try {
                Stream filesStream = (Stream)opfFile;
                boolean bl = false;
                bookPath = filesStream.filter(arg_0 -> NimasZipArchiverLoader.tryLoad$lambda$1$1(NimasZipArchiverLoader::tryLoad$lambda$1$0, arg_0)).filter(arg_0 -> NimasZipArchiverLoader.tryLoad$lambda$1$3(NimasZipArchiverLoader::tryLoad$lambda$1$2, arg_0)).filter(arg_0 -> NimasZipArchiverLoader.tryLoad$lambda$1$5(NimasZipArchiverLoader::tryLoad$lambda$1$4, arg_0)).findFirst().orElse(null);
                document = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)opfFile, (Throwable)throwable);
            }
            if (bookPath == null) {
                log.warn("File is not a nimas zip: {}", (Object)file);
                return null;
            }
        }
        log.debug("book Path {}", bookPath);
        Document convertedDoc = ArchiverFactory.FileLoader.Companion.convert((Path)bookPath, "nimas");
        Path path = ((Path)bookPath).resolveSibling(((Path)bookPath).getFileName() + ".bbx");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolveSibling(...)");
        return new BBZArchiver(file, zipFS, path, convertedDoc);
    }

    private static final boolean tryLoad$lambda$0$0(OPFUtils.ManifestEntry $bookManifest, Path curPath) {
        Path path = curPath;
        Intrinsics.checkNotNull((Object)path);
        return StringsKt.equals((String)((Object)path.getFileName()).toString(), (String)$bookManifest.href, (boolean)true);
    }

    private static final boolean tryLoad$lambda$0$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final NodeException tryLoad$lambda$0$2(OPFUtils.ManifestEntry $bookManifest, Path $opfFile) {
        return new NodeException("Unable to find file " + $bookManifest.href + " in zip root " + $opfFile.getParent(), (Node)$bookManifest.elem, null, 4, null);
    }

    private static final boolean tryLoad$lambda$1$0(Path path) {
        Path path2 = path;
        Intrinsics.checkNotNull((Object)path2);
        return OPFUtils.pathNotHiddenOrInHiddenDirectory(path2);
    }

    private static final boolean tryLoad$lambda$1$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean tryLoad$lambda$1$2(Path curPath) {
        Path path = curPath;
        Intrinsics.checkNotNull((Object)path);
        return StringsKt.endsWith$default((String)((Object)path.getFileName()).toString(), (String)".xml", (boolean)false, (int)2, null);
    }

    private static final boolean tryLoad$lambda$1$3(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean tryLoad$lambda$1$4(Path curPath) {
        Intrinsics.checkNotNullParameter((Object)curPath, (String)"curPath");
        try {
            return Intrinsics.areEqual((Object)new XMLHandler().load(curPath).getRootElement().getLocalName(), (Object)"dtbook");
        }
        catch (Exception e) {
            log.warn("Failed to detect xml root element of {}", (Object)curPath, (Object)e);
            return false;
        }
    }

    private static final boolean tryLoad$lambda$1$5(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    static {
        Logger logger = LoggerFactory.getLogger(NimasZipArchiverLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/archiver2/NimasZipArchiverLoader$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/brailleblaster/archiver2/NimasZipArchiverLoader;", "getINSTANCE", "()Lorg/brailleblaster/archiver2/NimasZipArchiverLoader;", "log", "Lorg/slf4j/Logger;", "guessNimasLocation", "Lorg/brailleblaster/archiver2/OPFUtils$ManifestEntry;", "opfDocument", "Lnu/xom/Document;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NimasZipArchiverLoader getINSTANCE() {
            return INSTANCE;
        }

        @NotNull
        public final OPFUtils.ManifestEntry guessNimasLocation(@NotNull Document opfDocument) {
            String opfFormat;
            Intrinsics.checkNotNullParameter((Object)opfDocument, (String)"opfDocument");
            String string = OPFUtils.getDCElementValueCaseInsensitive(opfDocument, "format");
            if (string == null) {
                string = "";
            }
            if (!StringsKt.contains((CharSequence)(opfFormat = string), (CharSequence)"nimas", (boolean)true) || !Intrinsics.areEqual((Object)opfFormat, (Object)"ANSI/NISO Z39.86-2002")) {
                log.warn("OPF at {} does not explicitly state nimas, says {}, assuming", (Object)opfDocument.getBaseURI(), (Object)opfFormat);
            }
            for (OPFUtils.ManifestEntry curManifestEntry : OPFUtils.getManifestItems(opfDocument)) {
                try {
                    if (!StringsKt.endsWith$default((String)curManifestEntry.href, (String)".xml", (boolean)false, (int)2, null)) continue;
                    return curManifestEntry;
                }
                catch (Exception e) {
                    throw new NodeException("Mangled manifestEntry", (Node)curManifestEntry.elem, (Throwable)e);
                }
            }
            throw new NodeException("No usable book entry found", (Node)opfDocument, null, 4, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

