/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.archiver2.OPFUtils$getDCElementValueCaseInsensitive$;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\bH\u0007J\u001e\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000bH\u0007J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u00072\u0006\u0010\f\u001a\u00020\rH\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/brailleblaster/archiver2/OPFUtils;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "findOPFFilesInFolder", "", "Ljava/nio/file/Path;", "folder", "getDCElementValueCaseInsensitive", "", "opfDocument", "Lnu/xom/Document;", "opfElemName", "getManifestItems", "Lorg/brailleblaster/archiver2/OPFUtils$ManifestEntry;", "pathNotHiddenOrInHiddenDirectory", "", "path", "ManifestEntry", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nOPFUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OPFUtils.kt\norg/brailleblaster/archiver2/OPFUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,109:1\n479#2:110\n*S KotlinDebug\n*F\n+ 1 OPFUtils.kt\norg/brailleblaster/archiver2/OPFUtils\n*L\n56#1:110\n*E\n"})
public final class OPFUtils {
    @NotNull
    public static final OPFUtils INSTANCE = new OPFUtils();
    @NotNull
    private static final Logger log;

    private OPFUtils() {
    }

    @JvmStatic
    @NotNull
    public static final List<Path> findOPFFilesInFolder(@NotNull Path folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        try {
            List<Path> opfs = Files.walk(folder, new FileVisitOption[0]).filter(arg_0 -> OPFUtils.findOPFFilesInFolder$lambda$1(OPFUtils::findOPFFilesInFolder$lambda$0, arg_0)).peek(arg_0 -> OPFUtils.findOPFFilesInFolder$lambda$3(OPFUtils::findOPFFilesInFolder$lambda$2, arg_0)).collect(Collectors.toList());
            if (opfs.isEmpty()) {
                log.warn("No opfs found in {}", (Object)folder);
            } else if (opfs.size() > 1) {
                log.warn("Found {} OPF files?", (Object)opfs.size());
            }
            Intrinsics.checkNotNull(opfs);
            return opfs;
        }
        catch (Exception exception) {
            throw new RuntimeException("Failed to find OPFs in " + folder);
        }
    }

    @JvmStatic
    @Nullable
    public static final String getDCElementValueCaseInsensitive(@Nullable Document opfDocument, @Nullable String opfElemName) {
        Sequence $this$filterIsInstance$iv = FastXPath.descendant((Node)((Node)opfDocument));
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)getDCElementValueCaseInsensitive$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        List results = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> OPFUtils.getDCElementValueCaseInsensitive$lambda$0(opfElemName, arg_0)));
        if (results.isEmpty()) {
            return null;
        }
        if (results.size() > 1) {
            throw new NodeException("Found more than 1 node", (Node)results.get(1), null, 4, null);
        }
        return ((Element)results.get(0)).getValue();
    }

    @JvmStatic
    @NotNull
    public static final List<ManifestEntry> getManifestItems(@NotNull Document opfDocument) {
        Intrinsics.checkNotNullParameter((Object)opfDocument, (String)"opfDocument");
        String namespace = opfDocument.getRootElement().getNamespaceURI();
        Element manifestRoot = opfDocument.getRootElement().getFirstChildElement("manifest", namespace);
        List entries = new ArrayList();
        Iterator iterator = manifestRoot.getChildElements().iterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Element curElement = (Element)iterator2.next();
            String string = curElement.getAttributeValue("id");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAttributeValue(...)");
            String string2 = curElement.getAttributeValue("href");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeValue(...)");
            String string3 = curElement.getAttributeValue("media-type");
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAttributeValue(...)");
            Intrinsics.checkNotNull((Object)curElement);
            entries.add(new ManifestEntry(string, string2, string3, curElement));
        }
        return entries;
    }

    @JvmStatic
    public static final boolean pathNotHiddenOrInHiddenDirectory(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.getFileName() == null) {
            return false;
        }
        Iterator<Path> iterator = path.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Path> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Path value = iterator2.next();
            String curPathPart = ((Object)value).toString();
            if (!StringsKt.startsWith$default((String)curPathPart, (String)".", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)curPathPart, (String)"_", (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private static final boolean findOPFFilesInFolder$lambda$0(Path obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return OPFUtils.pathNotHiddenOrInHiddenDirectory(obj) && StringsKt.endsWith$default((String)((Object)obj).toString(), (String)".opf", (boolean)false, (int)2, null);
    }

    private static final boolean findOPFFilesInFolder$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit findOPFFilesInFolder$lambda$2(Path curPAth) {
        Intrinsics.checkNotNullParameter((Object)curPAth, (String)"curPAth");
        log.trace("Found OPF at {}", (Object)curPAth.toUri());
        return Unit.INSTANCE;
    }

    private static final void findOPFFilesInFolder$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final boolean getDCElementValueCaseInsensitive$lambda$0(String $opfElemName, Element curElem) {
        Intrinsics.checkNotNullParameter((Object)curElem, (String)"curElem");
        return Intrinsics.areEqual((Object)curElem.getNamespacePrefix(), (Object)"dc") && StringsKt.equals((String)curElem.getLocalName(), (String)$opfElemName, (boolean)true);
    }

    static {
        Logger logger = LoggerFactory.getLogger(OPFUtils.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/brailleblaster/archiver2/OPFUtils$ManifestEntry;", "", "id", "", "href", "mimeType", "elem", "Lnu/xom/Element;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lnu/xom/Element;)V", "getId", "()Ljava/lang/String;", "getMimeType", "brailleblaster-core"})
    public static final class ManifestEntry {
        @NotNull
        private final String id;
        @JvmField
        @NotNull
        public final String href;
        @NotNull
        private final String mimeType;
        @JvmField
        @NotNull
        public final Element elem;

        public ManifestEntry(@NotNull String id, @NotNull String href, @NotNull String mimeType, @NotNull Element elem) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)href, (String)"href");
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Intrinsics.checkNotNullParameter((Object)elem, (String)"elem");
            this.id = id;
            this.href = href;
            this.mimeType = mimeType;
            this.elem = elem;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getMimeType() {
            return this.mimeType;
        }
    }
}

