/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.archiver2;

import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.BBIni;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\tH\u0007J\u0006\u0010\u0012\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tH\u0007J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/brailleblaster/archiver2/ZipHandles;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "HANDLES", "", "Ljava/nio/file/Path;", "Lorg/brailleblaster/archiver2/ZipHandles$Data;", "open", "Ljava/nio/file/FileSystem;", "rawPath", "create", "", "close", "", "closeAll", "has", "toRealPath", "newZipFileSystem", "zipFile", "pathToZipURI", "Ljava/net/URI;", "path", "Data", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nZipHandles.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipHandles.kt\norg/brailleblaster/archiver2/ZipHandles\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,170:1\n383#2,7:171\n1#3:178\n1915#4,2:179\n*S KotlinDebug\n*F\n+ 1 ZipHandles.kt\norg/brailleblaster/archiver2/ZipHandles\n*L\n70#1:171,7\n97#1:179,2\n*E\n"})
public final class ZipHandles {
    @NotNull
    public static final ZipHandles INSTANCE = new ZipHandles();
    private static final Logger log = LoggerFactory.getLogger(ZipHandles.class);
    @NotNull
    private static final Map<Path, Data> HANDLES = new HashMap();

    private ZipHandles() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final FileSystem open(@NotNull Path rawPath, boolean create) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        if (Files.exists(rawPath, new LinkOption[0]) && rawPath.toFile().length() == 0L) {
            try {
                Files.delete(rawPath);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to delete old empty file at " + rawPath, e);
            }
        }
        if (!Files.exists(rawPath, new LinkOption[0])) {
            Path zipTemplate = BBIni.getProgramDataPath().resolve("emptyZipTemplate.zip");
            if (!Files.exists(zipTemplate, new LinkOption[0])) {
                try {
                    Intrinsics.checkNotNull((Object)zipTemplate);
                    FileSystem templateFS = INSTANCE.newZipFileSystem(zipTemplate, true);
                    templateFS.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create " + zipTemplate, e);
                }
            }
            try {
                Files.copy(zipTemplate, rawPath, new CopyOption[0]);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create " + rawPath, ex);
            }
        }
        Path path = INSTANCE.toRealPath(rawPath);
        log.debug("Mapped {} to {}", (Object)rawPath, (Object)path);
        Map<Path, Data> e = HANDLES;
        Path key$iv = path;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Data answer$iv = new Data(INSTANCE.newZipFileSystem(path, create));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        Object v = object;
        Data $this$open_u24lambda_u241 = (Data)v;
        boolean bl = false;
        int n = $this$open_u24lambda_u241.getInstances();
        $this$open_u24lambda_u241.setInstances(n + 1);
        return ((Data)v).getFs();
    }

    @JvmStatic
    public static final void close(@NotNull Path rawPath) {
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        Path path = INSTANCE.toRealPath(rawPath);
        Data data = HANDLES.get(path);
        log.debug("closing {}", (Object)rawPath);
        if (data == null) {
            log.error("Cannot find file system for " + path);
            return;
        }
        if (data.getInstances() == 1) {
            HANDLES.remove(path);
            try {
                data.getFs().close();
            }
            catch (IOException ex) {
                throw new RuntimeException("Could not close FS " + data.getFs() + " for " + path, ex);
            }
        } else {
            Data data2 = data;
            int n = data2.getInstances();
            data2.setInstances(n + -1);
        }
    }

    public final void closeAll() {
        Iterable $this$forEach$iv = HANDLES.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Data data = (Data)element$iv;
            boolean bl = false;
            if (data == null) continue;
            try {
                data.getFs().close();
            }
            catch (IOException e) {
                log.warn("Exception whilst closing handle", (Throwable)e);
            }
        }
        HANDLES.clear();
    }

    @JvmStatic
    public static final boolean has(@NotNull Path rawPath) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)rawPath, (String)"rawPath");
        if (!Files.exists(rawPath, new LinkOption[0])) {
            if (!(!HANDLES.containsKey(rawPath))) {
                boolean $i$a$-check-ZipHandles$has$32 = false;
                String $i$a$-check-ZipHandles$has$32 = "File no longer exists " + rawPath;
                throw new IllegalStateException($i$a$-check-ZipHandles$has$32.toString());
            }
            if (!(!HANDLES.containsKey(rawPath.toAbsolutePath()))) {
                boolean bl2 = false;
                String string = "File no longer exists " + rawPath.toAbsolutePath();
                throw new IllegalStateException(string.toString());
            }
            bl = false;
        } else {
            Path path = INSTANCE.toRealPath(rawPath);
            bl = HANDLES.containsKey(path);
        }
        return bl;
    }

    private final Path toRealPath(Path rawPath) {
        Path path;
        try {
            path = rawPath.toRealPath(new LinkOption[0]);
            Intrinsics.checkNotNull((Object)path);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to resolve path " + rawPath, e);
        }
        return path;
    }

    private final FileSystem newZipFileSystem(Path zipFile, boolean create) {
        FileSystem fileSystem;
        try {
            BasicFileAttributes attrs = Files.readAttributes(zipFile, BasicFileAttributes.class, new LinkOption[0]);
            Object[] objectArray = new Object[]{zipFile, attrs.isRegularFile(), attrs.isSymbolicLink(), attrs.isDirectory(), attrs.isOther()};
            log.debug("Getting file system for {}, is regular file {} is symbolic link {}, is directory {}, is other {}", objectArray);
            Path realPath = Files.isSymbolicLink(zipFile) ? Files.readSymbolicLink(zipFile) : zipFile;
            Intrinsics.checkNotNull((Object)realPath);
            fileSystem = FileSystems.newFileSystem(this.pathToZipURI(realPath), MapsKt.mapOf((Pair)TuplesKt.to((Object)"create", (Object)String.valueOf(create))));
            Intrinsics.checkNotNull((Object)fileSystem);
        }
        catch (Throwable e) {
            for (Map.Entry<Path, Data> entry : HANDLES.entrySet()) {
                Path key = entry.getKey();
                Data value = entry.getValue();
                log.error("{} - {}", (Object)key, (Object)value);
            }
            throw new RuntimeException("Unable to make zip filesystem for " + zipFile + " create " + create, e);
        }
        return fileSystem;
    }

    private final URI pathToZipURI(Path path) {
        URI uRI;
        URI uri = path.toUri();
        try {
            uRI = new URI("jar:" + uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to make URI for " + path, e);
        }
        return uRI;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/archiver2/ZipHandles$Data;", "", "fs", "Ljava/nio/file/FileSystem;", "<init>", "(Ljava/nio/file/FileSystem;)V", "getFs", "()Ljava/nio/file/FileSystem;", "instances", "", "getInstances", "()I", "setInstances", "(I)V", "brailleblaster-core"})
    private static final class Data {
        @NotNull
        private final FileSystem fs;
        private int instances;

        public Data(@NotNull FileSystem fs) {
            Intrinsics.checkNotNullParameter((Object)fs, (String)"fs");
            this.fs = fs;
        }

        @NotNull
        public final FileSystem getFs() {
            return this.fs;
        }

        public final int getInstances() {
            return this.instances;
        }

        public final void setInstances(int n) {
            this.instances = n;
        }
    }
}

