/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import kotlin.sequences.Sequence;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.XPathContext;
import org.apache.commons.lang3.StringUtils;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.bbx.IllegalBBXException;
import org.brailleblaster.bbx.parsers.ImportParserUtils;
import org.brailleblaster.math.numberLine.NumberLine;
import org.brailleblaster.math.numberLine.NumberLineConstants;
import org.brailleblaster.math.numberLine.NumberLineJson;
import org.brailleblaster.math.spatial.ConnectingContainer;
import org.brailleblaster.math.spatial.ConnectingContainerJson;
import org.brailleblaster.math.spatial.Grid;
import org.brailleblaster.math.spatial.GridJson;
import org.brailleblaster.math.spatial.GsonInterfaceAdapter;
import org.brailleblaster.math.spatial.ISpatialMathContainerJson;
import org.brailleblaster.math.spatial.Matrix;
import org.brailleblaster.math.spatial.MatrixConstants;
import org.brailleblaster.math.spatial.MatrixJson;
import org.brailleblaster.math.spatial.SpatialMathEnum;
import org.brailleblaster.math.template.Template;
import org.brailleblaster.math.template.TemplateJson;
import org.brailleblaster.utd.config.StyleDefinitions;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.FastXPath;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utd.properties.EmphasisType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BBX {
    private static final Logger log = LoggerFactory.getLogger(BBX.class);
    public static final String BB_PREFIX = "bb";
    public static final String DOCUMENT_ROOT_NAME = "bbdoc";
    public static final int FORMAT_VERSION = 6;
    public static final EnumAttribute<FixerTodo> _ATTRIB_FIXER_TODO = new EnumAttribute<FixerTodo>("fixerTodo", FixerTodo.class);
    public static final StringAttribute _ATTRIB_ORIGINAL_ELEMENT = new StringAttribute("origElement");
    public static final StringAttribute _ATTRIB_OVERRIDE_ACTION = new StringAttribute("overrideAction", "utd", "http://brailleblaster.org/ns/utd");
    public static final StringAttribute _ATTRIB_OVERRIDE_STYLE = new StringAttribute("overrideStyle", "utd", "http://brailleblaster.org/ns/utd");
    public static final StringAttribute _ATTRIB_TYPE = new StringAttribute("type");
    public static final XPathContext XPATH_CONTEXT = new XPathContext();
    public static final SectionElement SECTION;
    public static final ContainerElement CONTAINER;
    public static final BlockElement BLOCK;
    public static final InlineElement INLINE;
    public static final SpanElement SPAN;
    public static final List<@NotNull CoreType> CORE_TYPES;

    private BBX() {
    }

    public static Element newElement(String name) {
        return new Element(name, "http://brailleblaster.org/ns/bb");
    }

    public static Document newDocument() {
        Element root = BBX.newElement(DOCUMENT_ROOT_NAME);
        root.addNamespaceDeclaration(BB_PREFIX, "http://brailleblaster.org/ns/bb");
        root.addNamespaceDeclaration("utd", "http://brailleblaster.org/ns/utd");
        root.addNamespaceDeclaration("m", "http://www.w3.org/1998/Math/MathML");
        Element headElem = BBX.newElement("head");
        root.appendChild((Node)headElem);
        Document doc = new Document(root);
        BBX.setFormatVersion(doc, 6);
        return doc;
    }

    public static Element getHead(Document doc) {
        Element head = doc.getRootElement().getFirstChildElement("head", "http://brailleblaster.org/ns/bb");
        if (head == null) {
            head = new Element("head", "http://brailleblaster.org/ns/bb");
            doc.getRootElement().insertChild((Node)head, 0);
        }
        return head;
    }

    public static int getFormatVersion(Document doc) {
        Element head = BBX.getHead(doc);
        Element versionElem = head.getFirstChildElement("version", "http://brailleblaster.org/ns/bb");
        if (versionElem == null) {
            throw new NodeException("No bb version attribute found", (Node)head);
        }
        return Integer.parseInt(versionElem.getValue());
    }

    public static void setFormatVersion(Document doc, int version) {
        Element head = BBX.getHead(doc);
        Element versionElem = head.getFirstChildElement("version", "http://brailleblaster.org/ns/bb");
        if (versionElem == null) {
            versionElem = new Element("version", "http://brailleblaster.org/ns/bb");
            head.appendChild((Node)versionElem);
        }
        versionElem.removeChildren();
        versionElem.appendChild(String.valueOf(version));
    }

    public static void assertIsA(Document doc) {
        BBX.getFormatVersion(doc);
        BBX.getRoot(doc);
    }

    public static void assertAttachedToDocument(Node node) {
        BBX.CONTAINER.VOLUME.assertIsA(node);
        if (node.getDocument() == null) {
            throw new NodeException("Node not attached to document", node);
        }
    }

    @NotNull
    public static Element getRoot(@NotNull Document doc) {
        if (doc.getRootElement().getChildElements().size() != 2) {
            throw new NodeException("Root should have both <head> and <section bb:type='ROOT'>", (Node)doc.getRootElement());
        }
        Element root = doc.getRootElement().getChildElements().get(1);
        BBX.SECTION.ROOT.assertIsA((Node)root);
        return root;
    }

    public static void transform(@NotNull Element elem, @NotNull SubType destType) {
        elem.setLocalName(destType.coreType.name);
        _ATTRIB_TYPE.set(elem, destType.name);
    }

    public static boolean isBlockOrChild(Node node) {
        return BLOCK.isA(node) || SPAN.isA(node) || INLINE.isA(node);
    }

    public static CoreType getType(Element elem) {
        CoreType result = BBX.getTypeOrNull(elem);
        if (result == null) {
            throw new NodeException("No coreType found for element", (Node)elem);
        }
        return result;
    }

    public static CoreType getTypeOrNull(Element elem) {
        for (CoreType coreType : CORE_TYPES) {
            if (!coreType.name.equals(elem.getLocalName())) continue;
            return coreType;
        }
        return null;
    }

    public static boolean isA(Node node) {
        if (!(node instanceof Element)) {
            return false;
        }
        Element elem = (Element)node;
        return BBX.getTypeOrNull(elem) != null;
    }

    static {
        XPATH_CONTEXT.addNamespace(BB_PREFIX, "http://brailleblaster.org/ns/bb");
        XPATH_CONTEXT.addNamespace("utd", "http://brailleblaster.org/ns/utd");
        XPATH_CONTEXT.addNamespace("m", "http://www.w3.org/1998/Math/MathML");
        SECTION = new SectionElement();
        CONTAINER = new ContainerElement();
        BLOCK = new BlockElement();
        INLINE = new InlineElement();
        SPAN = new SpanElement();
        CORE_TYPES = List.of(SECTION, CONTAINER, BLOCK, INLINE, SPAN);
    }

    public static class ContainerElement
    extends CoreType {
        public final ListSubType LIST = new ListSubType(this, "LIST");
        public final ContainerSubType DONT_SPLIT = new ContainerSubType(this, "DONT_SPLIT");
        public final ContainerSubType TABLE = new ContainerSubType(this, this, "TABLE"){};
        public final TableRowSubType TABLE_ROW = new TableRowSubType(this, "TABLE_ROW");
        public final ContainerSubType TABLETN = new ContainerSubType(this, "TABLETN");
        public final ContainerSubType DOUBLE_SPACE = new ContainerSubType(this, "DOUBLE_SPACE");
        public final ContainerSubType BOX = new ContainerSubType(this, "BOX");
        public final ImageSubType IMAGE = new ImageSubType(this, "IMAGE");
        public final ContainerSubType PRODNOTE = new ContainerSubType(this, "PRODNOTE");
        public final ContainerSubType NOTE = new ContainerSubType(this, "NOTE");
        public final ContainerSubType PROSE = new ContainerSubType(this, "PROSE");
        public final StyleSubType STYLE = new StyleSubType(this, "STYLE");
        public final ContainerSubType TPAGE = new ContainerSubType(this, "TPAGE");
        public final TPageSectionSubType TPAGE_SECTION = new TPageSectionSubType(this, "TPAGE_SECTION");
        public final TPageCategorySubType TPAGE_CATEGORY = new TPageCategorySubType(this, "TPAGE_CATEGORY");
        public final ContainerSubType VOLUME_TOC = new ContainerSubType(this, "VOLUME_TOC");
        public final VolumeSubType VOLUME = new VolumeSubType(this, "VOLUME");
        public final ContainerSubType FALLBACK = new ContainerSubType(this, "FALLBACK");
        public final ContainerSubType OTHER = new ContainerSubType(this, "OTHER");
        public final ContainerSubType CAPTION = new ContainerSubType(this, "CAPTION");
        public final ContainerSubType BLOCKQUOTE = new ContainerSubType(this, "BLOCKQUOTE");
        public final ContainerSubType DEFAULT = new ContainerSubType(this, "DEFAULT");
        public final NumberLineContainerSubType NUMBER_LINE = new NumberLineContainerSubType(this, "NUMBER_LINE");
        public final MatrixContainerSubType MATRIX = new MatrixContainerSubType(this, "MATRIX");
        public final TemplateContainerSubType TEMPLATE = new TemplateContainerSubType(this, "TEMPLATE");
        public final SpatialGridContainerSubType SPATIAL_GRID = new SpatialGridContainerSubType(this, "SPATIAL_GRID");
        public final ConnectingContainerSubType CONNECTING_CONTAINER = new ConnectingContainerSubType(this, "CONNECTING_CONTAINER");

        private ContainerElement() {
            super("CONTAINER", false);
            this.subTypes = List.of(this.LIST, this.DONT_SPLIT, this.TABLE, this.TABLE_ROW, this.TABLETN, this.DOUBLE_SPACE, this.BOX, this.IMAGE, this.PRODNOTE, this.NOTE, this.PROSE, this.STYLE, this.TPAGE, this.TPAGE_SECTION, this.TPAGE_CATEGORY, this.VOLUME_TOC, this.VOLUME, this.FALLBACK, this.OTHER, this.CAPTION, this.BLOCKQUOTE, this.DEFAULT, this.NUMBER_LINE, this.MATRIX, this.TEMPLATE, this.SPATIAL_GRID, this.CONNECTING_CONTAINER);
        }

        @Override
        public boolean isValidChild(CoreType child) {
            return child == CONTAINER || child == BLOCK;
        }

        public static class ListSubType
        extends ContainerSubType {
            public final IntAttribute ATTRIB_LIST_LEVEL = new IntAttribute("listLevel");
            public final EnumAttribute<ListType> ATTRIB_LIST_TYPE = new EnumAttribute<ListType>("listType", ListType.class);

            private ListSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new RuntimeException("Call other create method instead");
            }

            public Element create(ListType type) {
                Element elem = super.create();
                this.ATTRIB_LIST_TYPE.set(elem, type);
                return elem;
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                super.assertComplete(node, styleDefs2);
                this.ATTRIB_LIST_TYPE.has((Node)node);
                ListSubType.validateChildrenOnlyListItems(node, styleDefs2);
            }

            private static void validateChildrenOnlyListItems(Element elem, StyleDefinitions styleDefs2) {
                if (!BookToBBXConverter.STRICT_MODE) {
                    return;
                }
                for (Element curChildElement : elem.getChildElements()) {
                    CoreType type = BBX.getType(curChildElement);
                    if (type == BLOCK) {
                        if (BBX.BLOCK.LIST_ITEM.isA((Node)curChildElement) || _ATTRIB_OVERRIDE_STYLE.has((Node)curChildElement)) continue;
                        throw new NodeException("unhandled: not a list item, no style", (Node)curChildElement);
                    }
                    if (type != CONTAINER || !BookToBBXConverter.STRICT_MODE || BBX.CONTAINER.IMAGE.isA((Node)curChildElement) || BBX.CONTAINER.TABLE.isA((Node)curChildElement) || BBX.CONTAINER.BOX.isA((Node)curChildElement) || ListType.POEM_LINE_GROUP.isA((Node)curChildElement) || BBX.CONTAINER.FALLBACK.isA((Node)curChildElement) || BBX.SPAN.FALLBACK.isA((Node)curChildElement)) continue;
                    log.debug("Test {}", (Object)ListType.POEM_LINE_GROUP.validate((Node)curChildElement));
                    throw new NodeException("unhandled list child", (Node)curChildElement);
                }
            }
        }

        public static class TableRowSubType
        extends ContainerSubType {
            public final EnumAttribute<TableRowType> ATTRIB_ROW_TYPE = new EnumAttribute<TableRowType>("rowType", TableRowType.class);

            private TableRowSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new UnsupportedOperationException("Use other create method");
            }

            public Element create(TableRowType rowType) {
                Element elem = super.create();
                this.ATTRIB_ROW_TYPE.set(elem, rowType);
                return elem;
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                BBX.CONTAINER.TABLE.assertIsA((Node)node.getParent());
            }
        }

        public static class ImageSubType
        extends ContainerSubType {
            public final IntAttribute ATTRIB_GROUP_ID = new IntAttribute("groupId");

            private ImageSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }
        }

        public static class StyleSubType
        extends ContainerSubType {
            private StyleSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new UnsupportedOperationException("Use other create method");
            }

            public Element create(String styleName) {
                Element elem = super.create();
                _ATTRIB_OVERRIDE_STYLE.set(elem, styleName);
                return elem;
            }

            @Override
            protected String subValidate(Element elem) {
                if (StringUtils.isBlank((CharSequence)((CharSequence)_ATTRIB_OVERRIDE_STYLE.get(elem)))) {
                    return "Missing overrideStyle attrib";
                }
                return null;
            }
        }

        public static class TPageSectionSubType
        extends ContainerSubType {
            public final EnumAttribute<TPageSection> ATTRIB_TYPE = new EnumAttribute<TPageSection>("tpageType", TPageSection.class);

            private TPageSectionSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new RuntimeException("Use other create method");
            }

            public Element create(TPageSection sectionType) {
                Element elem = super.create();
                this.ATTRIB_TYPE.set(elem, sectionType);
                return elem;
            }
        }

        public static class TPageCategorySubType
        extends ContainerSubType {
            public final EnumAttribute<TPageCategory> ATTRIB_TYPE = new EnumAttribute<TPageCategory>("category", TPageCategory.class);

            private TPageCategorySubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new RuntimeException("Use other create method");
            }

            public Element create(TPageCategory category) {
                Element elem = super.create();
                this.ATTRIB_TYPE.set(elem, category);
                return elem;
            }
        }

        public static class VolumeSubType
        extends ContainerSubType {
            public final EnumAttribute<VolumeType> ATTRIB_TYPE = new EnumAttribute<VolumeType>("volumeType", VolumeType.class);
            public final BooleanAttribute ATTRIB_FIRST_VOLUME = new BooleanAttribute("firstVolume");

            private VolumeSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new RuntimeException("Use other create method");
            }

            public Element create(VolumeType volumeType) {
                Element elem = super.create();
                this.ATTRIB_TYPE.set(elem, volumeType);
                return elem;
            }
        }

        public static class NumberLineContainerSubType
        extends ContainerSubType {
            public final JsonAttribute<NumberLineJson> JSON_NUMBER_LINE = new JsonAttribute("JSON_NUMBER_LINE", NumberLineJson.class);
            public final EnumAttribute<SpatialMathEnum.Fill> ATTRIB_SEGMENT_FILL_START = new EnumAttribute<SpatialMathEnum.Fill>(NumberLineConstants.ATTRIB_SEGMENT_FILL_START, SpatialMathEnum.Fill.class);
            public final EnumAttribute<SpatialMathEnum.Fill> ATTRIB_SEGMENT_FILL_END = new EnumAttribute<SpatialMathEnum.Fill>(NumberLineConstants.ATTRIB_SEGMENT_FILL_START, SpatialMathEnum.Fill.class);
            public final EnumAttribute<SpatialMathEnum.Fill> ATTRIB_LINE_FILL_START = new EnumAttribute<SpatialMathEnum.Fill>(NumberLineConstants.ATTRIB_SEGMENT_FILL_START, SpatialMathEnum.Fill.class);
            public final EnumAttribute<SpatialMathEnum.Fill> ATTRIB_LINE_FILL_END = new EnumAttribute<SpatialMathEnum.Fill>(NumberLineConstants.ATTRIB_SEGMENT_FILL_START, SpatialMathEnum.Fill.class);
            public final EnumAttribute<SpatialMathEnum.IntervalType> ATTRIB_INTERVAL_TYPE = new EnumAttribute<SpatialMathEnum.IntervalType>("intervalType", SpatialMathEnum.IntervalType.class);
            public final BooleanAttribute ATTRIB_HAS_SEGMENT = new BooleanAttribute(NumberLineConstants.ATTRIB_HAS_SEGMENT);
            public final BooleanAttribute ATTRIB_ARROW = new BooleanAttribute(NumberLineConstants.ATTRIB_ARROW);
            public final BooleanAttribute ATTRIB_STRETCH = new BooleanAttribute(NumberLineConstants.ATTRIB_STRETCH);
            public final BooleanAttribute ATTRIB_REDUCE_FRACTION = new BooleanAttribute("reduceFraction");
            public final BooleanAttribute ATTRIB_LEADING_ZEROS = new BooleanAttribute(NumberLineConstants.ATTRIB_LEADING_ZEROS);
            public final StringAttribute ATTRIB_SEGMENT_START_WHOLE = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_START_WHOLE);
            public final StringAttribute ATTRIB_SEGMENT_END_WHOLE = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_END_WHOLE);
            public final StringAttribute ATTRIB_LINE_START_WHOLE = new StringAttribute(NumberLineConstants.ATTRIB_LINE_START_WHOLE);
            public final StringAttribute ATTRIB_LINE_END_WHOLE = new StringAttribute(NumberLineConstants.ATTRIB_LINE_END_WHOLE);
            public final StringAttribute ATTRIB_INTERVAL_WHOLE = new StringAttribute("interval");
            public final StringAttribute ATTRIB_INTERVAL_NUMERATOR = new StringAttribute("intervalNumerator");
            public final StringAttribute ATTRIB_INTERVAL_DENOMINATOR = new StringAttribute("intervalDenominator");
            public final StringAttribute ATTRIB_SEGMENT_START_NUMERATOR = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_START_NUMERATOR);
            public final StringAttribute ATTRIB_SEGMENT_START_DENOMINATOR = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_START_DENOMINATOR);
            public final StringAttribute ATTRIB_SEGMENT_END_NUMERATOR = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_END_NUMERATOR);
            public final StringAttribute ATTRIB_SEGMENT_END_DENOMINATOR = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_END_DENOMINATOR);
            public final StringAttribute ATTRIB_LINE_START_NUMERATOR = new StringAttribute(NumberLineConstants.ATTRIB_LINE_START_NUMERATOR);
            public final StringAttribute ATTRIB_LINE_START_DENOMINATOR = new StringAttribute(NumberLineConstants.ATTRIB_LINE_START_DENOMINATOR);
            public final StringAttribute ATTRIB_LINE_END_NUMERATOR = new StringAttribute(NumberLineConstants.ATTRIB_LINE_END_NUMERATOR);
            public final StringAttribute ATTRIB_LINE_END_DENOMINATOR = new StringAttribute(NumberLineConstants.ATTRIB_LINE_END_DENOMINATOR);
            public final StringAttribute ATTRIB_SEGMENT_START_DECIMAL = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_START_DECIMAL);
            public final StringAttribute ATTRIB_SEGMENT_END_DECIMAL = new StringAttribute(NumberLineConstants.ATTRIB_SEGMENT_END_DECIMAL);
            public final StringAttribute ATTRIB_LINE_START_DECIMAL = new StringAttribute(NumberLineConstants.ATTRIB_LINE_START_DECIMAL);
            public final StringAttribute ATTRIB_LINE_END_DECIMAL = new StringAttribute(NumberLineConstants.ATTRIB_LINE_END_DECIMAL);
            public final StringAttribute ATTRIB_INTERVAL_DECIMAL = new StringAttribute("intervalDecimal");
            public final EnumAttribute<SpatialMathEnum.Passage> NUMERIC_PASSAGE = new EnumAttribute<SpatialMathEnum.Passage>("numericPassage", SpatialMathEnum.Passage.class);
            public final EnumAttribute<SpatialMathEnum.NumberLineType> NUMBER_LINE_TYPE = new EnumAttribute<SpatialMathEnum.NumberLineType>("numberLineType", SpatialMathEnum.NumberLineType.class);
            public final EnumAttribute<SpatialMathEnum.Translation> USER_DEFINED_TRANSLATION = new EnumAttribute<SpatialMathEnum.Translation>("userDefinedTranslation", SpatialMathEnum.Translation.class);
            public final StringArrayAttribute USER_DEFINED_SEGMENTS = new StringArrayAttribute("userDefinedSegments");
            public final StringAttribute ATTRIB_VERSION = new StringAttribute("version");

            private NumberLineContainerSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new UnsupportedOperationException("Use other create method");
            }

            public Element create(NumberLine numberLine) {
                Element elem = super.create();
                String version = "2";
                this.JSON_NUMBER_LINE.set(elem, numberLine.getJson());
                this.ATTRIB_VERSION.set(elem, version);
                return elem;
            }
        }

        public static class MatrixContainerSubType
        extends ContainerSubType {
            public final JsonAttribute<MatrixJson> JSON_MATRIX = new JsonAttribute("JSON_MATRIX", MatrixJson.class);
            public final StringAttribute ATTRIB_VERSION = new StringAttribute("version");
            public final IntAttribute ROWS = new IntAttribute("row");
            public final IntAttribute COLS = new IntAttribute("col");
            public final EnumAttribute<MatrixConstants.Wide> WIDE_TYPE = new EnumAttribute<MatrixConstants.Wide>("wideType", MatrixConstants.Wide.class);
            public final EnumAttribute<MatrixConstants.BracketType> BRACKET = new EnumAttribute<MatrixConstants.BracketType>("bracketType", MatrixConstants.BracketType.class);
            public final StringArrayAttribute ASCII_MATH = new StringArrayAttribute("asciiMath");
            public final StringArrayAttribute ELLIPSES_ARRAY = new StringArrayAttribute("ellipsesArray");
            public final EnumAttribute<SpatialMathEnum.Passage> NUMERIC_PASSAGE = new EnumAttribute<SpatialMathEnum.Passage>("numericPassage", SpatialMathEnum.Passage.class);
            public final EnumAttribute<SpatialMathEnum.Translation> MATRIX_TRANSLATION = new EnumAttribute<SpatialMathEnum.Translation>("matrixTranslation", SpatialMathEnum.Translation.class);

            private MatrixContainerSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                return super.create();
            }

            public Element create(Matrix matrix) {
                Element elem = super.create();
                this.JSON_MATRIX.set(elem, (MatrixJson)matrix.getJson());
                String version = "2";
                this.ATTRIB_VERSION.set(elem, version);
                return elem;
            }
        }

        public static class TemplateContainerSubType
        extends ContainerSubType {
            public final JsonAttribute<TemplateJson> JSON_TEMPLATE = new JsonAttribute("JSON_TEMPLATE", TemplateJson.class);
            public final BooleanAttribute STRAIGHT_RADICAL = new BooleanAttribute("straightRadical");
            public final EnumAttribute<SpatialMathEnum.OPERATOR> OPERATOR = new EnumAttribute<SpatialMathEnum.OPERATOR>("operator", SpatialMathEnum.OPERATOR.class);
            public final EnumAttribute<SpatialMathEnum.TemplateType> TYPE = new EnumAttribute<SpatialMathEnum.TemplateType>("templateType", SpatialMathEnum.TemplateType.class);
            public final StringArrayAttribute OPERANDS = new StringArrayAttribute("operands");
            public final StringArrayAttribute SOLUTIONS = new StringArrayAttribute("solutions");
            public final EnumAttribute<SpatialMathEnum.Passage> PASSAGE_MODE = new EnumAttribute<SpatialMathEnum.Passage>("passageMode", SpatialMathEnum.Passage.class);
            public final StringAttribute IDENTIFIER = new StringAttribute("identifier");
            public final BooleanAttribute IDENTIFER_AS_MATH = new BooleanAttribute("mathIdentifier");
            public final BooleanAttribute LINEAR = new BooleanAttribute("linear");
            public final BooleanAttribute NEMETH = new BooleanAttribute("nemeth");
            public final StringAttribute ATTRIB_VERSION = new StringAttribute("version");

            private TemplateContainerSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                return super.create();
            }

            public Element create(Template template) {
                Element elem = super.create();
                String version = "2";
                this.JSON_TEMPLATE.set(elem, (TemplateJson)template.getJson());
                this.ATTRIB_VERSION.set(elem, version);
                return elem;
            }
        }

        public static class SpatialGridContainerSubType
        extends ContainerSubType {
            final Gson gson = new GsonBuilder().registerTypeAdapter(ISpatialMathContainerJson.class, new GsonInterfaceAdapter()).create();
            public final JsonAttribute<GridJson> JSON_GRID = new JsonAttribute("JSON_GRID", GridJson.class, this.gson);
            public final StringAttribute ATTRIB_VERSION = new StringAttribute("version");
            public final IntAttribute ROWS = new IntAttribute("rows");
            public final IntAttribute COLS = new IntAttribute("cols");
            public final XMLAttribute GRID = new XMLAttribute("grid");

            private SpatialGridContainerSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                return super.create();
            }

            public Element create(Grid grid) {
                Element elem = super.create();
                this.JSON_GRID.set(elem, (GridJson)grid.getJson());
                String version = "2";
                this.ATTRIB_VERSION.set(elem, version);
                return elem;
            }
        }

        public static class ConnectingContainerSubType
        extends ContainerSubType {
            public final JsonAttribute<ConnectingContainerJson> JSON_CONNECTING_CONTAINER = new JsonAttribute("JSON_CONNECTING_CONTAINER", ConnectingContainerJson.class);
            public final StringAttribute ATTRIB_VERSION = new StringAttribute("version");
            public final StringAttribute TEXT = new StringAttribute("text");
            public final BooleanAttribute IS_MATH = new BooleanAttribute("isMath");
            public final EnumAttribute<SpatialMathEnum.VerticalJustify> VERTICAL = new EnumAttribute<SpatialMathEnum.VerticalJustify>("vertical", SpatialMathEnum.VerticalJustify.class);
            public final EnumAttribute<SpatialMathEnum.HorizontalJustify> HORIZONTAL = new EnumAttribute<SpatialMathEnum.HorizontalJustify>("horizontal", SpatialMathEnum.HorizontalJustify.class);

            private ConnectingContainerSubType(ContainerElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                return super.create();
            }

            public Element create(ConnectingContainer container) {
                Element elem = super.create();
                this.JSON_CONNECTING_CONTAINER.set(elem, (ConnectingContainerJson)container.getJson());
                String version = "2";
                this.ATTRIB_VERSION.set(elem, version);
                return elem;
            }
        }
    }

    public static class SectionElement
    extends CoreType {
        public final SectionSubType ROOT = new SectionSubType(this, "ROOT");
        public final SectionSubType OTHER = new SectionSubType(this, "OTHER");

        private SectionElement() {
            super("SECTION", false);
            this.subTypes = List.of(this.ROOT, this.OTHER);
        }

        @Override
        public boolean isValidChild(CoreType child) {
            return child == SECTION || child == CONTAINER || child == BLOCK;
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static class SectionSubType
    extends SubType {
        private SectionSubType(SectionElement coreType, String name) {
            super(coreType, name);
        }

        private static class TypeAdapter
        extends JAXBSubTypeAdapter<SectionSubType> {
            public TypeAdapter() {
                super(SECTION);
            }
        }
    }

    public static abstract class SubType
    implements NodeValidator {
        public final CoreType coreType;
        public final String name;

        public SubType(CoreType coreType, String name) {
            if (coreType == null) {
                throw new NullPointerException("coreType");
            }
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.coreType = coreType;
            this.name = name;
        }

        public Element create() {
            return this.coreType.create(this);
        }

        public void set(Element container) {
            this.coreType.assertIsA((Node)container);
            _ATTRIB_TYPE.set(container, this.name);
        }

        @Override
        public boolean isA(Node node) {
            return this.coreType.isA(node) && this.name.equals(_ATTRIB_TYPE.get((Element)node));
        }

        @Override
        public final String validate(Node node) {
            String blockValid = this.coreType.validate(node);
            if (blockValid != null) {
                return blockValid;
            }
            String nodeType = (String)_ATTRIB_TYPE.get((Element)node);
            if (nodeType == null) {
                return "missing attribute bb:type";
            }
            if (!nodeType.equals(this.name)) {
                return "unexpected bb:type of " + nodeType + " expected " + this.name;
            }
            return this.subValidate((Element)node);
        }

        protected String subValidate(Element elem) {
            return null;
        }

        public String toString() {
            return this.getClass().getName() + "{coreType=" + String.valueOf(this.coreType) + ", name=" + this.name + "}";
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static abstract class CoreType
    implements NodeValidator {
        public final String name;
        public final boolean textChildrenValid;
        protected List<@NotNull SubType> subTypes;

        public CoreType(String name, boolean textChildrenValid) {
            if (StringUtils.isBlank((CharSequence)name)) {
                throw new IllegalArgumentException("name is blank");
            }
            this.name = name;
            this.textChildrenValid = textChildrenValid;
        }

        public abstract boolean isValidChild(CoreType var1);

        public SubType getSubType(Node sectionNode) {
            this.assertIsA(sectionNode);
            String subtypeName = (String)_ATTRIB_TYPE.get((Element)sectionNode);
            for (SubType subType : this.subTypes) {
                if (!subType.name.equals(subtypeName)) continue;
                return subType;
            }
            throw new NodeException("Missing subtype " + subtypeName + " for", sectionNode);
        }

        public List<@NotNull SubType> getSubTypes() {
            return this.subTypes;
        }

        @Override
        public final String validate(Node node) {
            if (node == null) {
                throw new NullPointerException("node");
            }
            if (!(node instanceof Element)) {
                return "Expected element";
            }
            Element element = (Element)node;
            if (!"http://brailleblaster.org/ns/bb".equals(element.getNamespaceURI())) {
                return "Not in BB namespace";
            }
            if (!this.name.equals(element.getLocalName())) {
                return "Expected element name " + this.name;
            }
            return null;
        }

        public Element create(SubType subType) {
            if (subType.coreType != this) {
                throw new IllegalArgumentException("Unexpected subType " + String.valueOf(subType));
            }
            Element elem = BBX.newElement(this.name);
            subType.set(elem);
            return elem;
        }

        public String toString() {
            return this.getClass().getName() + "{name=" + this.name + "}";
        }

        public static class TypeAdapter
        extends XmlAdapter<String, CoreType> {
            public String marshal(CoreType v) {
                return v.name;
            }

            public CoreType unmarshal(String v) {
                for (CoreType curCoreType : CORE_TYPES) {
                    if (!curCoreType.name.equals(v)) continue;
                    return curCoreType;
                }
                throw new RuntimeException("Cannot find type for " + v);
            }
        }
    }

    public static class StringAttribute
    extends BaseAttribute<String> {
        public StringAttribute(String name) {
            super(name);
        }

        public StringAttribute(String name, String nsPrefix, String nsUrl) {
            super(name, nsPrefix, nsUrl);
        }

        @Override
        protected String marshall(String input) {
            return input;
        }

        @Override
        protected String unmarshall(String input) {
            return input;
        }
    }

    public static class BlockElement
    extends CoreType {
        public final ListItemSubType LIST_ITEM = new ListItemSubType(this);
        public final BooleanAttribute ATTRIB_BLANKDOC_PLACEHOLDER = new BooleanAttribute("blankDocPlaceholder");
        public final StringAttribute LINKID = new StringAttribute("linkID");
        public final BlockSubType TABLE_CELL = new BlockSubType(this, this, "TABLE_CELL"){

            @Override
            protected String subValidate(Element elem) {
                if (_ATTRIB_OVERRIDE_STYLE.has((Node)elem)) {
                    return "Unexpected override style attrib, should not exist as table formatter ignores them";
                }
                return null;
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                if (!BBX.CONTAINER.TABLE_ROW.isA((Node)node.getParent())) {
                    throw new NodeException("Unexpected parent of table cell", (Node)node);
                }
            }
        };
        public final MarginSubType MARGIN = new MarginSubType(this);
        public final BlockSubType VOLUME_END = new BlockSubType(this, "VOLUME_END");
        public final BlockSubType TOC_VOLUME_SPLIT = new BlockSubType(this, "TOC_VOLUME_SPLIT");
        public final PageNumBlockSubType PAGE_NUM = new PageNumBlockSubType(this, "PAGE_NUM");
        public final ImagePlaceholderType IMAGE_PLACEHOLDER = new ImagePlaceholderType(this, "IMAGE_PLACEHOLDER");
        public final BlockSubType DEFAULT = new BlockSubType(this, "DEFAULT");
        public final StyleSubType STYLE = new StyleSubType(this, "STYLE");
        public final SpatialMathSubType SPATIAL_MATH = new SpatialMathSubType(this, "SPATIAL_MATH");

        private BlockElement() {
            super("BLOCK", true);
            this.subTypes = List.of(this.LIST_ITEM, this.TABLE_CELL, this.MARGIN, this.VOLUME_END, this.TOC_VOLUME_SPLIT, this.PAGE_NUM, this.IMAGE_PLACEHOLDER, this.DEFAULT, this.STYLE, this.SPATIAL_MATH);
        }

        @Override
        public boolean isValidChild(CoreType child) {
            return child == INLINE || child == SPAN;
        }

        public static class ListItemSubType
        extends BlockSubType {
            public final IntAttribute ATTRIB_ITEM_LEVEL = new IntAttribute("itemLevel");

            private ListItemSubType(BlockElement type) {
                super(type, "LIST_ITEM");
            }

            @Override
            public Element create() {
                Element elem = super.create();
                this.ATTRIB_ITEM_LEVEL.set(elem, 0);
                return elem;
            }

            @Override
            protected String subValidate(Element elem) {
                if (!this.ATTRIB_ITEM_LEVEL.has((Node)elem)) {
                    return "Missing itemLevel attrib";
                }
                return null;
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                int itemLevel;
                int listLevel;
                super.assertComplete(node, styleDefs2);
                Element parentList = XMLHandler.Companion.ancestorVisitorElement((Node)node, BBX.CONTAINER.LIST::isA);
                if (parentList == null) {
                    throw new NodeException("List item not under list", (Node)node);
                }
                if (ListType.POEM_LINE_GROUP.isA((Node)parentList)) {
                    Element poemWrapper = XMLHandler.Companion.ancestorVisitorElement((Node)parentList.getParent(), ListType.POEM::isA);
                    if (poemWrapper != null) {
                        parentList = poemWrapper;
                    }
                }
                if ((listLevel = ((Integer)BBX.CONTAINER.LIST.ATTRIB_LIST_LEVEL.get(parentList)).intValue()) < (itemLevel = ((Integer)this.ATTRIB_ITEM_LEVEL.get(node)).intValue())) {
                    throw new NodeException("Size of list item " + itemLevel + " is greater than parent list " + listLevel, (Node)node);
                }
            }
        }

        public static class MarginSubType
        extends BlockSubType {
            public final IntAttribute ATTRIB_INDENT = new IntAttribute("marginIndent");
            public final IntAttribute ATTRIB_RUNOVER = new IntAttribute("marginRunover");
            public final EnumAttribute<MarginType> ATTRIB_MARGIN_TYPE = new EnumAttribute<MarginType>("marginType", MarginType.class);

            private MarginSubType(BlockElement type) {
                super(type, "MARGIN");
            }

            @Override
            protected String subValidate(Element elem) {
                if (!this.ATTRIB_INDENT.has((Node)elem)) {
                    return "No marginIndent attribute";
                }
                if (!this.ATTRIB_RUNOVER.has((Node)elem)) {
                    return "No marginRunover attribute";
                }
                return null;
            }
        }

        public static class PageNumBlockSubType
        extends BlockSubType {
            private PageNumBlockSubType(BlockElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            public boolean isA(Node node) {
                return super.isA(node);
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                super.assertComplete(node, styleDefs2);
            }

            @Override
            public void assertIsA(Node node) throws IllegalBBXException {
                super.assertIsA(node);
            }
        }

        public static class ImagePlaceholderType
        extends BlockSubType {
            public final IntAttribute ATTRIB_SKIP_LINES = new IntAttribute("skipLines", "utd", "http://brailleblaster.org/ns/utd");
            public final StringAttribute ATTRIB_IMG_PATH = new StringAttribute("src", "utd", "http://brailleblaster.org/ns/utd");

            private ImagePlaceholderType(BlockElement coreType, String name) {
                super(coreType, name);
            }
        }

        public static class StyleSubType
        extends BlockSubType {
            private StyleSubType(BlockElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            @Deprecated
            public Element create() {
                throw new UnsupportedOperationException("Use other create method");
            }

            public Element create(String styleName) {
                Element elem = super.create();
                _ATTRIB_OVERRIDE_STYLE.set(elem, styleName);
                return elem;
            }

            @Override
            protected String subValidate(Element elem) {
                if (_ATTRIB_OVERRIDE_STYLE.has((Node)elem) && StringUtils.isNotBlank((CharSequence)((CharSequence)_ATTRIB_OVERRIDE_STYLE.get(elem)))) {
                    return null;
                }
                return "Missing overrideStyle attrib";
            }
        }

        public static class SpatialMathSubType
        extends BlockSubType {
            private SpatialMathSubType(BlockElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            public Element create() {
                Element elem = super.create();
                _ATTRIB_OVERRIDE_STYLE.set(elem, "Spatial Math");
                return elem;
            }
        }
    }

    public static class SpanElement
    extends CoreType {
        public final ImageSubType IMAGE = new ImageSubType(this, "IMAGE");
        public final PageNumSpanSubType PAGE_NUM = new PageNumSpanSubType(this, "PAGE_NUM");
        public final SpanSubType SUPERSCRIPT = new SpanSubType(this, "SUPERSCRIPT");
        public final SpanSubType POEM_LINE_NUMBER = new SpanSubType(this, "POEM_LINE_NUMBER");
        public final SpanSubType PROSE_LINE_NUMBER = new SpanSubType(this, "PROSE_LINE_NUMBER");
        public final SpanSubType DEFINITION_TERM = new SpanSubType(this, this, "DEFINITION_TERM"){};
        public final TabSpanSubType TAB = new TabSpanSubType(this, "TAB");
        public final SpanSubType FALLBACK = new SpanSubType(this, "FALLBACK");
        public final SpanSubType NOTEREF = new SpanSubType(this, "NOTEREF");
        public final SpanSubType GUIDEWORD = new SpanSubType(this, "GUIDEWORD");
        public final SpanSubType OTHER = new SpanSubType(this, "OTHER");

        private SpanElement() {
            super("SPAN", true);
            this.subTypes = List.of(this.IMAGE, this.PAGE_NUM, this.SUPERSCRIPT, this.POEM_LINE_NUMBER, this.PROSE_LINE_NUMBER, this.DEFINITION_TERM, this.TAB, this.FALLBACK, this.NOTEREF, this.GUIDEWORD, this.OTHER);
        }

        @Override
        public boolean isValidChild(CoreType child) {
            return child == SPAN || child == INLINE;
        }

        public static class ImageSubType
        extends SpanSubType {
            public final StringAttribute ATTRIB_SOURCE = new StringAttribute("source");

            private ImageSubType(SpanElement coreType, String name) {
                super(coreType, name);
            }
        }

        public static class PageNumSpanSubType
        extends SpanSubType {
            private PageNumSpanSubType(SpanElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            public boolean isA(Node node) {
                return super.isA(node);
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                super.assertComplete(node, styleDefs2);
            }

            @Override
            public void assertIsA(Node node) throws IllegalBBXException {
                super.assertIsA(node);
            }
        }

        public static class TabSpanSubType
        extends SpanSubType {
            public final IntAttribute ATTRIB_VALUE = new IntAttribute("tabValue", null, null);

            private TabSpanSubType(SpanElement coreType, String name) {
                super(coreType, name);
            }

            @Override
            protected String subValidate(Element elem) {
                if (elem.getChildCount() != 0) {
                    return "tab is supposed to be empty";
                }
                return null;
            }
        }
    }

    public static class InlineElement
    extends CoreType {
        public final EmphasisSubType EMPHASIS = new EmphasisSubType(this);
        public final MathSubType MATHML = new MathSubType(this);
        public final LinkSubType LINK = new LinkSubType(this);
        public final InlineSubType LINE_BREAK = new InlineSubType(this, "LINE_BREAK");

        private InlineElement() {
            super("INLINE", true);
            this.subTypes = List.of(this.EMPHASIS, this.MATHML, this.LINE_BREAK, this.LINK);
        }

        @Override
        public boolean isValidChild(CoreType child) {
            return child == INLINE;
        }

        public static class EmphasisSubType
        extends InlineSubType {
            public final EnumSetAttribute<EmphasisType> ATTRIB_EMPHASIS = new EnumSetAttribute<EmphasisType>("emphasis", EmphasisType.class);

            private EmphasisSubType(InlineElement coreType) {
                super(coreType, "EMPHASIS");
            }

            @Override
            protected String subValidate(Element elem) {
                this.ATTRIB_EMPHASIS.get(elem);
                return null;
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                if (((EnumSet)this.ATTRIB_EMPHASIS.get(node)).isEmpty()) {
                    throw new NodeException("Missing emphasis bits", (Node)node);
                }
            }

            @Override
            @Deprecated
            public Element create() {
                throw new RuntimeException("don't use me");
            }

            public Element create(EnumSet<EmphasisType> emphasisBits) {
                Element create = super.create();
                this.ATTRIB_EMPHASIS.set(create, emphasisBits);
                return create;
            }

            public Element create(EmphasisType ... emphasisBits) {
                return this.create(EnumSet.copyOf(Arrays.asList(emphasisBits)));
            }
        }

        public static class MathSubType
        extends InlineSubType {
            private MathSubType(InlineElement coreType) {
                super(coreType, "MATHML");
            }

            @Override
            public void assertComplete(Element node, StyleDefinitions styleDefs2) {
                if (node.getChildCount() != 1) {
                    throw new NodeException("MATHML container can only contain <m:math> tag", (Node)node);
                }
                Element mathTag = node.getChildElements().get(0);
                if (!mathTag.getLocalName().equals("math")) {
                    throw new NodeException("Expected only container child to be math, got ", (Node)mathTag);
                }
                List<Element> nonMathMl = StreamSupport.stream(((Iterable)() -> ((Sequence)FastXPath.descendant((Node)node)).iterator()).spliterator(), false).filter(n -> n instanceof Element).map(n -> (Element)n).filter(e -> !e.getNamespaceURI().equals("http://www.w3.org/1998/Math/MathML")).toList();
                if (!nonMathMl.isEmpty()) {
                    throw new NodeException("Unexpected non-mathml elements " + StringUtils.join(nonMathMl, (String)", "), (Node)node);
                }
            }
        }

        public static class LinkSubType
        extends InlineSubType {
            public final StringAttribute ATTRIB_HREF = new StringAttribute("href");
            public final BooleanAttribute IS_EXTERNAL = new BooleanAttribute("external");

            private LinkSubType(InlineElement coreType) {
                super(coreType, "LINK");
            }

            @Override
            protected String subValidate(Element elem) {
                if (this.ATTRIB_HREF.has((Node)elem) && this.IS_EXTERNAL.has((Node)elem)) {
                    return null;
                }
                return "Link must have href and external attributes";
            }
        }
    }

    public static class EnumAttribute<E extends Enum<E>>
    extends BaseAttribute<E> {
        private final Class<E> enumClazz;

        public EnumAttribute(String name, Class<E> enumClazz) {
            super(name);
            this.enumClazz = enumClazz;
        }

        @Override
        protected String marshall(E input) {
            return ((Enum)input).name();
        }

        @Override
        protected E unmarshall(String input) {
            return Enum.valueOf(this.enumClazz, input);
        }

        public void assertAndDetach(E expected, Element elem) {
            Enum actual = (Enum)this.get(elem);
            if (actual != expected) {
                throw new RuntimeException("Expected " + String.valueOf(expected) + " got " + String.valueOf(actual));
            }
            this.detach(elem);
        }
    }

    public static enum FixerTodo {
        LINE_BREAK,
        TABLE_GROUP_UNWRAP,
        TABLE_SIZE,
        TABLE_CELL_REAL,
        CONTAINER_STYLE_TO_BLOCK,
        CONVERT_IMAGE_GROUP;

    }

    private static abstract class JAXBSubTypeAdapter<S extends SubType>
    extends XmlAdapter<String, S> {
        private final CoreType coreType;

        public JAXBSubTypeAdapter(CoreType coreType) {
            if (coreType == null) {
                throw new NullPointerException("coreType");
            }
            this.coreType = coreType;
        }

        public String marshal(S v) {
            return ((SubType)v).name;
        }

        public S unmarshal(String v) {
            for (SubType curSubType : this.coreType.subTypes) {
                if (!v.equals(curSubType.name)) continue;
                return (S)curSubType;
            }
            throw new RuntimeException("Cannot find subtype " + v + " in " + String.valueOf(this.coreType));
        }
    }

    public static class BooleanAttribute
    extends BaseAttribute<Boolean> {
        public BooleanAttribute(String name) {
            super(name);
        }

        @Override
        protected String marshall(Boolean input) {
            return input != false ? "true" : "false";
        }

        @Override
        protected Boolean unmarshall(String input) {
            return input.equals("true");
        }
    }

    public static class StringArrayAttribute
    extends BaseAttribute<ArrayList<String>> {
        public StringArrayAttribute(String name) {
            super(name);
        }

        @Override
        protected ArrayList<String> unmarshall(String input) {
            try {
                ArrayList<String> array = new ArrayList<String>();
                while (!input.isEmpty()) {
                    int metadataLength = 0;
                    char digitsCodePoint = input.charAt(metadataLength);
                    String digitsString = String.valueOf(digitsCodePoint);
                    int digitsInt = Integer.parseInt(digitsString);
                    int numChars = Integer.parseInt(input.substring(metadataLength += digitsString.length(), metadataLength + digitsInt));
                    array.add(input.substring(metadataLength += String.valueOf(numChars).length(), metadataLength + numChars));
                    input = input.substring(metadataLength + numChars);
                }
                return array;
            }
            catch (IndexOutOfBoundsException e) {
                log.error("String array attribute formatting issue, iob exception");
                return new ArrayList<String>();
            }
            catch (NumberFormatException e) {
                log.error("String array attribute formatting issue, number format exception");
                return new ArrayList<String>();
            }
        }

        @Override
        protected String marshall(ArrayList<String> input) {
            StringBuilder s = new StringBuilder();
            for (String string : input) {
                int numChars = string.length();
                String sizeString = String.valueOf(numChars);
                int digitLength = sizeString.length();
                Matrix.matrixLog("StringBuilder digits {} length {} and string {}" + digitLength + sizeString + string);
                s.append(digitLength).append(sizeString).append(string);
            }
            return s.toString();
        }
    }

    public static class XMLAttribute
    extends BaseAttribute<Node> {
        public XMLAttribute(String name) {
            super(name);
        }

        @Override
        protected String marshall(Node node) {
            return node.toXML();
        }

        @Override
        protected Node unmarshall(String input) {
            Builder parser = new Builder();
            try {
                Document doc = parser.build(input, null);
                return doc.getRootElement();
            }
            catch (IOException | ParsingException e) {
                log.warn("Problem when parsing XML", e);
                throw new RuntimeException("Error parsing XML Attribute " + input);
            }
        }
    }

    public static class JsonAttribute<T>
    extends BaseAttribute<Object> {
        private final Object jsonClass;
        private Gson gson;

        public JsonAttribute(String name, Object jsonClass) {
            super(name);
            this.jsonClass = jsonClass;
        }

        public JsonAttribute(String name, Object jsonClass, Gson gson) {
            super(name);
            this.jsonClass = jsonClass;
            this.gson = gson;
        }

        @Override
        protected Object unmarshall(String input) {
            if (this.gson == null) {
                this.gson = new Gson();
            }
            return this.gson.fromJson(input, (Class)this.jsonClass);
        }

        @Override
        protected String marshall(Object input) {
            if (this.gson == null) {
                this.gson = new Gson();
            }
            return this.gson.toJson(input);
        }
    }

    public static class EnumSetAttribute<E extends Enum<E>>
    extends BaseAttribute<EnumSet<E>> {
        private final Class<E> enumClazz;

        public EnumSetAttribute(String name, Class<E> enumClazz) {
            super(name);
            this.enumClazz = enumClazz;
        }

        @Override
        protected String marshall(EnumSet<E> input) {
            return input.stream().map(Enum::name).collect(Collectors.joining(" "));
        }

        @Override
        protected EnumSet<E> unmarshall(String input) {
            EnumSet<E> set = EnumSet.noneOf(this.enumClazz);
            for (String curEntry : StringUtils.split((String)input, (char)' ')) {
                set.add(Enum.valueOf(this.enumClazz, curEntry));
            }
            return set;
        }
    }

    public static class IntAttribute
    extends BaseAttribute<Integer> {
        public IntAttribute(String name) {
            super(name);
        }

        public IntAttribute(String name, String nsPrefix, String nsUrl) {
            super(name, nsPrefix, nsUrl);
        }

        @Override
        protected String marshall(Integer input) {
            return input.toString();
        }

        @Override
        protected Integer unmarshall(String input) {
            return Integer.parseInt(input);
        }
    }

    public static abstract class BaseAttribute<T> {
        public final String name;
        public final String nsPrefix;
        public final String nsUrl;

        public BaseAttribute(String name) {
            this.name = name;
            this.nsPrefix = BBX.BB_PREFIX;
            this.nsUrl = "http://brailleblaster.org/ns/bb";
        }

        public BaseAttribute(String name, String nsPrefix, String nsUrl) {
            this.name = name;
            this.nsPrefix = nsPrefix;
            this.nsUrl = nsUrl;
        }

        public Attribute getAttribute(Element element) {
            if (element == null) {
                throw new NullPointerException("element");
            }
            if (this.isNotNamespaced()) {
                return element.getAttribute(this.name);
            }
            return element.getAttribute(this.name, this.nsUrl);
        }

        public T get(Element elem) {
            return this.getOptional(elem).orElseThrow(() -> new NodeException("Cannot find attribute " + this.name, (Node)elem));
        }

        public Optional<T> getOptional(Element elem) {
            Attribute attribute = this.getAttribute(elem);
            if (attribute == null) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.unmarshall(attribute.getValue()));
        }

        public Attribute newAttribute(T value) {
            if (this.isNotNamespaced()) {
                return new Attribute(this.name, this.marshall(value));
            }
            return new Attribute(this.nsPrefix + ":" + this.name, this.nsUrl, this.marshall(value));
        }

        public void set(Element elem, T value) {
            elem.addAttribute(this.newAttribute(value));
        }

        public boolean has(Node node) {
            Element elem = ImportParserUtils.failIfNotElement(node);
            return this.getAttribute(elem) != null;
        }

        public void set(Element elem, T onMissingValue, Function<T, T> onUpdate) {
            if (this.has((Node)elem)) {
                this.set(elem, onUpdate.apply(this.get(elem)));
            } else {
                this.set(elem, onMissingValue);
            }
        }

        public void set(Element elem, Function<T, T> onUpdate) {
            if (!this.has((Node)elem)) {
                throw new NodeException("Missing attribute " + String.valueOf(elem), (Node)elem);
            }
            this.set(elem, onUpdate.apply(this.get(elem)));
        }

        public Attribute detach(Element elem) {
            Attribute attribute = this.getAttribute(elem);
            if (attribute == null) {
                throw new NodeException("Cannot find attribute " + this.name, (Node)elem);
            }
            attribute.detach();
            return attribute;
        }

        private boolean isNotNamespaced() {
            return this.nsPrefix == null && this.nsUrl == null;
        }

        protected abstract String marshall(T var1);

        protected abstract T unmarshall(String var1);
    }

    public static interface NodeValidator {
        @Nullable
        public String validate(Node var1);

        default public void assertIsA(Node node) throws IllegalBBXException {
            String validateResult = this.validate(node);
            if (validateResult != null) {
                throw new IllegalBBXException(node, validateResult);
            }
        }

        default public boolean isA(Node node) {
            return this.validate(node) == null;
        }

        default public void assertComplete(Element node, StyleDefinitions styleDefs2) {
            this.assertIsA((Node)node);
        }
    }

    public static enum PreFormatterMarker {
        LIST_SPLIT;

        public static final EnumAttribute<PreFormatterMarker> ATTRIB_PRE_FORMATTER_MARKER;

        public boolean has(Node node) {
            if (!ATTRIB_PRE_FORMATTER_MARKER.has(node)) {
                return false;
            }
            return ATTRIB_PRE_FORMATTER_MARKER.get((Element)node) == this;
        }

        static {
            ATTRIB_PRE_FORMATTER_MARKER = new EnumAttribute<PreFormatterMarker>("preFormatterMarker", PreFormatterMarker.class);
        }
    }

    public static enum FixerMarker {
        DEFINITION_LINE_BREAK_SPLIT;

        public static final EnumAttribute<FixerMarker> ATTRIB_FIXER_MARKER;

        public boolean has(Node node) {
            if (!ATTRIB_FIXER_MARKER.has(node)) {
                return false;
            }
            return ATTRIB_FIXER_MARKER.get((Element)node) == this;
        }

        static {
            ATTRIB_FIXER_MARKER = new EnumAttribute<FixerMarker>("fixerMarker", FixerMarker.class);
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static class SpanSubType
    extends SubType {
        private SpanSubType(SpanElement coreType, String name) {
            super(coreType, name);
        }

        private static class TypeAdapter
        extends JAXBSubTypeAdapter<SpanSubType> {
            public TypeAdapter() {
                super(SPAN);
            }
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static class InlineSubType
    extends SubType {
        private InlineSubType(InlineElement coreType, String name) {
            super(coreType, name);
        }

        private static class TypeAdapter
        extends JAXBSubTypeAdapter<InlineSubType> {
            public TypeAdapter() {
                super(INLINE);
            }
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static class BlockSubType
    extends SubType {
        public final StringAttribute linkID = new StringAttribute("linkID");

        private BlockSubType(BlockElement coreType, String name) {
            super(coreType, name);
        }

        private static class TypeAdapter
        extends JAXBSubTypeAdapter<BlockSubType> {
            public TypeAdapter() {
                super(BLOCK);
            }
        }
    }

    public static enum VolumeType {
        VOLUME_PRELIMINARY("Preliminary Volume", "Preliminary", "Preliminary"),
        VOLUME("Volume", "Volume", "Normal"),
        VOLUME_SUPPLEMENTAL("Supplemental Volume", "Supplemental", "Supplemental");

        public final String volumeName;
        public final String volumeNameShort;
        public final String volumeMenuName;

        private VolumeType(String volumeName, String volumeNameShort, String volumeMenuName) {
            this.volumeName = volumeName;
            this.volumeNameShort = volumeNameShort;
            this.volumeMenuName = volumeMenuName;
        }
    }

    public static enum TPageCategory {
        TITLE,
        AUTHOR,
        PUBLISHER,
        TRANSCRIPTION,
        VOLUMES;

    }

    public static enum TPageSection {
        TITLE_PAGE,
        SECOND_TITLE_PAGE,
        SPECIAL_SYMBOLS,
        TRANSCRIBER_NOTES;

    }

    public static enum TableRowType {
        NORMAL,
        HEAD,
        FOOT;

    }

    public static enum MarginType {
        TOC("T"),
        EXERCISE("E"),
        INDEX("I"),
        NUMERIC("");

        public final String styleNamePrefix;

        private MarginType(String styleNamePrefix) {
            this.styleNamePrefix = styleNamePrefix;
        }
    }

    public static enum ListType implements NodeValidator
    {
        NORMAL("L"),
        DEFINITION("G"),
        POEM("P"),
        POEM_LINE_GROUP("P");

        public final String styleNamePrefix;

        private ListType(String stylePrefix) {
            this.styleNamePrefix = stylePrefix;
        }

        @Override
        public String validate(Node node) {
            String isList = BBX.CONTAINER.LIST.validate(node);
            if (isList != null) {
                return isList;
            }
            ListType listType = (ListType)BBX.CONTAINER.LIST.ATTRIB_LIST_TYPE.get((Element)node);
            return listType == this ? null : "listType is " + String.valueOf(listType) + " not " + String.valueOf(this);
        }
    }

    @XmlJavaTypeAdapter(value=TypeAdapter.class)
    public static class ContainerSubType
    extends SubType {
        private ContainerSubType(ContainerElement coreType, String name) {
            super(coreType, name);
        }

        private static class TypeAdapter
        extends JAXBSubTypeAdapter<ContainerSubType> {
            public TypeAdapter() {
                super(CONTAINER);
            }
        }
    }
}

