/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import nu.xom.Document;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.brailleblaster.Main;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.util.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0007\u00a2\u0006\u0002\u0010\fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/bbx/BenchAllNimas;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "main", "", "args", "", "", "([Ljava/lang/String;)V", "Exec", "brailleblaster-core"})
public final class BenchAllNimas {
    @NotNull
    public static final BenchAllNimas INSTANCE = new BenchAllNimas();
    private static final Logger log = LoggerFactory.getLogger(BenchAllNimas.class);

    private BenchAllNimas() {
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) throws Exception {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Main.initBB$default(Main.INSTANCE, ArraysKt.asList((Object[])args), false, 2, null);
        Path booksPath = Paths.get(args[0], new String[0]);
        if (!Files.exists(booksPath, new LinkOption[0])) {
            if (args.length != 1) {
                System.err.println(BenchAllNimas.class.getName() + " <path to nimas-books folder on stevie>");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            booksPath = Paths.get(args[0], new String[0]);
            if (!Files.exists(booksPath, new LinkOption[0])) {
                System.err.println("Given path " + booksPath + " does not exist");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
        }
        ExecutorService threadPool = Executors.newFixedThreadPool(Integer.parseInt(args[1]), new ThreadFactoryBuilder().setDaemon(true).build());
        BookToBBXConverter converter = BookToBBXConverter.Companion.fromConfig$default(BookToBBXConverter.Companion, null, 1, null);
        List tasks = Files.list(booksPath).filter(arg_0 -> BenchAllNimas.main$lambda$1(BenchAllNimas::main$lambda$0, arg_0)).map(arg_0 -> BenchAllNimas.main$lambda$3(arg_0 -> BenchAllNimas.main$lambda$2(converter, arg_0), arg_0)).collect(Collectors.toList());
        long startTime = System.currentTimeMillis();
        List results = new ArrayList();
        Iterator iterator = ((Iterable)threadPool.invokeAll(tasks)).iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            Future curFuture = (Future)iterator.next();
            Pair fut = (Pair)curFuture.get();
            log.debug("{}/{} completed", (Object)index, (Object)tasks.size());
            Intrinsics.checkNotNull((Object)fut);
            results.add(fut);
        }
        log.error("------------ finished -------------");
        int exceptions = 0;
        for (Pair pair : results) {
            Path key = (Path)pair.component1();
            Exception value = (Exception)pair.component2();
            log.error("Book " + key + (String)(value != null ? " exception " + ExceptionUtils.getStackTrace((Throwable)value) : "no exception"));
            if (value == null) continue;
            ++exceptions;
        }
        log.error("{}/{} books have exceptions", (Object)exceptions, (Object)results.size());
        log.error("ran in " + Utils.runtimeToString(startTime));
    }

    private static final boolean main$lambda$0(Path curFile) {
        Intrinsics.checkNotNullParameter((Object)curFile, (String)"curFile");
        return StringsKt.endsWith$default((String)((Object)curFile).toString(), (String)".xml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)((Object)curFile).toString(), (String)".zip", (boolean)false, (int)2, null);
    }

    private static final boolean main$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Exec main$lambda$2(BookToBBXConverter $converter, Path curFile) {
        Intrinsics.checkNotNullParameter((Object)curFile, (String)"curFile");
        return new Exec(curFile, $converter);
    }

    private static final Exec main$lambda$3(Function1 $tmp0, Object p0) {
        return (Exec)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00050\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001c\u0010\u000b\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00050\u0002H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/bbx/BenchAllNimas$Exec;", "Ljava/util/concurrent/Callable;", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "path", "converter", "Lorg/brailleblaster/bbx/BookToBBXConverter;", "<init>", "(Ljava/nio/file/Path;Lorg/brailleblaster/bbx/BookToBBXConverter;)V", "call", "brailleblaster-core"})
    private static final class Exec
    implements Callable<Pair<? extends Path, ? extends Exception>> {
        @NotNull
        private final Path path;
        @NotNull
        private final BookToBBXConverter converter;

        public Exec(@NotNull Path path, @NotNull BookToBBXConverter converter) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)converter, (String)"converter");
            this.path = path;
            this.converter = converter;
        }

        @Override
        @NotNull
        public Pair<Path, Exception> call() throws Exception {
            Pair pair;
            try {
                Document load = new XMLHandler().load(this.path);
                this.converter.convert(load, ((Object)this.path).toString());
                pair = TuplesKt.to((Object)this.path, null);
            }
            catch (Exception e) {
                pair = TuplesKt.to((Object)this.path, (Object)e);
            }
            return pair;
        }
    }
}

