/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.fixers.to3;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.ParentNode;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.fixers.AbstractFixer;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.internal.xml.XMLHandler;
import org.brailleblaster.utils.xom.NodeUtilsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/ImageBlockToContainerImportFixer;", "Lorg/brailleblaster/bbx/fixers/AbstractFixer;", "<init>", "()V", "fix", "", "matchedNode", "Lnu/xom/Node;", "Companion", "brailleblaster-core"})
public final class ImageBlockToContainerImportFixer
extends AbstractFixer {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void fix(@NotNull Node matchedNode) {
        Intrinsics.checkNotNullParameter((Object)matchedNode, (String)"matchedNode");
        BBX.SPAN.IMAGE.assertIsA(matchedNode);
        Companion.convertImageBlockToContainer((Element)matchedNode);
    }

    @JvmStatic
    public static final void convertImageBlockToContainer(@NotNull Element imgElem) {
        Companion.convertImageBlockToContainer(imgElem);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/bbx/fixers/to3/ImageBlockToContainerImportFixer$Companion;", "", "<init>", "()V", "convertImageBlockToContainer", "", "imgElem", "Lnu/xom/Element;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void convertImageBlockToContainer(@NotNull Element imgElem) {
            Intrinsics.checkNotNullParameter((Object)imgElem, (String)"imgElem");
            if (!BBX.SPAN.IMAGE.isA((Node)imgElem) && !BBX.CONTAINER.IMAGE.isA((Node)imgElem)) {
                throw new NodeException("Not an image", (Node)imgElem, null, 4, null);
            }
            Element element = XMLHandler.Companion.ancestorVisitorElement((Node)imgElem, Companion::convertImageBlockToContainer$lambda$0);
            if (element == null) {
                boolean bl = false;
                String string = "Cannot find a parent block";
                throw new IllegalArgumentException(string.toString());
            }
            Element parentBlock = element;
            if (BBX.SPAN.IMAGE.isA((Node)imgElem) && imgElem.getChildCount() != 0) {
                Element wrappingBlock = BBX.BLOCK.DEFAULT.create();
                for (Node curChild : NodeUtilsKt.getChildNodes((ParentNode)((ParentNode)imgElem))) {
                    curChild.detach();
                    wrappingBlock.appendChild(curChild);
                }
                imgElem.appendChild((Node)wrappingBlock);
            }
            BBX.transform(imgElem, BBX.CONTAINER.IMAGE);
            imgElem.detach();
            parentBlock.getParent().replaceChild((Node)parentBlock, (Node)imgElem);
        }

        private static final boolean convertImageBlockToContainer$lambda$0(Element node) {
            return BBX.BLOCK.isA((Node)node);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

