/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.parsers;

import jakarta.xml.bind.Unmarshaller;
import jakarta.xml.bind.annotation.XmlAttribute;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import nu.xom.Element;
import nu.xom.Node;
import org.brailleblaster.bbx.AbstractBBXUtil;
import org.brailleblaster.bbx.BBX;
import org.brailleblaster.bbx.BookToBBXConverter;
import org.brailleblaster.bbx.parsers.ImportParser;
import org.brailleblaster.bbx.parsers.ImportParserUtils;
import org.brailleblaster.utd.exceptions.NodeException;
import org.brailleblaster.utd.properties.EmphasisType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0012\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u001b\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\u0003\u0010\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u0010\u0010\u0005\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/brailleblaster/bbx/parsers/BBXImportParser;", "Lorg/brailleblaster/bbx/AbstractBBXUtil;", "Lorg/brailleblaster/bbx/parsers/ImportParser;", "<init>", "()V", "noChildrenValid", "", "styleName", "", "(ZLjava/lang/String;)V", "parseToBBX", "Lorg/brailleblaster/bbx/parsers/ImportParser$OldDocumentAction;", "oldNode", "Lnu/xom/Node;", "bbxCursor", "Lnu/xom/Element;", "afterUnmarshal", "", "unmarshaller", "Ljakarta/xml/bind/Unmarshaller;", "parent", "", "brailleblaster-core"})
public final class BBXImportParser
extends AbstractBBXUtil
implements ImportParser {
    @XmlAttribute
    private final boolean noChildrenValid;
    @XmlAttribute
    @Nullable
    private final String styleName;

    private BBXImportParser() {
        this.noChildrenValid = false;
        this.styleName = null;
    }

    public BBXImportParser(boolean noChildrenValid, @Nullable String styleName) {
        this.noChildrenValid = noChildrenValid;
        this.styleName = styleName;
    }

    @Override
    @NotNull
    public ImportParser.OldDocumentAction parseToBBX(@NotNull Node oldNode, @NotNull Element bbxCursor) {
        ImportParser.OldDocumentAction oldDocumentAction;
        Element element;
        Intrinsics.checkNotNullParameter((Object)oldNode, (String)"oldNode");
        Intrinsics.checkNotNullParameter((Object)bbxCursor, (String)"bbxCursor");
        Element oldElem = ImportParserUtils.failIfNotElement(oldNode);
        if (this.sectionType != null) {
            var5_4 = this.sectionType.create();
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.containerType != null) {
            var5_4 = this.styleName != null ? BBX.CONTAINER.STYLE.create(this.styleName) : this.containerType.create();
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.blockType != null) {
            var5_4 = this.styleName != null ? BBX.BLOCK.STYLE.create(this.styleName) : this.blockType.create();
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.spanType != null) {
            var5_4 = this.spanType.create();
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.inlineType != null) {
            var5_4 = this.inlineType.create();
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.listType != null) {
            var5_4 = BBX.CONTAINER.LIST.create(this.listType);
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.tableRowType != null) {
            var5_4 = BBX.CONTAINER.TABLE_ROW.create(this.tableRowType);
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else if (this.emphasisType != null) {
            EmphasisType[] emphasisTypeArray = new EmphasisType[]{this.emphasisType};
            var5_4 = BBX.INLINE.EMPHASIS.create(emphasisTypeArray);
            Intrinsics.checkNotNull((Object)var5_4);
            element = var5_4;
        } else {
            throw new RuntimeException("Unhandled: " + oldNode + " | bbxCursor: " + bbxCursor + " | this:" + this);
        }
        Element bbxElem = element;
        ImportParserUtils.initNewElementAttributes(oldElem, bbxElem);
        if (this.fixerTodo != null) {
            BBX._ATTRIB_FIXER_TODO.set(bbxElem, this.fixerTodo);
        }
        if (this.styleName != null) {
            BBX._ATTRIB_OVERRIDE_STYLE.set(bbxElem, this.styleName);
        }
        bbxCursor.appendChild((Node)bbxElem);
        if (oldElem.getChildCount() == 0) {
            if (this.noChildrenValid) {
                oldDocumentAction = ImportParser.OldDocumentAction.NEXT_SIBLING;
            } else {
                if (BookToBBXConverter.STRICT_MODE) {
                    throw new NodeException("No children", oldNode, null, 4, null);
                }
                oldDocumentAction = ImportParser.OldDocumentAction.NEXT_SIBLING;
            }
        } else {
            oldDocumentAction = ImportParser.OldDocumentAction.DESCEND;
        }
        return oldDocumentAction;
    }

    public final void afterUnmarshal(@Nullable Unmarshaller unmarshaller, @Nullable Object parent) {
        this.validateOnlyOneBBXFieldSet(new Object[0]);
        if (this.styleName != null && this.containerType != BBX.CONTAINER.STYLE && this.blockType != BBX.BLOCK.STYLE) {
            throw new RuntimeException("Unexpected styleName for non-style subtype: " + this);
        }
        if (this.containerType == BBX.CONTAINER.LIST) {
            throw new RuntimeException("containerType==LIST, must set explicit listType field instead");
        }
        if (this.containerType == BBX.CONTAINER.TABLE_ROW) {
            throw new RuntimeException("containerType==TABLE_ROW, must set explicit tableRowType field instead");
        }
    }
}

