/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.bbx.parsers;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.brailleblaster.bbx.parsers.ImportParser;
import org.brailleblaster.utd.NamespaceMap;
import org.brailleblaster.utd.NodeMatcherMap;
import org.brailleblaster.utd.config.UTDConfig;
import org.brailleblaster.utd.matchers.INodeMatcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u00072\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0003\u0005\u0006\u0007B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/brailleblaster/bbx/parsers/ImportParserMap;", "Lorg/brailleblaster/utd/NodeMatcherMap;", "Lorg/brailleblaster/bbx/parsers/ImportParser;", "<init>", "()V", "AdaptedParserMap", "ParserMapAdapter", "Companion", "brailleblaster-core"})
public final class ImportParserMap
extends NodeMatcherMap<ImportParser> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Logger log;
    @NotNull
    private static final JAXBContext JAXB_CONTEXT;

    public ImportParserMap() {
        super(null);
    }

    static {
        JAXBContext jAXBContext;
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(ImportParserMap.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
        try {
            Class[] classArray = new Class[]{AdaptedParserMap.class};
            jAXBContext = JAXBContext.newInstance((Class[])classArray);
            Intrinsics.checkNotNull((Object)jAXBContext);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to init JAXBContext", e);
        }
        JAXB_CONTEXT = jAXBContext;
    }

    @XmlType(propOrder={"namespaces", "semanticEntries"})
    @XmlRootElement(name="importParserMap")
    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0010B\u0019\b\u0007\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\"\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\u0006R\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/brailleblaster/bbx/parsers/ImportParserMap$AdaptedParserMap;", "", "semanticEntries", "", "Lorg/brailleblaster/bbx/parsers/ImportParserMap$AdaptedParserMap$Entry;", "<init>", "(Ljava/util/List;)V", "getSemanticEntries", "()Ljava/util/List;", "setSemanticEntries", "namespaces", "Lorg/brailleblaster/utd/NamespaceMap;", "getNamespaces", "()Lorg/brailleblaster/utd/NamespaceMap;", "setNamespaces", "(Lorg/brailleblaster/utd/NamespaceMap;)V", "Entry", "brailleblaster-core"})
    public static final class AdaptedParserMap {
        @NotNull
        private List<Entry> semanticEntries;
        @Nullable
        private NamespaceMap namespaces;

        @JvmOverloads
        public AdaptedParserMap(@NotNull List<Entry> semanticEntries) {
            Intrinsics.checkNotNullParameter(semanticEntries, (String)"semanticEntries");
            this.semanticEntries = semanticEntries;
        }

        public /* synthetic */ AdaptedParserMap(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(list);
        }

        @XmlElement(name="entry")
        @NotNull
        public final List<Entry> getSemanticEntries() {
            return this.semanticEntries;
        }

        public final void setSemanticEntries(@NotNull List<Entry> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.semanticEntries = list;
        }

        @Nullable
        public final NamespaceMap getNamespaces() {
            return this.namespaces;
        }

        public final void setNamespaces(@Nullable NamespaceMap namespaceMap) {
            this.namespaces = namespaceMap;
        }

        @JvmOverloads
        public AdaptedParserMap() {
            this(null, 1, null);
        }

        @XmlRootElement(name="entry")
        @XmlAccessorType(value=XmlAccessType.FIELD)
        @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0012\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\t\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0005R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/brailleblaster/bbx/parsers/ImportParserMap$AdaptedParserMap$Entry;", "", "matcher", "Lorg/brailleblaster/utd/matchers/INodeMatcher;", "parser", "Lorg/brailleblaster/bbx/parsers/ImportParser;", "<init>", "(Lorg/brailleblaster/utd/matchers/INodeMatcher;Lorg/brailleblaster/bbx/parsers/ImportParser;)V", "()V", "getMatcher", "getParser", "brailleblaster-core"})
        public static final class Entry {
            @XmlElement(name="matcher")
            @Nullable
            private final INodeMatcher matcher;
            @XmlElement(name="parser")
            @Nullable
            private final ImportParser parser;

            public Entry(@Nullable INodeMatcher matcher, @Nullable ImportParser parser) {
                this.matcher = matcher;
                this.parser = parser;
            }

            private Entry() {
                this(null, null);
            }

            @NotNull
            public final INodeMatcher getMatcher() {
                INodeMatcher iNodeMatcher = this.matcher;
                Intrinsics.checkNotNull((Object)iNodeMatcher);
                return iNodeMatcher;
            }

            @NotNull
            public final ImportParser getParser() {
                ImportParser importParser = this.parser;
                Intrinsics.checkNotNull((Object)importParser);
                return importParser;
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/brailleblaster/bbx/parsers/ImportParserMap$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "JAXB_CONTEXT", "Ljakarta/xml/bind/JAXBContext;", "load", "Lorg/brailleblaster/bbx/parsers/ImportParserMap;", "inputFile", "Ljava/io/File;", "brailleblaster-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImportParserMap load(@NotNull File inputFile) {
            Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
            log.debug("Loading parserMap from " + inputFile.getAbsolutePath());
            ParserMapAdapter adapter = new ParserMapAdapter();
            ImportParserMap importParserMap = adapter.unmarshal((AdaptedParserMap)UTDConfig.INSTANCE.loadJAXB(inputFile, AdaptedParserMap.class, JAXB_CONTEXT));
            Intrinsics.checkNotNull((Object)((Object)importParserMap));
            ImportParserMap map = importParserMap;
            if (log.isDebugEnabled()) {
                for (Map.Entry entry : ((Map)((Object)map)).entrySet()) {
                    INodeMatcher key = (INodeMatcher)entry.getKey();
                    ImportParser value = (ImportParser)entry.getValue();
                    log.debug("Entry {}\t{}", (Object)key, (Object)value);
                }
            }
            return map;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0016J\u0014\u0010\b\u001a\u0004\u0018\u00010\u00032\b\u0010\t\u001a\u0004\u0018\u00010\u0002H\u0016\u00a8\u0006\n"}, d2={"Lorg/brailleblaster/bbx/parsers/ImportParserMap$ParserMapAdapter;", "Ljakarta/xml/bind/annotation/adapters/XmlAdapter;", "Lorg/brailleblaster/bbx/parsers/ImportParserMap$AdaptedParserMap;", "Lorg/brailleblaster/bbx/parsers/ImportParserMap;", "<init>", "()V", "marshal", "actions", "unmarshal", "actionList", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nImportParserMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImportParserMap.kt\norg/brailleblaster/bbx/parsers/ImportParserMap$ParserMapAdapter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,116:1\n129#2:117\n158#2,3:118\n*S KotlinDebug\n*F\n+ 1 ImportParserMap.kt\norg/brailleblaster/bbx/parsers/ImportParserMap$ParserMapAdapter\n*L\n64#1:117\n64#1:118,3\n*E\n"})
    private static final class ParserMapAdapter
    extends XmlAdapter<AdaptedParserMap, ImportParserMap> {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public AdaptedParserMap marshal(@Nullable ImportParserMap actions) {
            AdaptedParserMap adaptedParserMap;
            if (actions == null) {
                adaptedParserMap = null;
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                AdaptedParserMap adaptedParserMap2;
                AdaptedParserMap $this$marshal_u24lambda_u240 = adaptedParserMap2 = new AdaptedParserMap(null, 1, null);
                boolean bl = false;
                Map map = (Map)((Object)actions);
                List<AdaptedParserMap.Entry> list = $this$marshal_u24lambda_u240.getSemanticEntries();
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    INodeMatcher matcher = (INodeMatcher)entry.getKey();
                    ImportParser parser = (ImportParser)entry.getValue();
                    if (parser == null) {
                        String string = "Required value was null.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    collection.add(new AdaptedParserMap.Entry(matcher, parser));
                }
                list.addAll((List)destination$iv$iv);
                $this$marshal_u24lambda_u240.setNamespaces(actions.getNamespaces());
                adaptedParserMap = adaptedParserMap2;
            }
            return adaptedParserMap;
        }

        @Nullable
        public ImportParserMap unmarshal(@Nullable AdaptedParserMap actionList) {
            if (actionList == null) {
                return null;
            }
            ImportParserMap actionMap2 = new ImportParserMap();
            NamespaceMap namespaceMap = actionList.getNamespaces();
            if (namespaceMap == null) {
                namespaceMap = new NamespaceMap();
            }
            actionMap2.setNamespaces(namespaceMap);
            Iterator iterator = ((Iterable)actionList.getSemanticEntries()).iterator();
            int n = 0;
            while (iterator.hasNext()) {
                int i = n++;
                AdaptedParserMap.Entry entry = (AdaptedParserMap.Entry)iterator.next();
                INodeMatcher matcher = entry.getMatcher();
                if (matcher == null) {
                    throw new NullPointerException("Unexpected null matcher for parser " + entry.getParser());
                }
                if (actionMap2.containsKey(matcher)) {
                    throw new RuntimeException("Detected duplicate matcher " + matcher + " entry " + entry.getParser());
                }
                if (entry.getParser() == null) {
                    throw new NullPointerException("Unexpected null parser for matcher " + matcher);
                }
                actionMap2.put(i, matcher, entry.getParser());
            }
            return actionMap2;
        }
    }
}

