/*
 * Decompiled with CFR 0.152.
 */
package org.brailleblaster.embossers;

import java.io.InputStream;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.brailleblaster.embossers.EmbosserConfigSerializer;
import org.brailleblaster.libembosser.EmbosserService;
import org.brailleblaster.libembosser.spi.EmbossException;
import org.brailleblaster.libembosser.spi.Embosser;
import org.brailleblaster.libembosser.spi.EmbossingAttributeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

@Serializable(with=EmbosserConfigSerializer.class)
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003J\u001a\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#J\"\u0010\u001f\u001a\u00020\u00162\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0019J\u001a\u0010%\u001a\u00020\u00162\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010#J\"\u0010%\u001a\u00020\u00162\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\b\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R(\u0010\u001a\u001a\u0004\u0018\u00010\u00192\b\u0010\u0018\u001a\u0004\u0018\u00010\u00198B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001e\u00a8\u0006)"}, d2={"Lorg/brailleblaster/embossers/EmbosserConfig;", "", "name", "", "printerName", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getPrinterName", "setPrinterName", "(Ljava/lang/String;)V", "embosserDriver", "Lorg/brailleblaster/libembosser/spi/Embosser;", "getEmbosserDriver", "()Lorg/brailleblaster/libembosser/spi/Embosser;", "setEmbosserDriver", "(Lorg/brailleblaster/libembosser/spi/Embosser;)V", "", "manufacturer", "model", "isActive", "", "()Z", "value", "Ljavax/print/PrintService;", "printService", "getPrintService", "()Ljavax/print/PrintService;", "setPrintService", "(Ljavax/print/PrintService;)V", "embossBrf", "inputStream", "Ljava/io/InputStream;", "attributes", "Lorg/brailleblaster/libembosser/spi/EmbossingAttributeSet;", "ps", "embossPef", "pef", "Lorg/w3c/dom/Document;", "Companion", "brailleblaster-core"})
@SourceDebugExtension(value={"SMAP\nEmbosserConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbosserConfig.kt\norg/brailleblaster/embossers/EmbosserConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class EmbosserConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @Nullable
    private String printerName;
    @Nullable
    private Embosser embosserDriver;
    private static final Logger logger = LoggerFactory.getLogger(EmbosserConfig.class);

    public EmbosserConfig(@NotNull String name, @Nullable String printerName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.printerName = printerName;
    }

    public /* synthetic */ EmbosserConfig(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Nullable
    public final String getPrinterName() {
        return this.printerName;
    }

    public final void setPrinterName(@Nullable String string) {
        this.printerName = string;
    }

    @Nullable
    public final Embosser getEmbosserDriver() {
        return this.embosserDriver;
    }

    public final void setEmbosserDriver(@Nullable Embosser embosser) {
        this.embosserDriver = embosser;
    }

    public final void setEmbosserDriver(@NotNull String manufacturer, @NotNull String model) {
        Intrinsics.checkNotNullParameter((Object)manufacturer, (String)"manufacturer");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.embosserDriver = EmbosserService.getInstance().getEmbosserStream().filter(arg_0 -> EmbosserConfig.setEmbosserDriver$lambda$1(arg_0 -> EmbosserConfig.setEmbosserDriver$lambda$0(manufacturer, model, arg_0), arg_0)).findFirst().orElse(null);
    }

    public final boolean isActive() {
        return this.getPrintService() != null && this.embosserDriver != null;
    }

    private final PrintService getPrintService() {
        return EmbosserConfig.Companion.getPrinterForName(this.printerName);
    }

    private final void setPrintService(PrintService value) {
        PrintService printService = value;
        this.printerName = printService != null ? printService.getName() : null;
    }

    public final boolean embossBrf(@Nullable InputStream inputStream, @Nullable EmbossingAttributeSet attributes) {
        boolean bl;
        PrintService p = this.getPrintService();
        if (p != null) {
            bl = this.embossBrf(inputStream, attributes, p);
        } else {
            logger.warn("Embosser device not available");
            bl = false;
        }
        return bl;
    }

    public final boolean embossBrf(@Nullable InputStream inputStream, @Nullable EmbossingAttributeSet attributes, @NotNull PrintService ps) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Embosser driver2 = this.embosserDriver;
        if (driver2 == null) {
            boolean $i$a$-requireNotNull-EmbosserConfig$embossBrf$22 = false;
            String $i$a$-requireNotNull-EmbosserConfig$embossBrf$22 = "Config must have an embosser driver set to be able to emboss";
            throw new IllegalArgumentException($i$a$-requireNotNull-EmbosserConfig$embossBrf$22.toString());
        }
        try {
            InputStream inputStream2 = inputStream;
            Intrinsics.checkNotNull((Object)inputStream2);
            EmbossingAttributeSet embossingAttributeSet = attributes;
            Intrinsics.checkNotNull((Object)embossingAttributeSet);
            driver2.embossBrf(ps, inputStream2, embossingAttributeSet);
        }
        catch (EmbossException e) {
            logger.warn("Unable to emboss", (Throwable)e);
            return false;
        }
        return true;
    }

    public final boolean embossPef(@Nullable Document pef, @Nullable EmbossingAttributeSet attributes) {
        boolean bl;
        PrintService p = this.getPrintService();
        if (p != null) {
            bl = this.embossPef(pef, attributes, p);
        } else {
            logger.warn("Embosser device not available");
            bl = false;
        }
        return bl;
    }

    public final boolean embossPef(@Nullable Document pef, @Nullable EmbossingAttributeSet attributes, @NotNull PrintService ps) {
        Intrinsics.checkNotNullParameter((Object)ps, (String)"ps");
        Embosser driver2 = this.embosserDriver;
        if (driver2 == null) {
            boolean $i$a$-requireNotNull-EmbosserConfig$embossPef$22 = false;
            String $i$a$-requireNotNull-EmbosserConfig$embossPef$22 = "Config must have an embosser driver set to be able to emboss";
            throw new IllegalArgumentException($i$a$-requireNotNull-EmbosserConfig$embossPef$22.toString());
        }
        try {
            Document document = pef;
            Intrinsics.checkNotNull((Object)document);
            EmbossingAttributeSet embossingAttributeSet = attributes;
            Intrinsics.checkNotNull((Object)embossingAttributeSet);
            driver2.embossPef(ps, document, embossingAttributeSet);
        }
        catch (EmbossException e) {
            logger.warn("Unable to emboss", (Throwable)e);
            return false;
        }
        return true;
    }

    private static final boolean setEmbosserDriver$lambda$0(String $manufacturer, String $model, Embosser e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return Intrinsics.areEqual((Object)e.getManufacturer(), (Object)$manufacturer) && Intrinsics.areEqual((Object)e.getModel(), (Object)$model);
    }

    private static final boolean setEmbosserDriver$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public EmbosserConfig() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/brailleblaster/embossers/EmbosserConfig$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getPrinterForName", "Ljavax/print/PrintService;", "name", "", "serializer", "Lkotlinx/serialization/KSerializer;", "Lorg/brailleblaster/embossers/EmbosserConfig;", "brailleblaster-core"})
    @SourceDebugExtension(value={"SMAP\nEmbosserConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbosserConfig.kt\norg/brailleblaster/embossers/EmbosserConfig$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1401#2,2:142\n*S KotlinDebug\n*F\n+ 1 EmbosserConfig.kt\norg/brailleblaster/embossers/EmbosserConfig$Companion\n*L\n109#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final PrintService getPrinterForName(String name) {
            PrintService printService;
            block1: {
                PrintService[] services = PrintServiceLookup.lookupPrintServices(DocFlavor.INPUT_STREAM.AUTOSENSE, null);
                Intrinsics.checkNotNull((Object)services);
                PrintService[] $this$firstOrNull$iv = services;
                boolean $i$f$firstOrNull = false;
                int n = $this$firstOrNull$iv.length;
                for (int i = 0; i < n; ++i) {
                    PrintService element$iv;
                    PrintService p = element$iv = $this$firstOrNull$iv[i];
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)p.getName(), (Object)name)) continue;
                    printService = element$iv;
                    break block1;
                }
                printService = null;
            }
            return printService;
        }

        @NotNull
        public final KSerializer<EmbosserConfig> serializer() {
            return EmbosserConfigSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

